#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-ase-linked-source.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_0.web.objects.ASESource import ASESource
from delphixpy.v1_5_0 import factory
from delphixpy.v1_5_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class ASELinkedSource(ASESource):
    """
    *(extends* :py:class:`v1_5_0.web.vo.ASESource` *)* A linked SAP ASE source.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("ASELinkedSource", True)
        self._config = (self.__undef__, True)
        self._external_file_path = (self.__undef__, True)
        self._load_backup_path = (self.__undef__, True)
        self._load_backup_server_name = (self.__undef__, True)
        self._monitor_location = (self.__undef__, True)
        self._operations = (self.__undef__, True)
        self._runtime = (self.__undef__, True)
        self._staging_source = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._config = (data.get("config", obj.__undef__), dirty)
        if obj._config[0] is not None and obj._config[0] is not obj.__undef__:
            assert isinstance(obj._config[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._config[0], type(obj._config[0])))
            common.validate_format(obj._config[0], "objectReference", None, None)
        obj._external_file_path = (data.get("externalFilePath", obj.__undef__), dirty)
        if obj._external_file_path[0] is not None and obj._external_file_path[0] is not obj.__undef__:
            assert isinstance(obj._external_file_path[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._external_file_path[0], type(obj._external_file_path[0])))
            common.validate_format(obj._external_file_path[0], "None", None, 1024)
        obj._load_backup_path = (data.get("loadBackupPath", obj.__undef__), dirty)
        if obj._load_backup_path[0] is not None and obj._load_backup_path[0] is not obj.__undef__:
            assert isinstance(obj._load_backup_path[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._load_backup_path[0], type(obj._load_backup_path[0])))
            common.validate_format(obj._load_backup_path[0], "None", None, 1024)
        obj._load_backup_server_name = (data.get("loadBackupServerName", obj.__undef__), dirty)
        if obj._load_backup_server_name[0] is not None and obj._load_backup_server_name[0] is not obj.__undef__:
            assert isinstance(obj._load_backup_server_name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._load_backup_server_name[0], type(obj._load_backup_server_name[0])))
            common.validate_format(obj._load_backup_server_name[0], "None", None, 128)
        if "monitorLocation" in data and data["monitorLocation"] is not None:
            obj._monitor_location = (factory.create_object(data["monitorLocation"], "ASEBackupLocation"), dirty)
            factory.validate_type(obj._monitor_location[0], "ASEBackupLocation")
        else:
            obj._monitor_location = (obj.__undef__, dirty)
        if "operations" in data and data["operations"] is not None:
            obj._operations = (factory.create_object(data["operations"], "LinkedSourceOperations"), dirty)
            factory.validate_type(obj._operations[0], "LinkedSourceOperations")
        else:
            obj._operations = (obj.__undef__, dirty)
        if "runtime" in data and data["runtime"] is not None:
            obj._runtime = (factory.create_object(data["runtime"], "ASESourceRuntime"), dirty)
            factory.validate_type(obj._runtime[0], "ASESourceRuntime")
        else:
            obj._runtime = (obj.__undef__, dirty)
        obj._staging_source = (data.get("stagingSource", obj.__undef__), dirty)
        if obj._staging_source[0] is not None and obj._staging_source[0] is not obj.__undef__:
            assert isinstance(obj._staging_source[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._staging_source[0], type(obj._staging_source[0])))
            common.validate_format(obj._staging_source[0], "objectReference", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "config" == "type" or (self.config is not self.__undef__ and (not (dirty and not self._config[1]) or isinstance(self.config, list) or belongs_to_parent)):
            dct["config"] = dictify(self.config)
        if "external_file_path" == "type" or (self.external_file_path is not self.__undef__ and (not (dirty and not self._external_file_path[1]) or isinstance(self.external_file_path, list) or belongs_to_parent)):
            dct["externalFilePath"] = dictify(self.external_file_path)
        if "load_backup_path" == "type" or (self.load_backup_path is not self.__undef__ and (not (dirty and not self._load_backup_path[1]) or isinstance(self.load_backup_path, list) or belongs_to_parent)):
            dct["loadBackupPath"] = dictify(self.load_backup_path)
        if "load_backup_server_name" == "type" or (self.load_backup_server_name is not self.__undef__ and (not (dirty and not self._load_backup_server_name[1]) or isinstance(self.load_backup_server_name, list) or belongs_to_parent)):
            dct["loadBackupServerName"] = dictify(self.load_backup_server_name)
        if "monitor_location" == "type" or (self.monitor_location is not self.__undef__ and (not (dirty and not self._monitor_location[1]) or isinstance(self.monitor_location, list) or belongs_to_parent)):
            dct["monitorLocation"] = dictify(self.monitor_location, prop_is_list_or_vo=True)
        if "operations" == "type" or (self.operations is not self.__undef__ and (not (dirty and not self._operations[1]) or isinstance(self.operations, list) or belongs_to_parent)):
            dct["operations"] = dictify(self.operations, prop_is_list_or_vo=True)
        if "runtime" == "type" or (self.runtime is not self.__undef__ and (not (dirty and not self._runtime[1]))):
            dct["runtime"] = dictify(self.runtime)
        if "staging_source" == "type" or (self.staging_source is not self.__undef__ and (not (dirty and not self._staging_source[1]))):
            dct["stagingSource"] = dictify(self.staging_source)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._config = (self._config[0], True)
        self._external_file_path = (self._external_file_path[0], True)
        self._load_backup_path = (self._load_backup_path[0], True)
        self._load_backup_server_name = (self._load_backup_server_name[0], True)
        self._monitor_location = (self._monitor_location[0], True)
        self._operations = (self._operations[0], True)
        self._runtime = (self._runtime[0], True)
        self._staging_source = (self._staging_source[0], True)

    def is_dirty(self):
        return any([self._config[1], self._external_file_path[1], self._load_backup_path[1], self._load_backup_server_name[1], self._monitor_location[1], self._operations[1], self._runtime[1], self._staging_source[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ASELinkedSource):
            return False
        return super().__eq__(other) and \
               self.config == other.config and \
               self.external_file_path == other.external_file_path and \
               self.load_backup_path == other.load_backup_path and \
               self.load_backup_server_name == other.load_backup_server_name and \
               self.monitor_location == other.monitor_location and \
               self.operations == other.operations and \
               self.runtime == other.runtime and \
               self.staging_source == other.staging_source

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def config(self):
        """
        Reference to the configuration for the source.

        :rtype: ``str``
        """
        return self._config[0]

    @config.setter
    def config(self, value):
        self._config = (value, True)

    @property
    def external_file_path(self):
        """
        External file path.

        :rtype: ``str``
        """
        return self._external_file_path[0]

    @external_file_path.setter
    def external_file_path(self, value):
        self._external_file_path = (value, True)

    @property
    def load_backup_path(self):
        """
        Source database backup location.

        :rtype: ``str``
        """
        return self._load_backup_path[0]

    @load_backup_path.setter
    def load_backup_path(self, value):
        self._load_backup_path = (value, True)

    @property
    def load_backup_server_name(self):
        """
        Source database backup server instance name used for loading.

        :rtype: ``str``
        """
        return self._load_backup_server_name[0]

    @load_backup_server_name.setter
    def load_backup_server_name(self, value):
        self._load_backup_server_name = (value, True)

    @property
    def monitor_location(self):
        """
        Location of backup server used by the source.

        :rtype: :py:class:`v1_5_0.web.vo.ASEBackupLocation`
        """
        return self._monitor_location[0]

    @monitor_location.setter
    def monitor_location(self, value):
        self._monitor_location = (value, True)

    @property
    def operations(self):
        """
        User-specified operation hooks for this source.

        :rtype: :py:class:`v1_5_0.web.vo.LinkedSourceOperations`
        """
        return self._operations[0]

    @operations.setter
    def operations(self, value):
        self._operations = (value, True)

    @property
    def runtime(self):
        """
        Runtime properties of this source.

        :rtype: :py:class:`v1_5_0.web.vo.ASESourceRuntime`
        """
        return self._runtime[0]

    @runtime.setter
    def runtime(self, value):
        self._runtime = (value, True)

    @property
    def staging_source(self):
        """
        The staging source for validated sync of the database.

        :rtype: ``str``
        """
        return self._staging_source[0]

    @staging_source.setter
    def staging_source(self, value):
        self._staging_source = (value, True)

