#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-mssql-source-runtime.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_3.web.objects.SourceRuntime import SourceRuntime
from delphixpy.v1_5_3 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class MSSqlSourceRuntime(SourceRuntime):
    """
    *(extends* :py:class:`v1_5_3.web.vo.SourceRuntime` *)* Runtime (non-
    persistent) properties of a MSSQL source.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("MSSqlSourceRuntime", True)
        self._recovery_model = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._recovery_model = (data.get("recoveryModel", obj.__undef__), dirty)
        if obj._recovery_model[0] is not None and obj._recovery_model[0] is not obj.__undef__:
            assert isinstance(obj._recovery_model[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._recovery_model[0], type(obj._recovery_model[0])))
            assert obj._recovery_model[0] in ['SIMPLE', 'BULK_LOGGED', 'FULL', 'UNKNOWN'], "Expected enum ['SIMPLE', 'BULK_LOGGED', 'FULL', 'UNKNOWN'] but got %s" % obj._recovery_model[0]
            common.validate_format(obj._recovery_model[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "recovery_model" == "type" or (self.recovery_model is not self.__undef__ and (not (dirty and not self._recovery_model[1]))):
            dct["recoveryModel"] = dictify(self.recovery_model)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._recovery_model = (self._recovery_model[0], True)

    def is_dirty(self):
        return any([self._recovery_model[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, MSSqlSourceRuntime):
            return False
        return super().__eq__(other) and \
               self.recovery_model == other.recovery_model

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def recovery_model(self):
        """
        *(default value: UNKNOWN)* Recovery model of the database. *(permitted
        values: SIMPLE, BULK_LOGGED, FULL, UNKNOWN)*

        :rtype: ``str``
        """
        return self._recovery_model[0]

    @recovery_model.setter
    def recovery_model(self, value):
        self._recovery_model = (value, True)

