#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-mssql-db-config.json
#
# Do not edit this file manually!
#

from delphixpy.v1_6_1.web.objects.SourceConfig import SourceConfig
from delphixpy.v1_6_1 import factory
from delphixpy.v1_6_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class MSSqlDBConfig(SourceConfig):
    """
    *(extends* :py:class:`v1_6_1.web.vo.SourceConfig` *)* Configuration
    information for a MSSQL Source.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("MSSqlDBConfig", True)
        self._credentials = (self.__undef__, True)
        self._database_name = (self.__undef__, True)
        self._recovery_model = (self.__undef__, True)
        self._repository = (self.__undef__, True)
        self._user = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "credentials" in data and data["credentials"] is not None:
            obj._credentials = (factory.create_object(data["credentials"], "Credential"), dirty)
            factory.validate_type(obj._credentials[0], "Credential")
        else:
            obj._credentials = (obj.__undef__, dirty)
        obj._database_name = (data.get("databaseName", obj.__undef__), dirty)
        if obj._database_name[0] is not None and obj._database_name[0] is not obj.__undef__:
            assert isinstance(obj._database_name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._database_name[0], type(obj._database_name[0])))
            common.validate_format(obj._database_name[0], "None", None, 128)
        obj._recovery_model = (data.get("recoveryModel", obj.__undef__), dirty)
        if obj._recovery_model[0] is not None and obj._recovery_model[0] is not obj.__undef__:
            assert isinstance(obj._recovery_model[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._recovery_model[0], type(obj._recovery_model[0])))
            assert obj._recovery_model[0] in ['FULL', 'SIMPLE', 'BULK_LOGGED', 'UNKNOWN'], "Expected enum ['FULL', 'SIMPLE', 'BULK_LOGGED', 'UNKNOWN'] but got %s" % obj._recovery_model[0]
            common.validate_format(obj._recovery_model[0], "None", None, None)
        obj._repository = (data.get("repository", obj.__undef__), dirty)
        if obj._repository[0] is not None and obj._repository[0] is not obj.__undef__:
            assert isinstance(obj._repository[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._repository[0], type(obj._repository[0])))
            common.validate_format(obj._repository[0], "objectReference", None, None)
        obj._user = (data.get("user", obj.__undef__), dirty)
        if obj._user[0] is not None and obj._user[0] is not obj.__undef__:
            assert isinstance(obj._user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._user[0], type(obj._user[0])))
            common.validate_format(obj._user[0], "None", None, 256)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "credentials" == "type" or (self.credentials is not self.__undef__ and (not (dirty and not self._credentials[1]) or isinstance(self.credentials, list) or belongs_to_parent)):
            dct["credentials"] = dictify(self.credentials, prop_is_list_or_vo=True)
        if "database_name" == "type" or (self.database_name is not self.__undef__ and (not (dirty and not self._database_name[1]) or isinstance(self.database_name, list) or belongs_to_parent)):
            dct["databaseName"] = dictify(self.database_name)
        if "recovery_model" == "type" or (self.recovery_model is not self.__undef__ and (not (dirty and not self._recovery_model[1]) or isinstance(self.recovery_model, list) or belongs_to_parent)):
            dct["recoveryModel"] = dictify(self.recovery_model)
        elif belongs_to_parent and self.recovery_model is self.__undef__:
            dct["recoveryModel"] = "SIMPLE"
        if "repository" == "type" or (self.repository is not self.__undef__ and (not (dirty and not self._repository[1]) or isinstance(self.repository, list) or belongs_to_parent)):
            dct["repository"] = dictify(self.repository)
        if "user" == "type" or (self.user is not self.__undef__ and (not (dirty and not self._user[1]) or isinstance(self.user, list) or belongs_to_parent)):
            dct["user"] = dictify(self.user)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._credentials = (self._credentials[0], True)
        self._database_name = (self._database_name[0], True)
        self._recovery_model = (self._recovery_model[0], True)
        self._repository = (self._repository[0], True)
        self._user = (self._user[0], True)

    def is_dirty(self):
        return any([self._credentials[1], self._database_name[1], self._recovery_model[1], self._repository[1], self._user[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, MSSqlDBConfig):
            return False
        return super().__eq__(other) and \
               self.credentials == other.credentials and \
               self.database_name == other.database_name and \
               self.recovery_model == other.recovery_model and \
               self.repository == other.repository and \
               self.user == other.user

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def credentials(self):
        """
        The password of the database user.

        :rtype: :py:class:`v1_6_1.web.vo.Credential`
        """
        return self._credentials[0]

    @credentials.setter
    def credentials(self, value):
        self._credentials = (value, True)

    @property
    def database_name(self):
        """
        The name of the database.

        :rtype: ``str``
        """
        return self._database_name[0]

    @database_name.setter
    def database_name(self, value):
        self._database_name = (value, True)

    @property
    def recovery_model(self):
        """
        *(default value: SIMPLE)* Specifies the current recovery model of the
        source database. *(permitted values: FULL, SIMPLE, BULK_LOGGED,
        UNKNOWN)*

        :rtype: ``str``
        """
        return self._recovery_model[0]

    @recovery_model.setter
    def recovery_model(self, value):
        self._recovery_model = (value, True)

    @property
    def repository(self):
        """
        The object reference of the source repository.

        :rtype: ``str``
        """
        return self._repository[0]

    @repository.setter
    def repository(self, value):
        self._repository = (value, True)

    @property
    def user(self):
        """
        The username of the database user.

        :rtype: ``str``
        """
        return self._user[0]

    @user.setter
    def user(self, value):
        self._user = (value, True)

