#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-timeflow-range.json
#
# Do not edit this file manually!
#

from delphixpy.v1_6_1.web.objects.TypedObject import TypedObject
from delphixpy.v1_6_1 import factory
from delphixpy.v1_6_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class TimeflowRange(TypedObject):
    """
    *(extends* :py:class:`v1_6_1.web.vo.TypedObject` *)* Time range within a
    TimeFlow.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("TimeflowRange", True)
        self._end_point = (self.__undef__, True)
        self._provisionable = (self.__undef__, True)
        self._start_point = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "endPoint" in data and data["endPoint"] is not None:
            obj._end_point = (factory.create_object(data["endPoint"], "TimeflowPoint"), dirty)
            factory.validate_type(obj._end_point[0], "TimeflowPoint")
        else:
            obj._end_point = (obj.__undef__, dirty)
        obj._provisionable = (data.get("provisionable", obj.__undef__), dirty)
        if obj._provisionable[0] is not None and obj._provisionable[0] is not obj.__undef__:
            assert isinstance(obj._provisionable[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._provisionable[0], type(obj._provisionable[0])))
            common.validate_format(obj._provisionable[0], "None", None, None)
        if "startPoint" in data and data["startPoint"] is not None:
            obj._start_point = (factory.create_object(data["startPoint"], "TimeflowPoint"), dirty)
            factory.validate_type(obj._start_point[0], "TimeflowPoint")
        else:
            obj._start_point = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "end_point" == "type" or (self.end_point is not self.__undef__ and (not (dirty and not self._end_point[1]))):
            dct["endPoint"] = dictify(self.end_point)
        if "provisionable" == "type" or (self.provisionable is not self.__undef__ and (not (dirty and not self._provisionable[1]))):
            dct["provisionable"] = dictify(self.provisionable)
        if "start_point" == "type" or (self.start_point is not self.__undef__ and (not (dirty and not self._start_point[1]))):
            dct["startPoint"] = dictify(self.start_point)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._end_point = (self._end_point[0], True)
        self._provisionable = (self._provisionable[0], True)
        self._start_point = (self._start_point[0], True)

    def is_dirty(self):
        return any([self._end_point[1], self._provisionable[1], self._start_point[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, TimeflowRange):
            return False
        return super().__eq__(other) and \
               self.end_point == other.end_point and \
               self.provisionable == other.provisionable and \
               self.start_point == other.start_point

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def end_point(self):
        """
        The ending TimeFlow point of this range.

        :rtype: :py:class:`v1_6_1.web.vo.TimeflowPoint`
        """
        return self._end_point[0]

    @end_point.setter
    def end_point(self, value):
        self._end_point = (value, True)

    @property
    def provisionable(self):
        """
        Whether or not this TimeFlow range is provisionable.

        :rtype: ``bool``
        """
        return self._provisionable[0]

    @provisionable.setter
    def provisionable(self, value):
        self._provisionable = (value, True)

    @property
    def start_point(self):
        """
        The starting TimeFlow point of this range.

        :rtype: :py:class:`v1_6_1.web.vo.TimeflowPoint`
        """
        return self._start_point[0]

    @start_point.setter
    def start_point(self, value):
        self._start_point = (value, True)

