#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-timeflow-repair-ssh.json
#
# Do not edit this file manually!
#

from delphixpy.v1_6_2.web.objects.TimeflowRepairParameters import TimeflowRepairParameters
from delphixpy.v1_6_2 import factory
from delphixpy.v1_6_2 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class TimeflowRepairSSH(TimeflowRepairParameters):
    """
    *(extends* :py:class:`v1_6_2.web.vo.TimeflowRepairParameters` *)*
    Parameters to repair log files within a TimeFlow.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("TimeflowRepairSSH", True)
        self._credentials = (self.__undef__, True)
        self._directory = (self.__undef__, True)
        self._host = (self.__undef__, True)
        self._port = (self.__undef__, True)
        self._username = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "credentials" in data and data["credentials"] is not None:
            obj._credentials = (factory.create_object(data["credentials"], "Credential"), dirty)
            factory.validate_type(obj._credentials[0], "Credential")
        else:
            obj._credentials = (obj.__undef__, dirty)
        if "directory" not in data:
            raise ValueError("Missing required property \"directory\".")
        obj._directory = (data.get("directory", obj.__undef__), dirty)
        if obj._directory[0] is not None and obj._directory[0] is not obj.__undef__:
            assert isinstance(obj._directory[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._directory[0], type(obj._directory[0])))
            common.validate_format(obj._directory[0], "None", None, None)
        if "host" not in data:
            raise ValueError("Missing required property \"host\".")
        obj._host = (data.get("host", obj.__undef__), dirty)
        if obj._host[0] is not None and obj._host[0] is not obj.__undef__:
            assert isinstance(obj._host[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._host[0], type(obj._host[0])))
            common.validate_format(obj._host[0], "None", None, None)
        obj._port = (data.get("port", obj.__undef__), dirty)
        if obj._port[0] is not None and obj._port[0] is not obj.__undef__:
            assert isinstance(obj._port[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._port[0], type(obj._port[0])))
            common.validate_format(obj._port[0], "None", None, None)
        if "username" not in data:
            raise ValueError("Missing required property \"username\".")
        obj._username = (data.get("username", obj.__undef__), dirty)
        if obj._username[0] is not None and obj._username[0] is not obj.__undef__:
            assert isinstance(obj._username[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._username[0], type(obj._username[0])))
            common.validate_format(obj._username[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "credentials" == "type" or (self.credentials is not self.__undef__ and (not (dirty and not self._credentials[1]))):
            dct["credentials"] = dictify(self.credentials)
        if "directory" == "type" or (self.directory is not self.__undef__ and (not (dirty and not self._directory[1]) or isinstance(self.directory, list) or belongs_to_parent)):
            dct["directory"] = dictify(self.directory)
        if "host" == "type" or (self.host is not self.__undef__ and (not (dirty and not self._host[1]) or isinstance(self.host, list) or belongs_to_parent)):
            dct["host"] = dictify(self.host)
        if "port" == "type" or (self.port is not self.__undef__ and (not (dirty and not self._port[1]))):
            dct["port"] = dictify(self.port)
        if "username" == "type" or (self.username is not self.__undef__ and (not (dirty and not self._username[1]) or isinstance(self.username, list) or belongs_to_parent)):
            dct["username"] = dictify(self.username)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._credentials = (self._credentials[0], True)
        self._directory = (self._directory[0], True)
        self._host = (self._host[0], True)
        self._port = (self._port[0], True)
        self._username = (self._username[0], True)

    def is_dirty(self):
        return any([self._credentials[1], self._directory[1], self._host[1], self._port[1], self._username[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, TimeflowRepairSSH):
            return False
        return super().__eq__(other) and \
               self.credentials == other.credentials and \
               self.directory == other.directory and \
               self.host == other.host and \
               self.port == other.port and \
               self.username == other.username

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def credentials(self):
        """
        User credentials. If not provided will use environment credentials for
        'username' on 'host'.

        :rtype: :py:class:`v1_6_2.web.vo.Credential`
        """
        return self._credentials[0]

    @credentials.setter
    def credentials(self, value):
        self._credentials = (value, True)

    @property
    def directory(self):
        """
        Directory on the remote server where the missing log files reside.

        :rtype: ``str``
        """
        return self._directory[0]

    @directory.setter
    def directory(self, value):
        self._directory = (value, True)

    @property
    def host(self):
        """
        Remote host to connect to.

        :rtype: ``str``
        """
        return self._host[0]

    @host.setter
    def host(self, value):
        self._host = (value, True)

    @property
    def port(self):
        """
        *(default value: 22)* SSH port to connect to.

        :rtype: ``int``
        """
        return self._port[0]

    @port.setter
    def port(self, value):
        self._port = (value, True)

    @property
    def username(self):
        """
        User name to authenticate as.

        :rtype: ``str``
        """
        return self._username[0]

    @username.setter
    def username(self, value):
        self._username = (value, True)

