#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-appdata-restoration-source.json
#
# Do not edit this file manually!
#

from delphixpy.v1_7_0.web.objects.AppDataManagedSource import AppDataManagedSource
from delphixpy.v1_7_0 import factory
from delphixpy.v1_7_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class AppDataRestorationSource(AppDataManagedSource):
    """
    *(extends* :py:class:`v1_7_0.web.vo.AppDataManagedSource` *)* A restoration
    AppData source.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("AppDataRestorationSource", True)
        self._additional_mount_points = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._additional_mount_points = []
        for item in data.get("additionalMountPoints") or []:
            obj._additional_mount_points.append(factory.create_object(item))
            factory.validate_type(obj._additional_mount_points[-1], "AppDataAdditionalMountPoint")
        obj._additional_mount_points = (obj._additional_mount_points, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "additional_mount_points" == "type" or (self.additional_mount_points is not self.__undef__ and (not (dirty and not self._additional_mount_points[1]) or isinstance(self.additional_mount_points, list) or belongs_to_parent)):
            dct["additionalMountPoints"] = dictify(self.additional_mount_points, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._additional_mount_points = (self._additional_mount_points[0], True)

    def is_dirty(self):
        return any([self._additional_mount_points[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, AppDataRestorationSource):
            return False
        return super().__eq__(other) and \
               self.additional_mount_points == other.additional_mount_points

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def additional_mount_points(self):
        """
        Locations to mount subdirectories of the dataset in addition to the
        normal target mount point. These paths will be mounted and unmounted as
        part of enabling and disabling this source.

        :rtype: ``list`` of
            :py:class:`v1_7_0.web.vo.AppDataAdditionalMountPoint`
        """
        return self._additional_mount_points[0]

    @additional_mount_points.setter
    def additional_mount_points(self, value):
        self._additional_mount_points = (value, True)

