#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-schedule.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class Schedule(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* Represent a
    schedule in the Delphix system.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("Schedule", True)
        self._cron_string = (self.__undef__, True)
        self._cutoff_time = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._cron_string = (data.get("cronString", obj.__undef__), dirty)
        if obj._cron_string[0] is not None and obj._cron_string[0] is not obj.__undef__:
            assert isinstance(obj._cron_string[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._cron_string[0], type(obj._cron_string[0])))
            common.validate_format(obj._cron_string[0], "None", None, 120)
        obj._cutoff_time = (data.get("cutoffTime", obj.__undef__), dirty)
        if obj._cutoff_time[0] is not None and obj._cutoff_time[0] is not obj.__undef__:
            assert isinstance(obj._cutoff_time[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._cutoff_time[0], type(obj._cutoff_time[0])))
            common.validate_format(obj._cutoff_time[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "cron_string" == "type" or (self.cron_string is not self.__undef__ and (not (dirty and not self._cron_string[1]) or isinstance(self.cron_string, list) or belongs_to_parent)):
            dct["cronString"] = dictify(self.cron_string)
        if "cutoff_time" == "type" or (self.cutoff_time is not self.__undef__ and (not (dirty and not self._cutoff_time[1]) or isinstance(self.cutoff_time, list) or belongs_to_parent)):
            dct["cutoffTime"] = dictify(self.cutoff_time)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._cron_string = (self._cron_string[0], True)
        self._cutoff_time = (self._cutoff_time[0], True)

    def is_dirty(self):
        return any([self._cron_string[1], self._cutoff_time[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, Schedule):
            return False
        return super().__eq__(other) and \
               self.cron_string == other.cron_string and \
               self.cutoff_time == other.cutoff_time

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def cron_string(self):
        """
        Schedule cron string. See CronTrigger documentation at http://quartz-
        scheduler.org/ for details.

        :rtype: ``str``
        """
        return self._cron_string[0]

    @cron_string.setter
    def cron_string(self, value):
        self._cron_string = (value, True)

    @property
    def cutoff_time(self):
        """
        Cutoff time in seconds. The policy job will suspend if not completed
        within the given time limit. A value of 0 indicates no cutoff.

        :rtype: ``int``
        """
        return self._cutoff_time[0]

    @cutoff_time.setter
    def cutoff_time(self, value):
        self._cutoff_time = (value, True)

