#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-windows-cluster-create-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.SourceEnvironmentCreateParameters import SourceEnvironmentCreateParameters
from delphixpy import factory
from delphixpy import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class WindowsClusterCreateParameters(SourceEnvironmentCreateParameters):
    """
    *(extends* :py:class:`delphixpy.web.vo.SourceEnvironmentCreateParameters`
    *)* The parameters used to create a Windows Cluster.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("WindowsClusterCreateParameters", True)
        self._cluster = (self.__undef__, True)
        self._target = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "cluster" in data and data["cluster"] is not None:
            obj._cluster = (factory.create_object(data["cluster"], "WindowsCluster"), dirty)
            factory.validate_type(obj._cluster[0], "WindowsCluster")
        else:
            obj._cluster = (obj.__undef__, dirty)
        obj._target = (data.get("target", obj.__undef__), dirty)
        if obj._target[0] is not None and obj._target[0] is not obj.__undef__:
            assert isinstance(obj._target[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._target[0], type(obj._target[0])))
            common.validate_format(obj._target[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "cluster" == "type" or (self.cluster is not self.__undef__ and (not (dirty and not self._cluster[1]) or isinstance(self.cluster, list) or belongs_to_parent)):
            dct["cluster"] = dictify(self.cluster, prop_is_list_or_vo=True)
        if "target" == "type" or (self.target is not self.__undef__ and (not (dirty and not self._target[1]) or isinstance(self.target, list) or belongs_to_parent)):
            dct["target"] = dictify(self.target)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._cluster = (self._cluster[0], True)
        self._target = (self._target[0], True)

    def is_dirty(self):
        return any([self._cluster[1], self._target[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, WindowsClusterCreateParameters):
            return False
        return super().__eq__(other) and \
               self.cluster == other.cluster and \
               self.target == other.target

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def cluster(self):
        """
        The representation of the cluster object.

        :rtype: :py:class:`delphixpy.web.vo.WindowsCluster`
        """
        return self._cluster[0]

    @cluster.setter
    def cluster(self, value):
        self._cluster = (value, True)

    @property
    def target(self):
        """
        Create as a target environment.

        :rtype: ``bool``
        """
        return self._target[0]

    @target.setter
    def target(self, value):
        self._target = (value, True)

