# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['basedosdados']

package_data = \
{'': ['*'],
 'basedosdados': ['configs/*',
                  'configs/templates/dataset/*',
                  'configs/templates/table/*']}

install_requires = \
['Jinja2==2.11.2',
 'click==7.1.2',
 'google-cloud-bigquery==1.28.0',
 'google-cloud-storage==1.31.2',
 'pandas-gbq==0.13.2',
 'pyaml==20.4.0',
 'tomlkit==0.7.0']

entry_points = \
{'console_scripts': ['basedosdados = basedosdados.cli:cli']}

setup_kwargs = {
    'name': 'basedosdados',
    'version': '0.1.2',
    'description': 'Organizar e facilitar o acesso a dados brasileiros através de tabelas públicas no BigQuery.',
    'long_description': '# A Base dos Dados  🗂️\n\nO intuito do projeto é organizar e facilitar o acesso a dados brasileiros através de tabelas públicas no BigQuery.\nQualquer pessoa poderá fazer queries em bases tratadas e documentadas que estarão disponíveis e estáveis.\n\nUma simples consulta de SQL será o suficiente para cruzamento de bases que você desejar. Sem precisar procurar, baixar, tratar, comprar um servidor e subir clusters.\n\n**Incentivamos que outras instituições e pessoas contribuam**. Só é requerido que o processo de captura e tratamento sejam públicos e documentados, e a inserção dos dados no BigQuery siga nossa metodologia descrita abaixo.\n\n#### Porque o BigQuery?\n\nSabemos que estruturar os dados em uma plataforma privada não é o ideal para um projeto de dados abertos. Porém o BigQuery oferece uma infraestrutura com algumas vantagens:\n\n- É possível deixar os dados públicos, i.e., qualquer pessoa com uma conta no Google Cloud pode fazer uma query na base, quando quiser\n- O usuário (quem faz a query) paga por ela. Isso deixa os custos do projeto bem baixos\n- O BigQuery escala magicamente para hexabytes se necessário\n- O custo é praticamente zero para usuários. São cobrados somente 5 dólares por terabyte de dados que sua query percorrer, e os primeiros 5 terabytes são gratuitos.\n\n#### Instale o CLI localmente\n\n```sh\nmake create-env\n. .bases/bin/activate\n```\n\n# Como organizar as bases no BigQuery?\n\nAs bases tem que ser organizadas no BigQuery de maneira consistente, que permita uma busca fácil e intuitiva, e seja escalável.\n\nPara isso, existem dois níveis de organização: _datasets_ e _tables_, nos quais:\n- Todas as tabelas devem estar organizadas em _datasets_\n- Cada tabela deve pertencer a um único _dataset_\n\nAs diretrizes para nomenclatura dos _datasets_ e tabelas são descritas abaixo:\n\n|           | Dataset                      | Tabela                           |\n|-----------|-----------------------------|----------------------------------|\n| Mundial   | mundo_\\<tema\\>_\\<instituicao\\>      | \\<descrição\\>                        |\n| Federal   | \\<pais\\> _ \\<tema\\> _ \\<instituicao\\>       | \\<descrição\\>                       |\n| Estadual  | \\<pais\\> _ \\<estado\\> _ \\<tema\\> _ \\<instituicao\\>     | \\<descrição\\>       |\n| Municipal | \\<pais\\> _ \\<estado\\> _ \\<cidade\\> _ \\<tema\\> _ \\<instituicao\\> | \\<descrição\\>       |\n\n- Utilizar somente letras minúsculas\n- Remover acentos, pontuações e espaços\n\n### Bases Desejadas\n\n[Lista de bases mapeadas](https://docs.google.com/spreadsheets/d/1t9kEsiyatmmdDCy2qjaCjLqdw-oJj33P7tY5bnkR0aw/edit#gid=0) que estão no nosso mapa.\n\n\n## Mundial -- Clima, Waze\n\n### Dataset:\n\nUsar abrangência, um tema e nome da instituição\n\n`mundo_<tema>_<instituicao>`\n\n### Tabela:\n\nUsar nome descritivo e único para os dados\n\n`<descrição>`\n\nExemplo: Os dados de alertas do Waze estariam no dataset `mundo_mobilidade_waze` e tabela `alertas`. Portanto, o caminho seria `mundo_mobilidade_waze`.`alertas`.\n\n## Federal -- IBGE, IPEA, Senado, Camara, TSE\n\n### Dataset:\n\nUsar sigla do país, um tema e nome da instituição\n\n`<pais>_<tema>_<instituicao>`\n\n### Tabela:\n\nUsar nome descritivo e único para os dados:\n\n`<descrição>`\n\nExemplo: Os dados de candidatos do TSE estariam no dataset `br-eleicoes-tse` e na tabela `candidatos`.\n\n## Estadual \n\n### Dataset:\n\nUsar país e sigla do estado (UF).\n\n`<pais>_<estado>`\n\n### Tabela:\n\nUsar nome da instuição estadual, tema e descrição\n\n`<instituicao>_<tema>_<descrição>`\n\n\nExemplo: Os dados da rede de esgoto da SANASA que atende no estado de São Paulo estariam no dataset `br-sp` e tabela `sanasa-sanementobasico-redeesgoto`.\n\n## Municipal\n\n### Dataset:\n\nUsar sigla do país, sigla do estado (UF), nome da cidade (sem espaço)\n\n`<pais>_<estado>_<cidade>`\n\n### Tabela:\n\nUsar nome da instuição estadual, tema e descrição\n\n`<instituicao>_<tema>_<descrição>`\n\nExemplo: Os dados de votações da camara municipal do rio de janeiro estariam em `br-rj-riodejaneiro` e tabela `dcmrj-legislativo-legislativo`\n\n## Tabela de Temas e Identificadores\n\nA referencia dos temas é da busca da Base dos Dados, mas temas podem ser adicionados e trocados. Identificadores serão adicionados de acordo com demanda.\n| Tema                                     | Identificador    |\n|------------------------------------------|------------------|\n| Agropecuária                             | agropecuaria     |\n| Ciência, Tecnologia e Inovação           | ciencia_tec_inov |\n| Cultura e Arte                           | cultura_arte     |\n| Diversidade e Inclusão                   | diversidade      |\n| Educação                                 | educacao         |\n| Energia                                  | energia          |\n| Esportes                                 | esportes         |\n| Economia                                 | economia         |\n| Governo e Finanças Públicas              | governo          |\n| História                                 | historia         |\n| Infraestrutura e Transportes             | infr_transp      |\n| Jornalismo e Comunicação                 | jornalismo       |\n| Meio Ambiente                            | meio_ambiente    |\n| Justiça                                  | justica          |\n| Organização Territorial                  | territorio       |\n| Política                                 | politica         |\n| População                                | populacao        |\n| Religião                                 | religiao         |\n| Segurança, Crime, Violência e Conflito   | seguranca        |\n| Saúde                                    | saude            |\n| Turismo                                  | turismo          |\n| Urbanização                              | urbanizacao      |\n\n# Estrutura do Github\n\nA pasta `bases/` terá uma estrutura similar a do BigQuery.\n\n```\n    ├── bases\n        ├── <nome_dataset>             Ex: br_eleicoes_tse\n        ├── ...\n            ├── code/                 Todo código relacionado ao dataset\n            ├── <dataset_config.yaml>\n            ├── <nome_tabela>.yaml    Ex: candidatos.yaml\n            ├── ...\n```\n\nOs arquivos `.yaml` serão usados para documentação e configuração das tabelas e datasets.\n\n### dataset_config.yaml\n\n```yaml\nname: br_politica_tse\ndescription: |\n    Dados do Tribunal Superior Eleitoral disponíveis na url ...\nlabels: \n    - eleicao\n    - candidatos\n```\n\n### <nome_tabela>.yaml\n\n```yaml\nowner: \n    name: Base dos Dados # Ou qualquer outra instituição/ pessoa\n    contact: bdd-issues\ncode: <code-that-generated-table-url>\nname: eleicao_candidatos\ndescription: |\n    Candidatos das eleições federais e municipais de 2010 até 2020\n\n    Tratamentos:\n     - ...\nlabels:\n    - eleicao\n    - candidatos\ncolumns:\n    ANO:\n        description: asdfsfasf\n        type: INTEGER\n        treated?: False # A coluna foi modificada (exceto mudançã de tipos)?\n    NOME:\n        description: asdfsfasf\n        type: STRING\n        treated?: False # A coluna foi modificada (exceto mudançã de tipos)?\n```\n\n# Estrutura no Storage\n\nA estrutura deve seguir a mesma lógica do BigQuery. Porém, existem pastas raízes diferentes: os dados brutos devem ser alocados em `raw` e prontos em `ready`. Ambas possuem a mesma estrutura:\n\n```\n    ├── ready|raw\n        ├── <nome_dataset>        Ex: br_politica_tse\n        ├── ...\n            ├── <nome_tabela>    Ex: eleicao_candidatos\n            ├── ...\n                ├── <dados>      Dados particionados ou não.\n```\n\nNem todos os dados necessitam estar na pasta `raw`. Essa pasta existe somente para aqueles que precisam de um processamento prévio. \n\n# Tratamento no Bigquery\n\nO BigQuery é uma ótima ferramenta para tratar as bases. Portanto, recomenda-se\nque subir os dados brutos e usar uma query para tratá-los. Seja para corrigir tipos\nou adicionar colunas úteis.\n\nPara isso, deverá ser criado uma dataset com o mesmo nome, mas precedido de `raw_`.\n\nExemplo: `raw_br_politica_tse`\n\nE todas as tabelas desse dataset serão consideradas brutas e não deverão ser abertas\nao público.\n\n# Regras de Tratamento das Bases\n\n- Nunca editar os valores da base. Se for o caso de tratar uma coluna, adicionar uma nova coluna com os dados tratados.\n\n- Os tipos do BigQuery devem ser usados apropriadamente.\n\n- Códigos dos Municípios e Estados brasileiros devem seguir o padrão do IBGE.\n\n- Não normalizar campos de texto usando maíusculas.\n\n- O código para reproduzir o tratamento deve ser aberto.\n\n- Valores nulos devem ser convertidos para `None`.\n\n# Idiomas\n\nToda documentação estará em português (quando possível). O código e configurações estará em inglês.\n',
    'author': 'Joao Carabetta',
    'author_email': 'joao.carabetta@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/base-dos-dados/bases',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
