"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Capabilities that affect whether CloudFormation is allowed to change IAM resources
 */
var CfnCapabilities;
(function (CfnCapabilities) {
    /**
     * No IAM Capabilities
     *
     * Pass this capability if you wish to block the creation IAM resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CfnCapabilities["NONE"] = "";
    /**
     * Capability to create anonymous IAM resources
     *
     * Pass this capability if you're only creating anonymous resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CfnCapabilities["ANONYMOUS_IAM"] = "CAPABILITY_IAM";
    /**
     * Capability to create named IAM resources.
     *
     * Pass this capability if you're creating IAM resources that have physical
     * names.
     *
     * `CloudFormationCapabilities.NamedIAM` implies `CloudFormationCapabilities.IAM`; you don't have to pass both.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CfnCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /**
     * Capability to run CloudFormation macros
     *
     * Pass this capability if your template includes macros, for example AWS::Include or AWS::Serverless.
     *
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     */
    CfnCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(CfnCapabilities = exports.CfnCapabilities || (exports.CfnCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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