"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const options_1 = require("./options");
const utils_1 = require("./utils");
function copyDirectory(srcDir, destDir, options = {}, rootDir) {
    const follow = options.follow !== undefined ? options.follow : options_1.SymlinkFollowMode.EXTERNAL;
    const exclude = options.exclude || [];
    rootDir = rootDir || srcDir;
    if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
    }
    const files = fs.readdirSync(srcDir);
    for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (utils_1.shouldExclude(exclude, path.relative(rootDir, sourceFilePath))) {
            continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === options_1.SymlinkFollowMode.ALWAYS
            ? fs.statSync(sourceFilePath)
            : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
            const target = fs.readlinkSync(sourceFilePath);
            // determine if this is an external link (i.e. the target's absolute path
            // is outside of the root directory).
            const targetPath = path.normalize(path.resolve(srcDir, target));
            if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
                stat = fs.statSync(sourceFilePath);
            }
            else {
                fs.symlinkSync(target, destFilePath);
                stat = undefined;
            }
        }
        if (stat && stat.isDirectory()) {
            fs.mkdirSync(destFilePath);
            copyDirectory(sourceFilePath, destFilePath, options, rootDir);
            stat = undefined;
        }
        if (stat && stat.isFile()) {
            fs.copyFileSync(sourceFilePath, destFilePath);
            stat = undefined;
        }
    }
}
exports.copyDirectory = copyDirectory;
//# sourceMappingURL=data:application/json;base64,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