"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable-next-line:ban-types
function captureStackTrace(below) {
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: '' };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack.split('\n').slice(1).map(s => s.replace(/^\s*at\s+/, ''));
}
exports.captureStackTrace = captureStackTrace;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stdHJhY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay10cmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFxQztBQUNyQyxTQUFnQixpQkFBaUIsQ0FBQyxLQUFnQjtJQUNoRCxLQUFLLEdBQUcsS0FBSyxJQUFJLGlCQUFpQixDQUFDLENBQUMsOEJBQThCO0lBQ2xFLE1BQU0sTUFBTSxHQUFHLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDO0lBQzdCLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7SUFDNUMsSUFBSTtRQUNGLEtBQUssQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2hELEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUM7S0FDeEM7WUFBUztRQUNSLEtBQUssQ0FBQyxlQUFlLEdBQUcsYUFBYSxDQUFDO0tBQ3ZDO0lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7UUFDakIsT0FBTyxFQUFFLENBQUM7S0FDWDtJQUNELE9BQU8sTUFBTSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDaEYsQ0FBQztBQWRELDhDQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gdHNsaW50OmRpc2FibGUtbmV4dC1saW5lOmJhbi10eXBlc1xuZXhwb3J0IGZ1bmN0aW9uIGNhcHR1cmVTdGFja1RyYWNlKGJlbG93PzogRnVuY3Rpb24pOiBzdHJpbmdbXSB7XG4gIGJlbG93ID0gYmVsb3cgfHwgY2FwdHVyZVN0YWNrVHJhY2U7IC8vIGhpZGUgbXlzZWxmIGlmIG5vdGhpbmcgZWxzZVxuICBjb25zdCBvYmplY3QgPSB7IHN0YWNrOiAnJyB9O1xuICBjb25zdCBwcmV2aW91c0xpbWl0ID0gRXJyb3Iuc3RhY2tUcmFjZUxpbWl0O1xuICB0cnkge1xuICAgIEVycm9yLnN0YWNrVHJhY2VMaW1pdCA9IE51bWJlci5NQVhfU0FGRV9JTlRFR0VSO1xuICAgIEVycm9yLmNhcHR1cmVTdGFja1RyYWNlKG9iamVjdCwgYmVsb3cpO1xuICB9IGZpbmFsbHkge1xuICAgIEVycm9yLnN0YWNrVHJhY2VMaW1pdCA9IHByZXZpb3VzTGltaXQ7XG4gIH1cbiAgaWYgKCFvYmplY3Quc3RhY2spIHtcbiAgICByZXR1cm4gW107XG4gIH1cbiAgcmV0dXJuIG9iamVjdC5zdGFjay5zcGxpdCgnXFxuJykuc2xpY2UoMSkubWFwKHMgPT4gcy5yZXBsYWNlKC9eXFxzKmF0XFxzKy8sICcnKSk7XG59XG4iXX0=