# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *
from .vpc_cni import VpcCni
import pulumi_aws
import pulumi_kubernetes

__all__ = ['NodeGroupArgs', 'NodeGroup']

@pulumi.input_type
class NodeGroupArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input['CoreDataArgs'],
                 ami_id: Optional[pulumi.Input[str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[str]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile: Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 node_user_data_override: Optional[pulumi.Input[str]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NodeGroup resource.
        :param pulumi.Input['CoreDataArgs'] cluster: The target EKS cluster.
        :param pulumi.Input[str] ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[str] bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. Fror details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroupRule'] cluster_ingress_rule: The ingress rule that gives node group access.
        :param pulumi.Input[int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param pulumi.Input['pulumi_aws.iam.InstanceProfile'] instance_profile: The ingress rule that gives node group access.
        :param pulumi.Input[str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        :param pulumi.Input[str] key_name: Name of the key pair to use for SSH access to worker nodes.
        :param pulumi.Input[str] kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the expicit `kubeletExtraArgs`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Custom k8s node labels to be attached to each woker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param pulumi.Input[int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[bool] node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param pulumi.Input[str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[str] node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param pulumi.Input[str] spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param pulumi.Input[str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        pulumi.set(__self__, "cluster", cluster)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if auto_scaling_group_tags is not None:
            pulumi.set(__self__, "auto_scaling_group_tags", auto_scaling_group_tags)
        if bootstrap_extra_args is not None:
            pulumi.set(__self__, "bootstrap_extra_args", bootstrap_extra_args)
        if cloud_formation_tags is not None:
            pulumi.set(__self__, "cloud_formation_tags", cloud_formation_tags)
        if cluster_ingress_rule is not None:
            pulumi.set(__self__, "cluster_ingress_rule", cluster_ingress_rule)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if encrypt_root_block_device is not None:
            pulumi.set(__self__, "encrypt_root_block_device", encrypt_root_block_device)
        if extra_node_security_groups is not None:
            pulumi.set(__self__, "extra_node_security_groups", extra_node_security_groups)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if instance_profile is not None:
            pulumi.set(__self__, "instance_profile", instance_profile)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kubelet_extra_args is not None:
            pulumi.set(__self__, "kubelet_extra_args", kubelet_extra_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if node_associate_public_ip_address is not None:
            pulumi.set(__self__, "node_associate_public_ip_address", node_associate_public_ip_address)
        if node_public_key is not None:
            pulumi.set(__self__, "node_public_key", node_public_key)
        if node_root_volume_size is not None:
            pulumi.set(__self__, "node_root_volume_size", node_root_volume_size)
        if node_security_group is not None:
            pulumi.set(__self__, "node_security_group", node_security_group)
        if node_subnet_ids is not None:
            pulumi.set(__self__, "node_subnet_ids", node_subnet_ids)
        if node_user_data is not None:
            pulumi.set(__self__, "node_user_data", node_user_data)
        if node_user_data_override is not None:
            pulumi.set(__self__, "node_user_data_override", node_user_data_override)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input['CoreDataArgs']:
        """
        The target EKS cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input['CoreDataArgs']):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter(name="autoScalingGroupTags")
    def auto_scaling_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.

        Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "auto_scaling_group_tags")

    @auto_scaling_group_tags.setter
    def auto_scaling_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "auto_scaling_group_tags", value)

    @property
    @pulumi.getter(name="bootstrapExtraArgs")
    def bootstrap_extra_args(self) -> Optional[pulumi.Input[str]]:
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. Fror details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        """
        return pulumi.get(self, "bootstrap_extra_args")

    @bootstrap_extra_args.setter
    def bootstrap_extra_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_extra_args", value)

    @property
    @pulumi.getter(name="cloudFormationTags")
    def cloud_formation_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the CloudFormation Stack of the Worker NodeGroup.

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "cloud_formation_tags")

    @cloud_formation_tags.setter
    def cloud_formation_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cloud_formation_tags", value)

    @property
    @pulumi.getter(name="clusterIngressRule")
    def cluster_ingress_rule(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule")

    @cluster_ingress_rule.setter
    def cluster_ingress_rule(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]):
        pulumi.set(self, "cluster_ingress_rule", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="encryptRootBlockDevice")
    def encrypt_root_block_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt the root block device of the nodes in the node group.
        """
        return pulumi.get(self, "encrypt_root_block_device")

    @encrypt_root_block_device.setter
    def encrypt_root_block_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_root_block_device", value)

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]:
        """
        Extra security groups to attach on all nodes in this worker node group.

        This additional set of security groups captures any user application rules that will be needed for the nodes.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @extra_node_security_groups.setter
    def extra_node_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]):
        pulumi.set(self, "extra_node_security_groups", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']]:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "instance_profile")

    @instance_profile.setter
    def instance_profile(self, value: Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']]):
        pulumi.set(self, "instance_profile", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the key pair to use for SSH access to worker nodes.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kubeletExtraArgs")
    def kubelet_extra_args(self) -> Optional[pulumi.Input[str]]:
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the expicit `kubeletExtraArgs`.
        """
        return pulumi.get(self, "kubelet_extra_args")

    @kubelet_extra_args.setter
    def kubelet_extra_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubelet_extra_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom k8s node labels to be attached to each woker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="nodeAssociatePublicIpAddress")
    def node_associate_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        return pulumi.get(self, "node_associate_public_ip_address")

    @node_associate_public_ip_address.setter
    def node_associate_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_associate_public_ip_address", value)

    @property
    @pulumi.getter(name="nodePublicKey")
    def node_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        return pulumi.get(self, "node_public_key")

    @node_public_key.setter
    def node_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_public_key", value)

    @property
    @pulumi.getter(name="nodeRootVolumeSize")
    def node_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        return pulumi.get(self, "node_root_volume_size")

    @node_root_volume_size.setter
    def node_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_size", value)

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]:
        """
        The security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group")

    @node_security_group.setter
    def node_security_group(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]):
        pulumi.set(self, "node_security_group", value)

    @property
    @pulumi.getter(name="nodeSubnetIds")
    def node_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of subnets to override and use for the worker node group.

        Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        """
        return pulumi.get(self, "node_subnet_ids")

    @node_subnet_ids.setter
    def node_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_subnet_ids", value)

    @property
    @pulumi.getter(name="nodeUserData")
    def node_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        return pulumi.get(self, "node_user_data")

    @node_user_data.setter
    def node_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data", value)

    @property
    @pulumi.getter(name="nodeUserDataOverride")
    def node_user_data_override(self) -> Optional[pulumi.Input[str]]:
        """
        User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        """
        return pulumi.get(self, "node_user_data_override")

    @node_user_data_override.setter
    def node_user_data_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data_override", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bidding price for spot instance. If set, only spot instances will be added as worker node.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]:
        """
        Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class NodeGroup(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[str]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster: Optional[pulumi.Input[pulumi.InputType['CoreDataArgs']]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile: Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 node_user_data_override: Optional[pulumi.Input[str]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['TaintArgs']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        NodeGroup is a component that wraps the AWS EC2 instances that provide compute capacity for an EKS cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[str] bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. Fror details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[pulumi.InputType['CoreDataArgs']] cluster: The target EKS cluster.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroupRule'] cluster_ingress_rule: The ingress rule that gives node group access.
        :param pulumi.Input[int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param pulumi.Input['pulumi_aws.iam.InstanceProfile'] instance_profile: The ingress rule that gives node group access.
        :param pulumi.Input[str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        :param pulumi.Input[str] key_name: Name of the key pair to use for SSH access to worker nodes.
        :param pulumi.Input[str] kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the expicit `kubeletExtraArgs`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Custom k8s node labels to be attached to each woker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param pulumi.Input[int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[bool] node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param pulumi.Input[str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[str] node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param pulumi.Input[str] spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['TaintArgs']]]] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param pulumi.Input[str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        NodeGroup is a component that wraps the AWS EC2 instances that provide compute capacity for an EKS cluster.

        :param str resource_name: The name of the resource.
        :param NodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[str]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster: Optional[pulumi.Input[pulumi.InputType['CoreDataArgs']]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile: Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 node_user_data_override: Optional[pulumi.Input[str]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['TaintArgs']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupArgs.__new__(NodeGroupArgs)

            __props__.__dict__["ami_id"] = ami_id
            __props__.__dict__["auto_scaling_group_tags"] = auto_scaling_group_tags
            __props__.__dict__["bootstrap_extra_args"] = bootstrap_extra_args
            __props__.__dict__["cloud_formation_tags"] = cloud_formation_tags
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["cluster_ingress_rule"] = cluster_ingress_rule
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["encrypt_root_block_device"] = encrypt_root_block_device
            __props__.__dict__["extra_node_security_groups"] = extra_node_security_groups
            __props__.__dict__["gpu"] = gpu
            __props__.__dict__["instance_profile"] = instance_profile
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kubelet_extra_args"] = kubelet_extra_args
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["node_associate_public_ip_address"] = node_associate_public_ip_address
            __props__.__dict__["node_public_key"] = node_public_key
            __props__.__dict__["node_root_volume_size"] = node_root_volume_size
            __props__.__dict__["node_security_group"] = node_security_group
            __props__.__dict__["node_subnet_ids"] = node_subnet_ids
            __props__.__dict__["node_user_data"] = node_user_data
            __props__.__dict__["node_user_data_override"] = node_user_data_override
            __props__.__dict__["spot_price"] = spot_price
            __props__.__dict__["taints"] = taints
            __props__.__dict__["version"] = version
            __props__.__dict__["auto_scaling_group_name"] = None
            __props__.__dict__["cfn_stack"] = None
        super(NodeGroup, __self__).__init__(
            'eks:index:NodeGroup',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="autoScalingGroupName")
    def auto_scaling_group_name(self) -> pulumi.Output[str]:
        """
        The AutoScalingGroup name for the Node group.
        """
        return pulumi.get(self, "auto_scaling_group_name")

    @property
    @pulumi.getter(name="cfnStack")
    def cfn_stack(self) -> pulumi.Output['pulumi_aws.cloudformation.Stack']:
        """
        The CloudFormation Stack which defines the Node AutoScalingGroup.
        """
        return pulumi.get(self, "cfn_stack")

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.SecurityGroup']]:
        """
        The additional security groups for the node group that captures user-specific rules.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> pulumi.Output['pulumi_aws.ec2.SecurityGroup']:
        """
        The security group for the node group to communicate with the cluster.
        """
        return pulumi.get(self, "node_security_group")

