#########################
## version
#########################

def version():
    return '0.0.20'


#########################
## imports
#########################

import pandas as pd
import random

##############################
## Misc useful stuff
##############################

def handystrings(whichone='help', toconsole=True):
    handydict = {
        "pandas width": "pd.set_option('display.max_colwidth', None)",
        "parent directory": "sys.path.append(os.path.abspath('../'))",
        "disable scrolling": '',
        "buildpackage": "python3 -m pip install --upgrade build && python3 -m build",
        "distributepackage": "python3 -m pip install --upgrade twine && python3 -m twine dist/*"
    }

    if whichone == 'help':
        response = str(handydict.keys())
    else:
        try:
            response = handydict[whichone]
        except:
            response = "entry not found, try handystrings('help')"
    if toconsole:
        print(response)
    return response


##############################
## Codegen
##############################

def featureEngTemplate(listOfFeatures, dataFrameName='df', listName='Vec'):
    for l in range(len(listOfFeatures)):
        thisFeature = listOfFeatures[l]
        print(thisFeature + listName + ' = list()')

    for l in range(len(listOfFeatures)):
        thisFeature = listOfFeatures[l]
        print(thisFeature + ' = np.nan')

    for l in range(len(listOfFeatures)):
        thisFeature = listOfFeatures[l]
        print(thisFeature + '= None')

    for l in range(len(listOfFeatures)):
        thisFeature = listOfFeatures[l]
        print("print('" + thisFeature + " = ' + str(" + thisFeature + "))")

    for l in range(len(listOfFeatures)):
        thisFeature = listOfFeatures[l]
        print(thisFeature + listName + '.append(' + thisFeature + ')')


    for l in range(len(listOfFeatures)):
        thisFeature = listOfFeatures[l]
        print(dataFrameName + "['" + thisFeature + "'] = " + thisFeature + listName)


##############################
## Misc useful stuff
##############################

def demoData(setID=1):
    # Warning, the format of the data depends on the set ID/type
    if setID == 1:
        x = [1, 2, 5, 10, 20, 50, 100, 200, 500, 1000]
        y = [1, 4, 8, 20, 30, 40, 120, 250, 700, 1100]
        return x, y

    if setID == 2:
        x1, y1, = demoData(1)
        color1 = 'r'
        label1 = 'Group data'

        y2, temp = demoData(1)
        x2 = [3, 3, 7, 30, 60, 75, 120, 250, 850, 900]
        color2 = '#3366FF'
        markersize2 = 300
        label2 = 'Control case'
        markerstyle2 = '^'

        data1 = {'x': x1, 'y': y1, 'markercolor': color1, 'label': label1}
        data2 = {'x': x2, 'y': y2, 'markercolor': color2, 'markersize': markersize2, 'label': label2,
                 'markerstyle': markerstyle2}

        return [data1, data2]

    if setID == 3:
        df = pd.DataFrame()
        df['x'], df['y'] = demoData(1)
        df['z'] = df['x'] + df['y']
        return df

    if setID == 4:
        return [random.gauss(2, 2) for _ in range(500)], [random.gauss(1, 3) for _ in range(500)]

    if setID == 5:
        # Same as #4 but deterministic
        x = [5.959838826858405, 1.1082129165979508, 1.500127065166587, 4.694460112417438, -0.36490670832999195,
             -0.20070252927580468, 3.804752905486839, 0.4683578651619531, 1.2197901101960218, -0.7687952215112137,
             -2.1045318525684173, 1.0009602323988371, 2.5292167807236616, 5.254206742290954, 6.229556508701661,
             3.2268271070154504, 2.1119152312776177, 0.2743796958495939, 4.465420997322729, -4.240503055485684,
             7.228378648865549, -1.2571859645448473, -0.9887822067698102, 3.9244579419802514, -0.8839190999855622,
             5.0256559564743375, -1.7250083165632617, -0.4273288079073265, -0.04640316164845393, -1.1017256986897568,
             2.5516405914140785, 1.5286170070174623, 5.567312577065616, 3.86743980643031, -2.571710420557822,
             0.10626135177992779, 1.3703220270201262, 1.7164131402700482, 1.6440296510217527, 5.184679702077149,
             1.448363181810574, 3.581124101445529, 6.3287590748856655, 0.20602243773725393, 1.6403551484740124,
             0.48350027569114373, -1.2842070988515295, 4.227869118967015, 0.9080166415341584, 2.2642433000718807,
             -3.1084351210718397, 2.3007302927980247, 2.0091759289144293, 1.1495020038886636, -0.5642237931224963,
             3.4509087298812826, 1.6616369596193663, 1.2762923017622927, 1.835672161752049, 0.6952061708393604,
             -1.304987401570696, 2.53554453044737, 4.45903724749455, 4.117220461718572, 3.092942080465563,
             4.5738396664026135, 0.7808552107789675, 2.2670144295459385, 1.67067376448172, 1.5230751822922737,
             0.2759308348977083, -2.5690771405533264, 3.919745202509435, 3.0517031874353524, 0.3433430125863475,
             -0.6266742052031238, -1.8838287334797066, 2.3401900403431193, 3.672316811838405, 1.3986179933235978,
             1.1906021957625041, 5.484876873106733, 0.9940405670569841, 6.925545196968477, 6.408252382348671,
             2.4330933372398817, 1.6963285657063958, 1.5044271216835967, 0.28779466394459097, 2.738342312080263,
             3.5799759258929646, 2.673344638242709, -0.5958119944655516, 2.6436061968647806, -0.7134906624093627,
             1.4038708654359566, 1.1407420231468737, 3.926403784364143, 1.9799543755744333, 3.9670944489809257,
             -1.4611674530225085, 0.9721348927756956, 5.293499207667142, 4.817812307236626, 2.308225985746815,
             -0.8406162094567198, -1.21521147611293, 0.6742793512634055, 3.401766436842369, 3.729459552006696,
             0.3846850634764296, 1.3751848152904822, 4.79928612396508, 1.5276744655940255, 3.6908587493724205,
             0.1984455596318635, 2.2027301539541293, 1.5905761194659909, 1.9614223136832054, 2.993846836036999,
             6.050652331258408, 1.82457916958053, 1.063920076118356, 0.4440920141692759, -1.1569247534462952,
             4.309693867344134, 1.2909656189001097, -2.2139303625617774, 1.7368413578420767, 2.2892054471519474,
             2.6021537312965886, 4.620077174047504, -0.22095591530756753, 4.900121435169048, 3.8705816523186556,
             3.9598175504781388, -0.9647641149948032, -1.609271018250436, -0.1715361023430928, 1.6810344877144408,
             0.820637509891154, -0.8542953116989027, -0.2703889287484693, 0.3696553792219597, 1.9187504817072147,
             2.4591049073189186, 1.0937661002634338, 3.082352395445766, 2.0904143292687682, 5.6160057232969995,
             2.2385720656423103, 0.25398638876102897, 3.255172208943502, 2.865786143498188, 3.1780987067076376,
             5.724283472923833, 2.98313008551906, 0.3135885454340839, 0.8220275446839458, -1.787918834197804,
             -0.40459993560156793, 0.7679580028367765, 4.018133682444374, 6.071112020591204, 2.083943856072694,
             4.286256779431255, -1.6794266953887114, 1.430686123876752, 1.050135719165957, -1.9893156865759831,
             2.6281183214560904, 4.341034738445971, 1.435229942963788, 2.6906462913164697, 1.5057028555574505,
             -1.4567934969854663, 2.500372123479786, 2.469166195274506, -1.2840783927857102, 1.0293403262711727,
             1.21616641494196, -0.7206033173395134, 2.1424892248934087, -2.590802856894471, -0.9816611714160861,
             5.91545158931722, 0.06064463542802634, 1.5557949092960248, -2.109779076374516, 4.261223437685091,
             4.338692402584502, 1.5350215484774323, 4.283186304270609, 2.714331470182479, 3.0478875710605013,
             0.8106828627548677, 3.9199458940504903, 4.104454206038556, -0.025087480313169763, 2.8089751352597867,
             1.3393992547136744, 1.8360258395792717, 3.797997361859456, 1.166590693065151, 0.09095590592648439,
             3.54532877028913, -0.020109541789411267, 3.5161041175963508, 2.740827068196495, 3.261690188483959,
             4.113139450243468, 5.914264694295918, 1.7117520654917548, 1.67856691082596, 3.6759411017780494,
             3.470057709561645, 1.8913266166856968, -3.8864669371975724, 0.969649267953441, 1.8650136033851066,
             1.7743303242381427, 4.454719478324491, -0.24674617418009737, 2.3829915004767117, 2.0388908430039074,
             3.2403546280508646, 3.7735703684427255, -0.23227391489176785, 1.4205626600381855, 1.6173948148614783,
             2.617666189780528, 4.21986989435827, 6.877384377435866, 6.872589827459815, -1.3787836800588096,
             1.3019732516025775, 2.6616795521591348, -0.6956770944007213, 0.0824329228379832, 0.5724942552217558,
             1.4608780929720946, 0.2507289336617404, 4.278023026942938, 2.4083873567086913, 2.798401072774128,
             -0.13744246512211022, 3.7179286679429895, 5.605952319384537, 3.574212571068726, 0.7747704513411044,
             2.5567095544463685, 1.09163575581147, 5.0785639535011295, 4.564986256223694, 1.900123640199572,
             1.2298703374657198, 1.3729748608355459, 0.46715501197206133, 4.180367944166202, 4.059799940753891,
             1.5665204499960423, 1.890107278929869, -4.169754519863653, 0.6566354304737347, 1.6153559325603162,
             2.636343128656053, 5.712497948562589, -0.432661369988407, 2.9962965967716633, 2.2500150361218543,
             2.8149345350878416, 3.1340238608579964, 1.6356439463084367, 3.4756690763493565, 1.9890627462622754,
             3.3671027784957905, 3.594540563990122, -0.45155830035047106, 2.106064340091141, 4.019463068888868,
             -3.324049198852779, 3.3809330358196266, 5.345013238658338, 2.0843433870213466, -0.10922622328016285,
             3.6254183465424425, 0.2798061089465267, -1.1959099069214911, 6.395905098728904, 2.8550703372491966,
             -0.7417092750320964, -0.6952124813424345, 2.1327348572643308, 3.306934764896641, 0.021977021289703913,
             2.137148585783654, 4.7879174775999, 1.770067195225224, 2.462114231499798, 0.9077913898400503,
             -0.693424767633779, 2.3761258317705876, -0.23653861413692878, -1.6839673570714724, 6.120192854575804,
             3.70919763869951, 0.04115359615455594, 6.700183386148171, -0.038133859484988264, 0.9974224995888283,
             4.725451627443517, 5.313099980686009, -0.417732141526558, 0.45104709466987236, 2.894036485209034,
             3.762209986585468, 2.1830793020637285, 2.9634539772063664, 4.109887808675618, 1.878965540639909,
             -0.6207185659655661, 1.2583403624549916, 4.2444561783784565, 2.1200280503927553, 1.7574446344543184,
             -0.33810475705618526, 2.1221811256975784, 4.042208900499261, -0.32820335677807977, 1.8652696472155703,
             0.835112784690476, 1.846963760896708, 2.318429059606928, 0.34998899805586237, 4.1592270775582625,
             4.954107939545622, 4.260635349590618, 1.277276217909006, 2.7742705530635265, 2.4898313357257145,
             3.0139785910439683, 1.4450431486955202, -0.09808046407538384, 3.5999161952112706, 4.324380241934729,
             -0.3606032613209833, 3.368797999296724, -0.296975170301804, 2.146036648982661, 2.8071183016516894,
             3.465585402200749, 2.890309356820014, 3.652328464985546, 3.102482732691047, -1.500972403945792,
             2.6892899046418806, 2.61403108848714, -2.5259744388879444, 0.03878795800918855, 4.609174573632043,
             2.975710658290619, 6.142195630567042, 5.218403435862153, 0.5781018433658127, 2.465464709820088,
             4.431434486039619, 4.846364417008024, 3.314157145134984, -0.6671496796038583, 5.514159241492217,
             4.304593245206362, -1.8140115132058101, 0.9701135712445106, 4.3180047600023554, 0.43951862656030594,
             2.05853789060298, 1.173336890305638, 0.04567250688675495, -0.3703932651079751, 2.476030485600019,
             1.7763926959322085, 2.2971811577773655, 0.5664177469308471, 1.1930612066150572, 6.090730115641386,
             3.701899899493843, 4.2899200048483, 1.245231091334992, 1.586272056276688, 2.646845338954205,
             4.397538054864087, 3.420511403438485, 4.404638650449927, 5.6540538254848585, -1.5871236008528258,
             -0.38556414654266113, -1.168610977813246, -3.6527049520201933, 4.721192283759525, 3.0586824683878087,
             0.7305398062163024, 4.03768050768325, 1.4814844806047, 2.7274989363537023, 2.6570762720250283,
             -1.0200583998514245, 3.134547790948071, 4.283120274999583, 1.280019555224516, 5.30159907475709,
             -0.2774687750882272, 0.9063492252081973, 3.27056426376625, 5.315602692117011, 2.0770016296097915,
             3.797447464397581, 1.9782350687095513, 1.7967434623342367, -1.3564654322850282, 3.334905233603897,
             1.1676719455152829, -0.7625721555504019, 2.8919543063371975, -0.5471865010232002, 6.115339609518355,
             0.027926013323673837, 0.97490777126668, 4.7948932972281515, 2.7885736941423067, 3.3777378361710406,
             3.337114391216443, 0.6929483904170815, 2.1060089732814804, 1.0308186065271525, 1.6809054140962256,
             1.5418669287513662, 0.5742338852781357, 4.367893457818708, 2.6619124143135102, 2.478138049604121,
             6.0521055035132, 3.7862557745727816, 3.876628773993091, 3.3861809089574857, 3.731355160525061,
             0.04575986550281819, 2.9623000881481136, 2.2434619147795543, 0.7306218330992278, 1.9941512296677426,
             3.912642626688435, -1.390274545019869, 1.4461539822450376, 2.669015069069288, 1.0931827326124444,
             1.2065669492458138, 0.943442220373736, 5.150705820890211, 3.628942610141063, 0.7293179007350685,
             2.520122094941308, 2.2692555929679386, 2.674009198131114, 0.31875069139113843, 2.7834308381265176,
             4.45936388875691, -0.27054036255951175, 1.649986402200684, 3.047013778755632, 1.3466021818989111,
             2.134314626977769, 3.538194423402677, 0.5473542769059005, 2.3492058350691263, 0.4327289676733932,
             0.9251939337298238, 2.2273687763079173, 4.410663807963614, 1.2715075446417154, 1.2878339912708636,
             2.641657853905396, 1.9222934047727436, -0.4239951418530863, 4.76441496115528, 2.9595798275247422,
             3.239854404279516, 1.848627212953174, 6.170280491063009, 3.2101739737686072, -1.896801713479118,
             2.925190731383792, -0.44229284790483847, 4.64347073152809, -0.43954899936337055, 2.466785380188607,
             -1.4363812092927324, -1.3961700293535046, 1.8276380031292132, 0.016172007938995314, 3.6952242040072565]
        y = [0.09039897071439051, 0.03302887365483165, 3.983496477405241, 3.1552472758798373, -2.4183265810738614,
             1.3210909715468329, -4.752822107555857, 1.6579595255573956, -0.8428219965939678, 2.550871902950223,
             1.6307254121523411, 3.3521070673555555, 3.6246778362324883, 4.517037397611929, 0.9248658478105302,
             1.5857731222206115, 0.6080956143062594, 1.2376290932693546, 3.7116350552617607, 0.6467913854590213,
             -0.31743981368919005, 3.311148641172366, 5.527497884517752, -7.665806602192923, 1.1165573759884322,
             3.9242919231475093, 8.163216531998714, -1.5752558208816887, -2.3785280269888807, 4.3200903400281785,
             2.2063602656828087, 3.348984174305031, 3.0373214836411866, -2.994909287093721, -0.9624629268699261,
             -4.166394952986151, 1.0530581664475906, -1.2959924726481398, 4.2567025392256665, -2.4933024786712235,
             1.533616561564492, -1.8976397111997763, 0.2722399051148995, -2.4150709582581458, 1.1615359382789752,
             1.7346824850546443, 2.9558309251021004, -2.176579381904161, 3.8494878676154527, 8.51641037428113,
             -0.017564696711514394, -1.1161851324855094, 2.485787485124148, -0.8527530956934681, 1.9084120063031764,
             0.09452489909831052, 1.9517129545782943, 6.336312543290365, -2.2787875146351544, 1.115556728281554,
             -1.6908257939999882, 2.8339903680383496, 4.751535258444427, -0.5850570291767978, -0.025759875982462432,
             4.771429134750831, -5.440093242543384, -0.9958618178855527, -3.5149949331634556, -2.5663795630413735,
             2.337594737268901, -2.4340430818508585, 1.8942735099068633, 2.8119997837095045, 5.116842388572671,
             4.086945106714971, 7.101845480931642, 4.197638924409792, 1.3246007985169175, 3.415935083585243,
             0.6535711175467263, 1.5245327652906022, 3.3966319300523864, -5.561895673555643, 0.8543900426258983,
             -4.548997179151421, 2.7697567615809513, 4.89080917241108, 1.9903862031711856, 1.6417907682728248,
             -1.2030816107623634, 2.135793934567533, 1.45219035901196, -2.3536672656079873, 3.490698567687141,
             2.7309404572966067, 1.6395286070582191, 3.3158367781615947, 3.1628492563751163, 8.181571112218203,
             4.347408339345883, -1.7655842167159408, 2.0595814660994973, 3.5818034575966404, 0.7326808051923757,
             -1.7511248175602958, -1.7895060094133841, 1.585049476128074, 2.009184334274515, 3.985990719331277,
             1.4334827082193287, 3.508545738146937, 3.658313866391772, 0.3483554628824287, -2.6204291547168723,
             5.6226718900022945, 0.6194309110220925, 2.695196463443757, 2.673679092399982, 2.054566591005366,
             0.9323651784330254, 0.9050880254643967, 1.3332699191035728, -1.454790122466603, 0.8314711118708847,
             3.206016313776739, 3.162718176187326, -0.6959899837262897, -3.2485709492905954, 1.9112498431092033,
             -4.677466289781935, 0.004276626429895347, -0.47665907805291763, 1.8455533114616278, 0.036177905917661235,
             -1.3289449673404796, 0.2674873022138423, 4.3775002857450875, -1.9752406708494417, -0.11044683177129788,
             -1.239417679782239, 1.1549973737240367, 1.9843967960533038, 8.67050880517456, 2.7253815490477455,
             2.5612137920873606, -1.038401122717322, 2.635356911756245, 3.204029372355479, -1.1749158462876501,
             -2.848837455812197, 1.5247961844386249, -0.24932081151230134, 1.9964133259444141, -0.7412782898984842,
             6.680893282776497, 2.081747045557889, 3.2820218828320464, 1.2653220465686936, 6.673707063484677,
             8.507793717942409, -0.03777112892794787, 2.4377714756388045, 0.08311288531236516, 3.823217183903982,
             4.8850855831655915, 1.2686179153687045, 2.2500369560214684, 0.9432243389949878, -6.328354586768007,
             0.25868171729505285, 0.25677434952487443, -1.667609185940703, 0.10010712149960221, -0.3268684394995649,
             1.7318979154670444, -1.1974510965419962, 2.2545680347815713, 0.6052342142026632, 4.143895043305498,
             3.482118888699101, 0.8744072333715791, 2.8560293300304584, 1.7300951136391336, 1.814419595121692,
             6.805584369013291, -0.021271135364236304, -0.3217238525499113, -4.998125008506249, -1.8393929004640928,
             2.995001326874194, 1.960756460572417, 4.374467125315634, 0.44284923123043685, -0.4661200763847031,
             0.38143496573576585, 2.042728482503155, 0.04606767457925365, 1.8671600513597315, 1.5491577111423633,
             4.127809345571098, 1.4578624452068332, -0.20978111487226325, -1.3743121934172962, -1.4746592556384068,
             -3.248526404107981, 3.211754806055679, 3.0741120628687586, -0.009412079941175877, 1.3390800580746125,
             2.585135365053709, -0.2528206619989348, -1.5459987702813862, 1.842071034468229, -1.4982536284130168,
             3.3260086483022855, -2.103849399019029, 5.090154565926845, -2.4642990165507968, -2.1266809473402697,
             2.5634713195591456, -0.053576064340351115, -1.1031023737406853, 1.4365539747334197, -0.7983546836190007,
             0.7813964597403011, -0.959931653189968, -3.828455760071712, -1.735733923368877, 8.155702001869289,
             4.216347330800591, -4.033406461048938, 0.4906186967547449, 1.375150316998364, -1.6419155053568195,
             2.657338858599322, -0.23576724182247033, 6.814912735865007, 3.5517834226334, -0.8254352620852539,
             -1.0207619995787787, -7.349586039999551, 6.517203198198252, 0.21181840274384867, 5.640111568100917,
             2.7156674259124594, 6.042340994983624, 0.13775881140084079, -0.8305721828515775, 4.022025319924041,
             -1.6360643532976393, -1.7643425900623506, -2.767612690351441, -4.185727973734288, 0.14778942828407082,
             5.4654162158360595, 0.38585308537850227, 2.4564645696883565, 5.261576526486506, 2.6026451017033825,
             -3.6064165419389305, -1.367872567128689, 4.177064889789803, -0.31192146330936166, 0.10215383229065167,
             4.726898084871115, -2.873874070383221, 3.120001066580619, 3.780511115843137, 2.746171563888424,
             8.288849409909364, 3.1695550168398725, 2.2679979170680795, 2.4813241027138817, -0.6446063868434242,
             -0.6557400396317639, 0.9318104462557482, -5.132962877622004, 2.1188023090942787, 1.4028284039222199,
             1.408216099559656, -0.9918042557423803, -0.13213267948874585, -0.5933355813525254, 4.123787840861494,
             -5.54304075576074, -3.409669597345557, 3.7395925984006344, -0.11642792887921694, -0.549533272606662,
             4.063309262763602, -1.4882613264603406, 3.714869118788326, 3.6241896817864676, -2.234622507457103,
             0.40129224267171804, -1.7052128853133337, -1.4468346657221924, -1.8220017819363976, 1.579887968925222,
             1.4373001441471447, 5.468370749933021, 0.7092446986753356, 6.031890310138981, -1.060969028648025,
             -3.021190067351611, 4.564983906027052, -2.8722983034620757, -3.249862673379271, -5.419059602705731,
             -1.7152102520126173, -2.4523811414821335, 1.5861934960454156, 6.9567037566519625, 0.6694829026602613,
             0.08543544055598273, -3.201199139311969, 0.675071887313391, 2.150567903124399, -3.235655357437805,
             -1.749516625308308, 0.27468279912290594, 4.613871243510061, 2.1897459986698684, 2.295479013329243,
             -5.508223055503119, 3.7448669607314935, 0.16433155031422975, -3.9753098779766063, -3.6098606519598944,
             4.491360164917074, -0.8641049003514045, -1.1180969929461249, -2.5994077117352896, -0.38164101856823596,
             0.03847279233852585, -0.3513042921721725, -2.783487989633797, -0.9829494703094435, -1.823284038405398,
             -2.0291339854666304, -0.5679868985325918, 0.03971154265220411, -5.566234663814713, -0.7706450677629231,
             2.5163912159989494, -5.47654614371592, 5.1570061184675655, -0.06420662668929822, -0.8201039835816757,
             1.635796699641876, -5.100463096902395, -0.5593405466272032, 0.3715245541346113, 0.2348604557748739,
             -6.4789746692619286, 2.8930470168571167, 3.945154676942929, 1.0478819001490827, -1.8290859649517306,
             5.178178441408851, 2.811302563982717, 3.3390889741572645, 0.4736749372539699, 1.015466428455548,
             -4.346266827517361, -0.49617884082399555, -0.5342793265229382, -4.232817493445994, 5.444403028212237,
             3.248894862261857, 0.9364923031852435, 3.977503177635872, 5.771531147381793, 1.9351921241592098,
             -1.8692534177113878, -2.258502731903227, 1.720278618529047, -4.971023683773518, -0.22284322748867957,
             -3.9952081366121543, 4.138397108085677, 6.138522785170045, 2.6464565864017393, 9.243297440140493,
             -0.8291771978011635, -1.3876974120339276, 3.2436721118435847, 1.3609485491206144, 1.5988381852049165,
             -3.9261336506700992, -2.396568357455056, 1.1787939606785947, 0.08038372159872553, 4.754729408622948,
             0.9872264291869479, 1.6647270535480274, -0.29984178899458125, 2.472448208525673, -1.4975830581820366,
             1.035816558342553, -4.016149973082002, 1.8615550652350952, -5.461530435092946, -0.16918044938803045,
             1.952312306482544, 0.8664555570707725, -0.08078795877931433, -2.9212344361039966, -0.5943985911038412,
             -4.272877902932222, 0.8504557402258223, -2.7212078816277394, -1.714831596968176, -1.8279616786739994,
             -0.21564626013136556, 0.6787680119098158, -0.9305132890703667, 6.696976352900416, 2.7986807341493467,
             1.0028316191876876, -6.733016423313236, 2.1281863215784784, -3.7056561370304024, 4.314891675452351,
             1.9220872738810155, -4.699928537091246, -0.12437032807775994, 1.1712674100154337, -5.185187711576319,
             3.055667930830227, -2.6953389927415117, 6.316089263438228, 1.8123779139608018, -0.01089207929063818,
             1.722693298116126, 5.257173002129577, 0.4301487536637225, -0.3936735092696715, 4.265473545549986,
             -4.3213039867792, -2.5281145343178766, -0.8759192712540491, 2.0393692657789932, 3.157805707812971,
             -2.8123212138382905, 1.5824516840096488, 1.0839755820970138, 0.5468427080797025, -1.1076407161770288,
             0.7198249754873434, -0.7994929408806386, 3.0265370709334745, 0.23588954776966897, -0.5269974326881393,
             2.1072934545147732, 0.9085485851013179, -2.6709838207427574, 0.21316236706953184, 5.268519707190898,
             3.6651014532883703, 6.130850108909513, 3.391652952442966, 2.728445785054968, 3.4838298581459815,
             3.0342077012114737, 5.268374353005599, 0.9182180763033214, -1.8370643499046517, -0.16092288071363026,
             2.534537068455665, 4.260130250674852, -1.5793997821150234, -1.4930430769647787, -3.646476237922532,
             1.0463279892155761, 4.841752122174896, 0.3749357502037012, 3.7828396211074455, -2.6071110158006707,
             -0.4640917923741974, 2.3062636826734764, -0.08602605645523442, -4.405806192184463, -2.518369126709545,
             1.7161881641748993, 5.504555110579078, 4.530607074407019, 2.5974827291626035, -0.016520197820059312,
             0.11155045714578171, -0.277288858839726, 2.9072490441788092, 8.779195328741526, 2.0084261358948146,
             -3.6068290085023182, -0.18725572608261443, 1.7113432497831176, -1.1888544611134648, 3.1546106837248415]
        return x,y
