# realnet
## How to run on linux/windows using pip (deployed version)
The realnet-server needs to be configured and running. How to do that can be found in the readme.md for https://github.com/virtual-space/realnet-server/

- Create a folder and go to it.
```
(linux)
mkdir realnet
cd realnet
```

create a .env file with the following content
```
REALNET_TOKEN='[generated by realnet auth token]'
REALNET_CLIENT_KEY='[Retrieve from database app table]'
REALNET_CLIENT_SECRET='[Retrieve from database app table]'
REALNET_URL='[get from realnet-server serve or use 'https://api.realnet.io' for production]'
```

- run the following commands
```
(linux or Powershell)
python -m venv venv
. ./venv/bin/activate
pip install realnet

(Windows)
python -m venv venv
venv\Scripts\activate
pip install realnet
```

The realnet CLI needs a valid, unexpired token to interface with realnet-server. Run the following and paste the output token into the realnet .env. Use the username and password you defined in the realnet-server .env. Make sure to use "" around variables on Windows.
```
realnet auth token --username="[]" --password="[]"
```

- finally to start realnet and see available commands, run the following command:
```
realnet -h
```

## How to run on linux from source

The realnet server needs to be configured and running. How to do that can be found in the readme.md for https://github.com/virtual-space/realnet-server/

- Clone out the repo
```
git clone https://github.com/virtual-space/realnet/realnet.git
```

- Go to the repo root folder 
```
cd realnet
```

- In the repo root folder create an .env file with the following content:
```
REALNET_TOKEN='[generated by realnet auth token]'
REALNET_CLIENT_KEY='[Retrieve from database app table]'
REALNET_CLIENT_SECRET='[Retrieve from database app table]'
REALNET_URL='[get from realnet-server serve or use 'https://api.realnet.io' for production]'
```

- run command
```
chmod 700 .env
```

- run the following commands:
```
python -m venv venv
. ./venv/bin/activate
python setup.py install
```
The realnet CLI needs a valid, unexpired token to interface with realnet-server. Run the following and paste the output token into the realnet .env. Use the username and password you defined in the realnet-server .env.
```
realnet auth token --username='[]' --password='[]'
```

- finally to start realnet and see available commands, run the following command:
```
realnet -h
```

# installation notes (python setup.py | pip install)

You may need to manually install some dependencies. The install command should tell you what is missing.

The Cryptography module takes a long time to compile.

Below is an incomplete list of installation instructions for dependencies. If you're not doing this on a fresh installation, you should run `python setup.py install` or `pip install realnet` to see what you need first.

- Inside VENV
```
pip install --upgrade pip
pip install setuptools-rust
```
- Outside VENV
postgreSQL (pg_config is missing)
```
sudo sh -c 'echo "deb http://apt.postgresql.org/pub/repos/apt $(lsb_release -cs)-pgdg main" > /etc/apt/sources.list.d/pgdg.list'
wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | sudo apt-key add -
sudo apt-get update
sudo apt-get -y install postgresql
```
c/c++ compilers (gcc/g++ is missing)
```
sudo apt update
sudo apt install build-essential
```
Optional Man pages
```
sudo apt-get install manpages-dev
```
To test the C & C++ compiler installations run these commands:
```
gcc --version
g++ --version
```
bluetooth dev tools (bluetooth/bluetooth.h is missing)
```
sudo apt-get install libbluetooth-dev
```
