# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ExternalLink']


class ExternalLink(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_log_integration: Optional[pulumi.Input[bool]] = None,
                 metric_filter_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 point_tag_filter_regexes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_filter_regex: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Wavefront External Link Resource. This allows external links to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.ExternalLink("basic",
            description="An external link description",
            template="https://example.com/source={{{source}}}&startTime={{startEpochMillis}}")
        ```

        ## Import

        Maintenance windows can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/externalLink:ExternalLink basic fVj6fz6zYC4aBkID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human-readable description for this link
        :param pulumi.Input[bool] is_log_integration: Whether this is a "Log Integration" subType of external link
        :param pulumi.Input[str] metric_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param pulumi.Input[str] name: The name of the external link
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] point_tag_filter_regexes: Controls whether a link is displayed in the context menu of a highlighted series. This is a map from string to regular expression. The highlighted series must contain point tags whose keys are present in the keys of this map and whose values match the regular expressions associated with those keys in order for the link to be displayed
        :param pulumi.Input[str] source_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param pulumi.Input[str] template: The mustache template for this link. The template must expand to a full URL, including scheme, origin, etc.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__['description'] = description
            __props__['is_log_integration'] = is_log_integration
            __props__['metric_filter_regex'] = metric_filter_regex
            __props__['name'] = name
            __props__['point_tag_filter_regexes'] = point_tag_filter_regexes
            __props__['source_filter_regex'] = source_filter_regex
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__['template'] = template
        super(ExternalLink, __self__).__init__(
            'wavefront:index/externalLink:ExternalLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            is_log_integration: Optional[pulumi.Input[bool]] = None,
            metric_filter_regex: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            point_tag_filter_regexes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            source_filter_regex: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[str]] = None) -> 'ExternalLink':
        """
        Get an existing ExternalLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human-readable description for this link
        :param pulumi.Input[bool] is_log_integration: Whether this is a "Log Integration" subType of external link
        :param pulumi.Input[str] metric_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param pulumi.Input[str] name: The name of the external link
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] point_tag_filter_regexes: Controls whether a link is displayed in the context menu of a highlighted series. This is a map from string to regular expression. The highlighted series must contain point tags whose keys are present in the keys of this map and whose values match the regular expressions associated with those keys in order for the link to be displayed
        :param pulumi.Input[str] source_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param pulumi.Input[str] template: The mustache template for this link. The template must expand to a full URL, including scheme, origin, etc.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["is_log_integration"] = is_log_integration
        __props__["metric_filter_regex"] = metric_filter_regex
        __props__["name"] = name
        __props__["point_tag_filter_regexes"] = point_tag_filter_regexes
        __props__["source_filter_regex"] = source_filter_regex
        __props__["template"] = template
        return ExternalLink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Human-readable description for this link
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isLogIntegration")
    def is_log_integration(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this is a "Log Integration" subType of external link
        """
        return pulumi.get(self, "is_log_integration")

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> pulumi.Output[Optional[str]]:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        """
        return pulumi.get(self, "metric_filter_regex")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the external link
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pointTagFilterRegexes")
    def point_tag_filter_regexes(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. This is a map from string to regular expression. The highlighted series must contain point tags whose keys are present in the keys of this map and whose values match the regular expressions associated with those keys in order for the link to be displayed
        """
        return pulumi.get(self, "point_tag_filter_regexes")

    @property
    @pulumi.getter(name="sourceFilterRegex")
    def source_filter_regex(self) -> pulumi.Output[Optional[str]]:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        """
        return pulumi.get(self, "source_filter_regex")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[str]:
        """
        The mustache template for this link. The template must expand to a full URL, including scheme, origin, etc.
        """
        return pulumi.get(self, "template")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

