"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Evidently = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Evidently extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'evidently';
        this.accessLevelList = {
            Write: [
                'BatchEvaluateFeature',
                'CreateExperiment',
                'CreateFeature',
                'CreateLaunch',
                'CreateProject',
                'DeleteExperiment',
                'DeleteFeature',
                'DeleteLaunch',
                'DeleteProject',
                'EvaluateFeature',
                'PutProjectEvents',
                'StartExperiment',
                'StartLaunch',
                'StopExperiment',
                'StopLaunch',
                'UpdateExperiment',
                'UpdateFeature',
                'UpdateLaunch',
                'UpdateProject',
                'UpdateProjectDataDelivery'
            ],
            Read: [
                'GetExperiment',
                'GetExperimentResults',
                'GetFeature',
                'GetLaunch',
                'GetProject',
                'ListExperiments',
                'ListFeatures',
                'ListLaunches',
                'ListProjects',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to send a batched evaluate feature request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_BatchEvaluateFeature.html
     */
    toBatchEvaluateFeature() {
        return this.to('BatchEvaluateFeature');
    }
    /**
     * Grants permission to create an experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html
     */
    toCreateExperiment() {
        return this.to('CreateExperiment');
    }
    /**
     * Grants permission to create a feature
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateFeature.html
     */
    toCreateFeature() {
        return this.to('CreateFeature');
    }
    /**
     * Grants permission to create a launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html
     */
    toCreateLaunch() {
        return this.to('CreateLaunch');
    }
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to delete an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteExperiment.html
     */
    toDeleteExperiment() {
        return this.to('DeleteExperiment');
    }
    /**
     * Grants permission to delete a feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html
     */
    toDeleteFeature() {
        return this.to('DeleteFeature');
    }
    /**
     * Grants permission to delete a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteLaunch.html
     */
    toDeleteLaunch() {
        return this.to('DeleteLaunch');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteProject.html
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to send an evaluate feature request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html
     */
    toEvaluateFeature() {
        return this.to('EvaluateFeature');
    }
    /**
     * Grants permission to get experiment details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetExperiment.html
     */
    toGetExperiment() {
        return this.to('GetExperiment');
    }
    /**
     * Grants permission to get experiment result
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetExperimentResults.html
     */
    toGetExperimentResults() {
        return this.to('GetExperimentResults');
    }
    /**
     * Grants permission to get feature details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetFeature.html
     */
    toGetFeature() {
        return this.to('GetFeature');
    }
    /**
     * Grants permission to get launch details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetLaunch.html
     */
    toGetLaunch() {
        return this.to('GetLaunch');
    }
    /**
     * Grants permission to get project details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetProject.html
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to list experiments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html
     */
    toListExperiments() {
        return this.to('ListExperiments');
    }
    /**
     * Grants permission to list features
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html
     */
    toListFeatures() {
        return this.to('ListFeatures');
    }
    /**
     * Grants permission to list launches
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html
     */
    toListLaunches() {
        return this.to('ListLaunches');
    }
    /**
     * Grants permission to list projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to list tags for resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to send performance events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_PutProjectEvents.html
     */
    toPutProjectEvents() {
        return this.to('PutProjectEvents');
    }
    /**
     * Grants permission to start an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StartExperiment.html
     */
    toStartExperiment() {
        return this.to('StartExperiment');
    }
    /**
     * Grants permission to start a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StartLaunch.html
     */
    toStartLaunch() {
        return this.to('StartLaunch');
    }
    /**
     * Grants permission to stop an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html
     */
    toStopExperiment() {
        return this.to('StopExperiment');
    }
    /**
     * Grants permission to stop a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html
     */
    toStopLaunch() {
        return this.to('StopLaunch');
    }
    /**
     * Grants permission to tag resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html
     */
    toUpdateExperiment() {
        return this.to('UpdateExperiment');
    }
    /**
     * Grants permission to update feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html
     */
    toUpdateFeature() {
        return this.to('UpdateFeature');
    }
    /**
     * Grants permission to update a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html
     */
    toUpdateLaunch() {
        return this.to('UpdateLaunch');
    }
    /**
     * Grants permission to update project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html
     */
    toUpdateProject() {
        return this.to('UpdateProject');
    }
    /**
     * Grants permission to update project data delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html
     */
    toUpdateProjectDataDelivery() {
        return this.to('UpdateProjectDataDelivery');
    }
    /**
     * Adds a resource of type Project to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/projects.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProject(ownerAccountId, projectName, region, partition) {
        return this.on(`arn:${partition || Evidently.defaultPartition}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}`);
    }
    /**
     * Adds a resource of type Feature to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/features.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param featureName - Identifier for the featureName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFeature(ownerAccountId, projectName, featureName, region, partition) {
        return this.on(`arn:${partition || Evidently.defaultPartition}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/feature/${featureName}`);
    }
    /**
     * Adds a resource of type Experiment to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/experiments.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param experimentName - Identifier for the experimentName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExperiment(ownerAccountId, projectName, experimentName, region, partition) {
        return this.on(`arn:${partition || Evidently.defaultPartition}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/experiment/${experimentName}`);
    }
    /**
     * Adds a resource of type Launch to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/launches.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param launchName - Identifier for the launchName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunch(ownerAccountId, projectName, launchName, region, partition) {
        return this.on(`arn:${partition || Evidently.defaultPartition}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/launch/${launchName}`);
    }
}
exports.Evidently = Evidently;
_a = JSII_RTTI_SYMBOL_1;
Evidently[_a] = { fqn: "iam-floyd.Evidently", version: "0.389.0" };
//# sourceMappingURL=data:application/json;base64,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