# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### <!-- 5 --> 🌀 Miscellaneous
- 💚 Fix biome.jsonc for 2.0.0-beta.1
- 🎨 Ruff NP rules for tests
- 👷 Update CI
- [pre-commit.ci] auto fixes from pre-commit.com hooks
- 👽️ Nonlocals of a nonlocal??? sure why not

## [0.1.0] - 2025-03-11

### <!-- 1 --> 🚀 Features
- Look at names in closure for nw.Expr instead of subclassing it. by [@srivarra](https://github.com/srivarra) in [#50](https://github.com/srivarra/annsel/pull/50)

### <!-- 5 --> 🌀 Miscellaneous
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot]) in [#48](https://github.com/srivarra/annsel/pull/48)

## [0.0.10] - 2025-03-03

### <!-- 4 --> 🧪 Dependencies
- ⬆️ Upgrade Narwhals by [@srivarra](https://github.com/srivarra) in [#47](https://github.com/srivarra/annsel/pull/47)

### <!-- 5 --> 🌀 Miscellaneous
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot]) in [#45](https://github.com/srivarra/annsel/pull/45)

## [0.0.9] - 2025-02-18

### <!-- 5 --> 🌀 Miscellaneous
- ExprMetadata and Badge by [@srivarra](https://github.com/srivarra) in [#44](https://github.com/srivarra/annsel/pull/44)

## [0.0.8] - 2025-02-13

### <!-- 3 --> 📝 Documentation
- Removing explicit sparse argument by [@srivarra](https://github.com/srivarra) in [#42](https://github.com/srivarra/annsel/pull/42)

### <!-- 4 --> 🧪 Dependencies
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot]) in [#37](https://github.com/srivarra/annsel/pull/37)

### <!-- 5 --> 🌀 Miscellaneous
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot]) in [#40](https://github.com/srivarra/annsel/pull/40)

## [0.0.7] - 2025-01-28

### <!-- 2 --> 🐛 Fixes
- Concurrency Groups Fix by [@srivarra](https://github.com/srivarra) in [#34](https://github.com/srivarra/annsel/pull/34)
- Expr Fixes by [@srivarra](https://github.com/srivarra) in [#32](https://github.com/srivarra/annsel/pull/32)

### <!-- 3 --> 📝 Documentation
- Flush out README with examples by [@srivarra](https://github.com/srivarra) in [#36](https://github.com/srivarra/annsel/pull/36)

### <!-- 4 --> 🧪 Dependencies
- Merge pull request #29 from srivarra/feature/remove-marimo by [@srivarra](https://github.com/srivarra) in [#29](https://github.com/srivarra/annsel/pull/29)

### <!-- 5 --> 🌀 Miscellaneous
- 👽️ Add Expr changes to AnnselExpr by [@srivarra](https://github.com/srivarra)
- Merge pull request #30 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#30](https://github.com/srivarra/annsel/pull/30)
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- 🧑‍💻 Removed marimo by [@srivarra](https://github.com/srivarra)
- ➖ Removed Marimo by [@srivarra](https://github.com/srivarra)

## [0.0.6] - 2025-01-21

### <!-- 1 --> 🚀 Features
- Merge pull request #28 from srivarra/feature/marimo-dataset by [@srivarra](https://github.com/srivarra) in [#28](https://github.com/srivarra/annsel/pull/28)

### <!-- 5 --> 🌀 Miscellaneous
- ✅ Add test for marimo dataset by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] auto fixes from pre-commit.com hooks by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- 🧐 Remove large dataset from previous commit by [@srivarra](https://github.com/srivarra)
- 🧐 Generate toy dataset for marimo by [@srivarra](https://github.com/srivarra)

## [0.0.5] - 2025-01-21

### <!-- 0 --> 🏗️ Github Actions
- Merge pull request #25 from srivarra/feature/type_fixes by [@srivarra](https://github.com/srivarra) in [#25](https://github.com/srivarra/annsel/pull/25)

### <!-- 3 --> 📝 Documentation
- Merge pull request #24 from srivarra/docs/changelog-template-add-gh-account by [@srivarra](https://github.com/srivarra) in [#24](https://github.com/srivarra/annsel/pull/24)

### <!-- 4 --> 🧪 Dependencies
- Merge pull request #23 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#23](https://github.com/srivarra/annsel/pull/23)
- Merge pull request #22 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#22](https://github.com/srivarra/annsel/pull/22)
- Merge pull request #21 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#21](https://github.com/srivarra/annsel/pull/21)

### <!-- 5 --> 🌀 Miscellaneous
- Merge pull request #27 from srivarra/ci/revert-arm-runner by [@srivarra](https://github.com/srivarra) in [#27](https://github.com/srivarra/annsel/pull/27)
- 💚 One day I'll get CI right by [@srivarra](https://github.com/srivarra)
- Merge pull request #26 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#26](https://github.com/srivarra/annsel/pull/26)
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- 💚 Testing arm based ubuntu ci by [@srivarra](https://github.com/srivarra)
- 🏷️ Update IntoExpr by [@srivarra](https://github.com/srivarra)
- ⚗️ Marimo testing by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] auto fixes from pre-commit.com hooks by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- Added github label commit parser by [@srivarra](https://github.com/srivarra)
- 📝 Added github pr label commit parser by [@srivarra](https://github.com/srivarra)
- 📝 Updated changelog template by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] auto fixes from pre-commit.com hooks by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] auto fixes from pre-commit.com hooks by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- 📝 Changelog updates by [@srivarra](https://github.com/srivarra)
- 📝 Update readme by [@srivarra](https://github.com/srivarra)
- 📝 Adjusted theme by [@srivarra](https://github.com/srivarra)
- Update README.md by [@srivarra](https://github.com/srivarra)

## [0.0.4] - 2024-12-21

### <!-- 5 --> 🌀 Miscellaneous
- 💚 Missed one pypi-publish by [@srivarra](https://github.com/srivarra)

## [0.0.3] - 2024-12-21

### <!-- 1 --> 🚀 Features
- Merge pull request #16 from srivarra/ops/groupby by [@srivarra](https://github.com/srivarra) in [#16](https://github.com/srivarra/annsel/pull/16)
- Merge pull request #15 from srivarra/ops/select by [@srivarra](https://github.com/srivarra) in [#15](https://github.com/srivarra/annsel/pull/15)

### <!-- 4 --> 🧪 Dependencies
- Merge pull request #20 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#20](https://github.com/srivarra/annsel/pull/20)
- Merge pull request #19 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#19](https://github.com/srivarra/annsel/pull/19)
- Merge pull request #18 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#18](https://github.com/srivarra/annsel/pull/18)
- Merge pull request #17 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#17](https://github.com/srivarra/annsel/pull/17)

### <!-- 5 --> 🌀 Miscellaneous
- 💚 Bump gh-action-pypi-publish to 1.12.3 by [@srivarra](https://github.com/srivarra)
- Api documentation fix by [@srivarra](https://github.com/srivarra)
- Update README.md example by [@srivarra](https://github.com/srivarra)
- 📌 Pin doc deps: scanpy, numba, llvmlite to release canidates by [@srivarra](https://github.com/srivarra)
- 💚 Update CI actions by [@srivarra](https://github.com/srivarra)
- ⬆️ Some random numpy 2 with python 3.13 issues by [@srivarra](https://github.com/srivarra)
- Merge branch 'main' into ops/groupby by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] auto fixes from pre-commit.com hooks by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- Update README.md by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] auto fixes from pre-commit.com hooks by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- ♻️ Refactor col expressions by [@srivarra](https://github.com/srivarra)
- 🚸 Updating api by [@srivarra](https://github.com/srivarra)
- ⬆️ Update tqdm by [@srivarra](https://github.com/srivarra)
- Merge branch 'main' into ops/groupby by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- ✨ Added Groupby by [@srivarra](https://github.com/srivarra)
- ✨ Add select by [@srivarra](https://github.com/srivarra)
- Update README.md by [@srivarra](https://github.com/srivarra)

## [0.0.2] - 2024-11-12

### <!-- 0 --> 🏗️ Github Actions
- Merge pull request #14 from srivarra/ci/release_workflow by [@srivarra](https://github.com/srivarra) in [#14](https://github.com/srivarra/annsel/pull/14)

### <!-- 3 --> 📝 Documentation
- Merge pull request #12 from srivarra/docs/changelog-release-drafter by [@srivarra](https://github.com/srivarra) in [#12](https://github.com/srivarra/annsel/pull/12)
- Merge pull request #7 from srivarra/docs/restructure by [@srivarra](https://github.com/srivarra) in [#7](https://github.com/srivarra/annsel/pull/7)

### <!-- 4 --> 🧪 Dependencies
- Merge pull request #8 from srivarra/pre-commit-ci-update-config by [@srivarra](https://github.com/srivarra) in [#8](https://github.com/srivarra/annsel/pull/8)

### <!-- 5 --> 🌀 Miscellaneous
- 💚 Set uv sync --frozen by [@srivarra](https://github.com/srivarra)
- 📝 Added pre-commit readme badge by [@srivarra](https://github.com/srivarra)
- 🔧 Add __version__ to __init__ by [@srivarra](https://github.com/srivarra)
- ➕ Add typing-extensions by [@srivarra](https://github.com/srivarra)
- 📝 Added citation.cff by [@srivarra](https://github.com/srivarra)
- 🙈 .python-version by [@srivarra](https://github.com/srivarra)
- 🔧 Remove .python-version by [@srivarra](https://github.com/srivarra)
- 💚 Ciremove version in __init__.py by [@srivarra](https://github.com/srivarra)
- 💚 Fetch-depth: 0 by [@srivarra](https://github.com/srivarra)
- 🔧 Update pyproject, add hatch-vcs dynamic version by [@srivarra](https://github.com/srivarra)
- 💚 What's going on with ci by [@srivarra](https://github.com/srivarra)
- 💚 Fix incorrect name for ci by [@srivarra](https://github.com/srivarra)
- 👷 Remove font by [@srivarra](https://github.com/srivarra)
- 👷 Use uv, remove pip by [@srivarra](https://github.com/srivarra)
- 👷 Uv for rtd by [@srivarra](https://github.com/srivarra)
- ⏪️ Remove changelog ci update by [@srivarra](https://github.com/srivarra)
- 💚 Changelog 3 by [@srivarra](https://github.com/srivarra)
- 💚 Changelog testing 2 by [@srivarra](https://github.com/srivarra)
- 💚 Changelog testing by [@srivarra](https://github.com/srivarra)
- 💚 Change commit changelog author to github_actions by [@srivarra](https://github.com/srivarra)
- 💚 Yaml or yml by [@srivarra](https://github.com/srivarra)
- 👷 Add release drafter by [@srivarra](https://github.com/srivarra)
- ✅ Added sparsity X tests by [@srivarra](https://github.com/srivarra)
- ♻️ Refactor _extract_X by [@srivarra](https://github.com/srivarra)
- 📝 Clean notebook by [@srivarra](https://github.com/srivarra)
- ✅ Updated x tests by [@srivarra](https://github.com/srivarra)
- Merge branch 'main' into docs/restructure by [@srivarra](https://github.com/srivarra)
- [pre-commit.ci] pre-commit autoupdate by [@pre-commit-ci[bot]](https://github.com/pre-commit-ci[bot])
- ✅ Add pipe tests by [@srivarra](https://github.com/srivarra)
- 📝 Added scanpy plot with pipe by [@srivarra](https://github.com/srivarra)
- 🎨 Format pyproject.toml by [@srivarra](https://github.com/srivarra)
- 📝 Updated landing page by [@srivarra](https://github.com/srivarra)
- 📝 Updated documentation structure by [@srivarra](https://github.com/srivarra)

## New Contributors
* @pre-commit-ci[bot] made their first contribution
## [0.0.1] - 2024-11-10

### <!-- 0 --> 🏗️ Github Actions
- Merge pull request #5 from srivarra/ci_release_fix by [@srivarra](https://github.com/srivarra) in [#5](https://github.com/srivarra/annsel/pull/5)

### <!-- 1 --> 🚀 Features
- Merge pull request #4 from srivarra/filter by [@srivarra](https://github.com/srivarra) in [#4](https://github.com/srivarra/annsel/pull/4)

### <!-- 4 --> 🧪 Dependencies
- Merge pull request #1 from srivarra/configuration by [@srivarra](https://github.com/srivarra) in [#1](https://github.com/srivarra/annsel/pull/1)

### <!-- 5 --> 🌀 Miscellaneous
- 💚 Release fixes by [@srivarra](https://github.com/srivarra)
- 📝 Remove nbsphinx by [@srivarra](https://github.com/srivarra)
- ➖ Remove pytest rich by [@srivarra](https://github.com/srivarra)
- ✨ Filter mostly fixed by [@srivarra](https://github.com/srivarra)
- 📝 Add a link to the discussions. by [@srivarra](https://github.com/srivarra)
- ✅ Dataclasses from attrs again by [@srivarra](https://github.com/srivarra)
- 🏷️ Fixed dataclasses by [@srivarra](https://github.com/srivarra)
- ✨ Fixed up filtering by [@srivarra](https://github.com/srivarra)
- 📝 Do not fail on warning by [@srivarra](https://github.com/srivarra)
- 💚 Removed upload test results to codecov by [@srivarra](https://github.com/srivarra)
- 📝 Added matplotlib to docs by [@srivarra](https://github.com/srivarra)
- 📝 Update rtd by [@srivarra](https://github.com/srivarra)
- 📝 Fix rtd by [@srivarra](https://github.com/srivarra)
- 🧑‍💻 Added gitcliff changelog by [@srivarra](https://github.com/srivarra)
- 💚 Added python 3.12 to test suite by [@srivarra](https://github.com/srivarra)
- ♻️ Renamed accessor by [@srivarra](https://github.com/srivarra)
- ➖ Removed twine by [@srivarra](https://github.com/srivarra)
- ➕ Added twine by [@srivarra](https://github.com/srivarra)
- ➕ Added pytest extra deps by [@srivarra](https://github.com/srivarra)
- 🎉 Begin by [@srivarra](https://github.com/srivarra)

## New Contributors
* @srivarra made their first contribution in [#5](https://github.com/srivarra/annsel/pull/5)
[unreleased]: https://github.com/srivarra/annsel/compare/v0.1.0..HEAD
[0.1.0]: https://github.com/srivarra/annsel/compare/v0.0.10..v0.1.0
[0.0.10]: https://github.com/srivarra/annsel/compare/v0.0.9..v0.0.10
[0.0.9]: https://github.com/srivarra/annsel/compare/v0.0.8..v0.0.9
[0.0.8]: https://github.com/srivarra/annsel/compare/v0.0.7..v0.0.8
[0.0.7]: https://github.com/srivarra/annsel/compare/v0.0.6..v0.0.7
[0.0.6]: https://github.com/srivarra/annsel/compare/v0.0.5..v0.0.6
[0.0.5]: https://github.com/srivarra/annsel/compare/v0.0.4..v0.0.5
[0.0.4]: https://github.com/srivarra/annsel/compare/v0.0.3..v0.0.4
[0.0.3]: https://github.com/srivarra/annsel/compare/v0.0.2..v0.0.3
[0.0.2]: https://github.com/srivarra/annsel/compare/0.0.1..v0.0.2

<!-- generated by git-cliff -->
