#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['tankobon', 'tankobon.gui', 'tankobon.parsers']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.9.1',
 'click>=7.1.2',
 'coloredlogs>=14.0',
 'fake-useragent>=0.1.11',
 'filetype>=1.0.7',
 'fpdf>=1.7.2',
 'html5lib>=1.1',
 'imagesize>=1.2.0',
 'natsort>=7.1.0',
 'requests>=2.24.0']

extras_require = \
{'docs': ['pydoc-markdown>=3.10.1'], 'gui': ['PySide6>=6.0.3']}

entry_points = \
{'console_scripts': ['tankobon = tankobon.cli:cli']}

setup(name='tankobon',
      version='6.2.0',
      description='Yet another manga scraper and downloader',
      author='Ong Yong Xin',
      author_email='ongyongxin2020+github@gmail.com',
      url='https://github.com/ongyx/tankobon',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
