# rightfoot
Rightfoot's API generates student debt beneficiary accounts and transfers funds
to their loans.

[API Documentation](https://docs.rightfoot.com)

This repository provides Python bindings for Rightfoot's API.

## Installation
Install Rightfoot from PyPi with pip:
```
pip install rightfoot
```

## Getting Started
First create a client at the desired endpoint along with your credentials.
```python
import rightfoot

configuration = rightfoot.Configuration()
# Defaults to sandbox, but can be explicitly set to sandbox/production. 
configuration.host="https://sandbox.api.rightfoot.com/v1"
configuration.api_key['Authorization'] = os.env['RIGHTFOOT_API_KEY']
configuration.api_key_prefix['Authorization'] = 'Bearer'
rightfoot_client = rightfoot.RightfootApi(rightfoot.ApiClient(configuration))
```


Then a request to create a beneficiary can be made.
```python
import rightfoot
from rightfoot.rest import ApiException

mailing_address = rightfoot.models.MailingAddress(
    line1="123 Easy Street", city="Palo Alto", state="CA", zip_code="12345-0123")
request = rightfoot.CreateBeneficiaryRequest(
    first_name="John", last_name="Doe", date_of_birth="1970-01-01",
    phone_number="+1 650 555 5555", mailing_address=mailing_address)

try:
    response = rightfoot_client.create_beneficiary(request)
    print(response)
except ApiException as e:
    print("Exception when calling RightfootApi->create_beneficiary: %s\n" % e)
```

## Notes on API Client Source
Rightfoot uses [swagger-codegen](https://github.com/swagger-api/swagger-codegen)
to create and maintain its SDKs whenever possible. Requests for modifications
are accepted but required departing from the Swagger/OpenAPI templates for SDKs,
which we try to avoid as much as possible in the interest of stability and
ability to leverage improvements and security patches from those base templates
as much as possible.

# License
The MIT License (MIT)

Copyright (c) 2020 Charitize, Inc ("Rightfoot")

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
