"""Added responsetime table

Revision ID: 689f13ef5c86
Revises: 023aa9f36740
Create Date: 2021-10-11 21:09:14.774041

"""
from alembic import op
import sqlalchemy as sa

from vwsfriend.model.datetime_decorator import DatetimeDecorator


# revision identifiers, used by Alembic.
revision = '689f13ef5c86'
down_revision = '023aa9f36740'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('weconnect_responsetime',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('datetime', DatetimeDecorator(timezone=True), nullable=False),
                    sa.Column('min', sa.Float(), nullable=True),
                    sa.Column('avg', sa.Float(), nullable=True),
                    sa.Column('max', sa.Float(), nullable=True),
                    sa.Column('total', sa.Float(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('weconnect_responsetime')
    # ### end Alembic commands ###
