from __future__ import annotations

import colour


class ColorProxy:
    def __init__(self, name: str) -> None:
        self.name = name

    def __repr__(self) -> str:
        return f"{type(self).__name__}(name={self.name})"

    def __call__(self) -> Color:
        return Color(self.name)


class ColorName:
    ALICE_BLUE = ColorProxy("aliceblue")
    ANTIQUE_WHITE = ColorProxy("antiquewhite")
    AQUA = ColorProxy("aqua")
    AQUAMARINE = ColorProxy("aquamarine")
    AZURE = ColorProxy("azure")
    BEIGE = ColorProxy("beige")
    BISQUE = ColorProxy("bisque")
    BLACK = ColorProxy("black")
    BLANCHED_ALMOND = ColorProxy("blanchedalmond")
    BLUE = ColorProxy("blue")
    BLUE_VIOLET = ColorProxy("blueviolet")
    BROWN = ColorProxy("brown")
    BURLYWOOD = ColorProxy("burlywood")
    CADET_BLUE = ColorProxy("cadetblue")
    CHARTREUSE = ColorProxy("chartreuse")
    CHOCOLATE = ColorProxy("chocolate")
    CORAL = ColorProxy("coral")
    CORNFLOWER_BLUE = ColorProxy("cornflowerblue")
    CORNSILK = ColorProxy("cornsilk")
    CRIMSON = ColorProxy("crimson")
    CYAN = ColorProxy("cyan")
    DARK_BLUE = ColorProxy("darkblue")
    DARK_CYAN = ColorProxy("darkcyan")
    DARK_GOLDENROD = ColorProxy("darkgoldenrod")
    DARK_GRAY = ColorProxy("darkgray")
    DARK_GREEN = ColorProxy("darkgreen")
    DARK_GREY = ColorProxy("darkgrey")
    DARK_KHAKI = ColorProxy("darkkhaki")
    DARK_MAGENTA = ColorProxy("darkmagenta")
    DARK_OLIVE_GREEN = ColorProxy("darkolivegreen")
    DARK_ORANGE = ColorProxy("darkorange")
    DARK_ORCHID = ColorProxy("darkorchid")
    DARK_RED = ColorProxy("darkred")
    DARK_SALMON = ColorProxy("darksalmon")
    DARK_SEA_GREEN = ColorProxy("darkseagreen")
    DARK_SLATE_BLUE = ColorProxy("darkslateblue")
    DARK_SLATE_GRAY = ColorProxy("darkslategray")
    DARK_SLATE_GREY = ColorProxy("darkslategrey")
    DARK_TURQUOISE = ColorProxy("darkturquoise")
    DARK_VIOLET = ColorProxy("darkviolet")
    DEEP_PINK = ColorProxy("deeppink")
    DEEP_SKY_BLUE = ColorProxy("deepskyblue")
    DIM_GRAY = ColorProxy("dimgray")
    DIM_GREY = ColorProxy("dimgrey")
    DODGER_BLUE = ColorProxy("dodgerblue")
    FIREBRICK = ColorProxy("firebrick")
    FLORAL_WHITE = ColorProxy("floralwhite")
    FOREST_GREEN = ColorProxy("forestgreen")
    FUCHSIA = ColorProxy("fuchsia")
    GAINSBORO = ColorProxy("gainsboro")
    GHOST_WHITE = ColorProxy("ghostwhite")
    GOLD = ColorProxy("gold")
    GOLDENROD = ColorProxy("goldenrod")
    GRAY = ColorProxy("gray")
    GREEN = ColorProxy("green")
    GREEN_YELLOW = ColorProxy("greenyellow")
    GREY = ColorProxy("grey")
    HONEYDEW = ColorProxy("honeydew")
    HOT_PINK = ColorProxy("hotpink")
    INDIAN_RED = ColorProxy("indianred")
    INDIGO = ColorProxy("indigo")
    IVORY = ColorProxy("ivory")
    KHAKI = ColorProxy("khaki")
    LAVENDER = ColorProxy("lavender")
    LAVENDER_BLUSH = ColorProxy("lavenderblush")
    LAWN_GREEN = ColorProxy("lawngreen")
    LEMON_CHIFFON = ColorProxy("lemonchiffon")
    LIGHT_BLUE = ColorProxy("lightblue")
    LIGHT_CORAL = ColorProxy("lightcoral")
    LIGHT_CYAN = ColorProxy("lightcyan")
    LIGHT_GOLDENROD = ColorProxy("lightgoldenrod")
    LIGHT_GOLDENROD_YELLOW = ColorProxy("lightgoldenrodyellow")
    LIGHT_GRAY = ColorProxy("lightgray")
    LIGHT_GREEN = ColorProxy("lightgreen")
    LIGHT_GREY = ColorProxy("lightgrey")
    LIGHT_PINK = ColorProxy("lightpink")
    LIGHT_SALMON = ColorProxy("lightsalmon")
    LIGHT_SEA_GREEN = ColorProxy("lightseagreen")
    LIGHT_SKY_BLUE = ColorProxy("lightskyblue")
    LIGHT_SLATE_BLUE = ColorProxy("lightslateblue")
    LIGHT_SLATE_GRAY = ColorProxy("lightslategray")
    LIGHT_SLATE_GREY = ColorProxy("lightslategrey")
    LIGHT_STEEL_BLUE = ColorProxy("lightsteelblue")
    LIGHT_YELLOW = ColorProxy("lightyellow")
    LIME = ColorProxy("lime")
    LIME_GREEN = ColorProxy("limegreen")
    LINEN = ColorProxy("linen")
    MAGENTA = ColorProxy("magenta")
    MAROON = ColorProxy("maroon")
    MEDIUM_AQUAMARINE = ColorProxy("mediumaquamarine")
    MEDIUM_BLUE = ColorProxy("mediumblue")
    MEDIUM_ORCHID = ColorProxy("mediumorchid")
    MEDIUM_PURPLE = ColorProxy("mediumpurple")
    MEDIUM_SEA_GREEN = ColorProxy("mediumseagreen")
    MEDIUM_SLATE_BLUE = ColorProxy("mediumslateblue")
    MEDIUM_SPRING_GREEN = ColorProxy("mediumspringgreen")
    MEDIUM_TURQUOISE = ColorProxy("mediumturquoise")
    MEDIUM_VIOLET_RED = ColorProxy("mediumvioletred")
    MIDNIGHT_BLUE = ColorProxy("midnightblue")
    MINT_CREAM = ColorProxy("mintcream")
    MISTY_ROSE = ColorProxy("mistyrose")
    MOCCASIN = ColorProxy("moccasin")
    NAVAJO_WHITE = ColorProxy("navajowhite")
    NAVY = ColorProxy("navy")
    NAVY_BLUE = ColorProxy("navyblue")
    OLD_LACE = ColorProxy("oldlace")
    OLIVE = ColorProxy("olive")
    OLIVE_DRAB = ColorProxy("olivedrab")
    ORANGE = ColorProxy("orange")
    ORANGE_RED = ColorProxy("orangered")
    ORCHID = ColorProxy("orchid")
    PALE_GOLDENROD = ColorProxy("palegoldenrod")
    PALE_GREEN = ColorProxy("palegreen")
    PALE_TURQUOISE = ColorProxy("paleturquoise")
    PALE_VIOLET_RED = ColorProxy("palevioletred")
    PAPAYA_WHIP = ColorProxy("papayawhip")
    PEACH_PUFF = ColorProxy("peachpuff")
    PERU = ColorProxy("peru")
    PINK = ColorProxy("pink")
    PLUM = ColorProxy("plum")
    POWDER_BLUE = ColorProxy("powderblue")
    PURPLE = ColorProxy("purple")
    RED = ColorProxy("red")
    ROSY_BROWN = ColorProxy("rosybrown")
    ROYAL_BLUE = ColorProxy("royalblue")
    SADDLE_BROWN = ColorProxy("saddlebrown")
    SALMON = ColorProxy("salmon")
    SANDY_BROWN = ColorProxy("sandybrown")
    SEASHELL = ColorProxy("seashell")
    SEA_GREEN = ColorProxy("seagreen")
    SIENNA = ColorProxy("sienna")
    SILVER = ColorProxy("silver")
    SKY_BLUE = ColorProxy("skyblue")
    SLATE_BLUE = ColorProxy("slateblue")
    SLATE_GRAY = ColorProxy("slategray")
    SLATE_GREY = ColorProxy("slategrey")
    SNOW = ColorProxy("snow")
    SPRING_GREEN = ColorProxy("springgreen")
    STEEL_BLUE = ColorProxy("steelblue")
    TAN = ColorProxy("tan")
    THISTLE = ColorProxy("thistle")
    TOMATO = ColorProxy("tomato")
    TURQUOISE = ColorProxy("turquoise")
    VIOLET = ColorProxy("violet")
    VIOLET_RED = ColorProxy("violetred")
    WHEAT = ColorProxy("wheat")
    WHITE = ColorProxy("white")
    WHITE_SMOKE = ColorProxy("whitesmoke")
    YELLOW = ColorProxy("yellow")
    YELLOW_GREEN = ColorProxy("yellowgreen")


class Color(colour.Color):
    """Subclass of colour.Color with access to a Color.Name emum of color names that are valid to be passed into the Color constructor."""
    Name = ColorName

    def get_rgb(self, max=255) -> tuple:
        return tuple(val*max for val in super().get_rgb())
