import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipeGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the database containing the current or future pipes on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#database_name PipeGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#enable_multiple_grants PipeGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * When this is set to true and a schema_name is provided, apply this grant on all future pipes in the given schema. When this is true and no schema_name is provided apply this grant on all future pipes in the given database. The pipe_name field must be unset in order to use on_future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#on_future PipeGrant#on_future}
    */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
    * The name of the pipe on which to grant privileges immediately (only valid if on_future is false).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#pipe_name PipeGrant#pipe_name}
    */
    readonly pipeName?: string;
    /**
    * The privilege to grant on the current or future pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#privilege PipeGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#roles PipeGrant#roles}
    */
    readonly roles?: string[];
    /**
    * The name of the schema containing the current or future pipes on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#schema_name PipeGrant#schema_name}
    */
    readonly schemaName: string;
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant#with_grant_option PipeGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant snowflake_pipe_grant}
*/
export declare class PipeGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_pipe_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/pipe_grant snowflake_pipe_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipeGrantConfig
    */
    constructor(scope: Construct, id: string, config: PipeGrantConfig);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _onFuture?;
    get onFuture(): boolean | cdktf.IResolvable;
    set onFuture(value: boolean | cdktf.IResolvable);
    resetOnFuture(): void;
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _pipeName?;
    get pipeName(): string;
    set pipeName(value: string);
    resetPipeName(): void;
    get pipeNameInput(): string | undefined;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
