import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserOwnershipGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to remove or transfer all existing outbound privileges on the object when ownership is transferred to a new role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user_ownership_grant#current_grants UserOwnershipGrant#current_grants}
    */
    readonly currentGrants?: string;
    /**
    * The name of the user ownership is granted on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user_ownership_grant#on_user_name UserOwnershipGrant#on_user_name}
    */
    readonly onUserName: string;
    /**
    * The name of the role to grant ownership. Please ensure that the role that terraform is using is granted access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user_ownership_grant#to_role_name UserOwnershipGrant#to_role_name}
    */
    readonly toRoleName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/user_ownership_grant snowflake_user_ownership_grant}
*/
export declare class UserOwnershipGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_user_ownership_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/user_ownership_grant snowflake_user_ownership_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserOwnershipGrantConfig
    */
    constructor(scope: Construct, id: string, config: UserOwnershipGrantConfig);
    private _currentGrants?;
    get currentGrants(): string;
    set currentGrants(value: string);
    resetCurrentGrants(): void;
    get currentGrantsInput(): string | undefined;
    get id(): string;
    private _onUserName?;
    get onUserName(): string;
    set onUserName(value: string);
    get onUserNameInput(): string | undefined;
    private _toRoleName?;
    get toRoleName(): string;
    set toRoleName(value: string);
    get toRoleNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
