"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const appscaling = require("../lib");
const util_1 = require("./util");
module.exports = {
    'test scalable target creation'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new appscaling.ScalableTarget(stack, 'Target', {
            serviceNamespace: appscaling.ServiceNamespace.DYNAMODB,
            scalableDimension: 'test:TestCount',
            resourceId: 'test:this/test',
            minCapacity: 1,
            maxCapacity: 20,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApplicationAutoScaling::ScalableTarget', {
            ServiceNamespace: 'dynamodb',
            ScalableDimension: 'test:TestCount',
            ResourceId: 'test:this/test',
            MinCapacity: 1,
            MaxCapacity: 20,
        }));
        test.done();
    },
    'add scheduled scaling'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const target = util_1.createScalableTarget(stack);
        // WHEN
        target.scaleOnSchedule('ScaleUp', {
            schedule: appscaling.Schedule.rate(core_1.Duration.minutes(1)),
            maxCapacity: 50,
            minCapacity: 1,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApplicationAutoScaling::ScalableTarget', {
            ScheduledActions: [
                {
                    ScalableTargetAction: {
                        MaxCapacity: 50,
                        MinCapacity: 1
                    },
                    Schedule: "rate(1 minute)",
                    ScheduledActionName: "ScaleUp"
                }
            ]
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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