# Copyright (C) 2021 Tristan Havelick
#
# This file is part of ssdeep-stubs.
#
# ssdeep-stubs is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# ssdeep-stubs is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ssdeep-stubs.  If not, see <http://www.gnu.org/licenses/>.

from setuptools import setup
import os

name = "ssdeep-stubs"
description = "python-ssdeep stubs and mypy plugin"

install_instructions = """\
This package generated by mypy stubgen with some modifications

Changelog:
0.0.1: Types for ssdeep module.

## Installation

```
pip install ssdeep-stubs
```

"""


def find_stub_files():
    result = []
    for root, _, files in os.walk(name):
        for file in files:
            if file.endswith(".pyi"):
                if os.path.sep in root:
                    sub_root = root.split(os.path.sep, 1)[-1]
                    file = os.path.join(sub_root, file)
                result.append(file)
    return result


setup(
    name="ssdeep-stubs",
    version="0.0.1",
    description=description,
    long_description=install_instructions,
    long_description_content_type="text/markdown",
    author="Tristan Havelick",
    author_email="tristan@havelick.com",
    license="GPL",
    url="https://github.com/thavelick/python-ssdeep-stubs",
    py_modules=[],
    install_requires=["mypy"],
    packages=["ssdeep-stubs"],
    package_data={"ssdeep-stubs": find_stub_files()},
    classifiers=["Development Status :: 3 - Alpha", "Programming Language :: Python :: 3",],
)
