from __future__ import annotations

from typing import Any

from paddle.fluid import core

class PyLayerContext:
    container: Any = ...
    def __init__(self) -> None: ...
    def save_for_backward(self, *tensors: Any) -> None: ...
    def saved_tensor(self): ...

def with_mateclass(meta: Any, *bases: Any): ...

class CPyLayer:
    @classmethod
    def apply(cls, *args: Any, **kwargs: Any): ...

class PyLayerBackward(PyLayerContext):
    def backward(self, *args: Any, **kwargs: Any): ...

class LayerMeta(type):
    def __init__(cls, name: Any, bases: Any, attrs: Any): ...

class PyLayer:
    @staticmethod
    def forward(ctx: Any, *args: Any, **kwargs: Any) -> None: ...
    @staticmethod
    def backward(ctx: Any, *args: Any, **kwargs: Any) -> None: ...

class EagerPyLayerContext:
    container: Any = ...
    def save_for_backward(self, *tensors: Any) -> None: ...
    def saved_tensor(self): ...
    dirty_tensors: Any = ...
    def mark_dirty(self, *args: Any) -> None: ...
    non_differentiable: Any = ...
    def mark_non_differentiable(self, *args: Any) -> None: ...
    materialize_grads: Any = ...
    def set_materialize_grads(self, value: bool) -> Any: ...

class EagerPyLayerBackward(core.eager.PyLayer, EagerPyLayerContext):
    def backward(self, *args: Any): ...

class EagerPyLayerMeta(type):
    def __init__(cls, name: Any, bases: Any, attrs: Any): ...

class EagerPyLayer:
    @staticmethod
    def forward(ctx: Any, *args: Any, **kwargs: Any) -> None: ...
    @staticmethod
    def backward(ctx: Any, *args: Any) -> None: ...

def once_differentiable(backward: Any): ...
