from __future__ import annotations

from typing import Any, Optional

class TunableVariable:
    name: Any = ...
    def __init__(self, name: Any, default: Optional[Any] = ...) -> None: ...
    @property
    def default(self): ...
    def get_state(self): ...
    @classmethod
    def from_state(cls, state: Any): ...

class Fixed(TunableVariable):
    name: Any = ...
    def __init__(self, name: Any, default: Any) -> None: ...
    def random(self, seed: Optional[Any] = ...): ...

class Boolean(TunableVariable):
    def __init__(self, name: Any, default: bool = ...) -> None: ...
    def random(self, seed: Optional[Any] = ...): ...

class Choice(TunableVariable):
    values: Any = ...
    def __init__(self, name: Any, values: Any, default: Optional[Any] = ...) -> None: ...
    @property
    def default(self): ...
    def random(self, seed: Optional[Any] = ...): ...
    def get_state(self): ...

class IntRange(TunableVariable):
    start: Any = ...
    stop: Any = ...
    step: Any = ...
    endpoint: Any = ...
    def __init__(
        self, name: Any, start: Any, stop: Any, step: int = ..., default: Optional[Any] = ..., endpoint: bool = ...
    ) -> None: ...
    @property
    def default(self): ...
    def random(self, seed: Optional[Any] = ...): ...
    def get_state(self): ...

class FloatRange(TunableVariable):
    stop: Any = ...
    start: Any = ...
    step: Any = ...
    endpoint: Any = ...
    def __init__(
        self,
        name: Any,
        start: Any,
        stop: Any,
        step: Optional[Any] = ...,
        default: Optional[Any] = ...,
        endpoint: bool = ...,
    ) -> None: ...
    @property
    def default(self): ...
    def random(self, seed: Optional[Any] = ...): ...
    def get_state(self): ...
