from __future__ import annotations

from typing import Any

from paddle.fluid.framework import Parameter as Parameter
from paddle.fluid.framework import Variable as Variable

from ..base.private_helper_function import wait_server_ready as wait_server_ready
from .runtime_base import RuntimeBase as RuntimeBase

def conv_indent(indent: Any): ...

PSERVER_SAVE_SUFFIX: str

def parse_table_class(varname: Any, o_main_program: Any): ...
def get_default_accessor_proto(accessor: Any, varname: Any, o_main_program: Any) -> None: ...
def check_embedding_dim(accessor: Any, varname: Any, o_main_program: Any) -> None: ...

class Accessor:
    accessor_class: str = ...
    optimizer: Any = ...
    feature_dim: int = ...
    embedding_dim: int = ...
    def __init__(self) -> None: ...
    def to_string(self, indent: Any): ...

class CommonAccessor:
    accessor_class: str = ...
    table_name: Any = ...
    entry: Any = ...
    attrs: Any = ...
    params: Any = ...
    dims: Any = ...
    trainer_num: int = ...
    sync: str = ...
    table_num: Any = ...
    table_dim: Any = ...
    initializers: Any = ...
    opt_input_map: Any = ...
    opt_attr_map: Any = ...
    opt_init_map: Any = ...
    def __init__(self) -> None: ...
    def define_optimize_map(self) -> None: ...
    def parse_entry(self, varname: Any, o_main_program: Any) -> None: ...
    def get_shard(self, total_dim: Any, shard_num: Any, pserver_id: Any): ...
    def get_initializer_attr(self, value_name: Any, o_startup_program: Any): ...
    def parse_by_optimizer(
        self, grad_name: Any, is_sparse: Any, size: Any, single_dim: Any, compiled_strategy: Any, adam_d2sum: Any
    ) -> None: ...
    def to_string(self, indent: Any): ...

class Tensor:
    main_program_id: Any = ...
    startup_program_id: Any = ...
    feed_var_name: Any = ...
    fetch_var_name: Any = ...
    tensor_table_class: bool = ...
    def __init__(self) -> None: ...
    def to_string(self, indent: Any): ...

class Table:
    id: int = ...
    table_class: Any = ...
    shard_num: int = ...
    type: Any = ...
    accessor: Any = ...
    common: Any = ...
    tensor: Any = ...
    accessor_proto: Any = ...
    def __init__(self) -> None: ...
    def to_string(self, indent: Any): ...

class Service:
    server_class: str = ...
    client_class: str = ...
    service_class: str = ...
    start_server_port: int = ...
    server_thread_num: int = ...
    def __init__(self) -> None: ...
    def to_string(self, indent: Any): ...

class DownpourServer:
    service: Any = ...
    tables: Any = ...
    def __init__(self) -> None: ...
    def set_service_param(self, service: Any) -> None: ...
    def append_tables(self, table: Any) -> None: ...
    def to_string(self, indent: Any): ...

class Server:
    servers: Any = ...
    def __init__(self) -> None: ...
    def add_server(self, server: Any) -> None: ...

class DownpourWorker:
    tables: Any = ...
    def __init__(self) -> None: ...
    def append_tables(self, table: Any) -> None: ...
    def to_string(self, indent: Any): ...

class Worker:
    workers: Any = ...
    def __init__(self) -> None: ...
    def add_worker(self, worker: Any) -> None: ...

class fsClient:
    proto: Any = ...
    uri: Any = ...
    user: Any = ...
    passwd: Any = ...
    hadoop_bin: Any = ...
    def __init__(self, proto: Any) -> None: ...
    def to_string(self): ...

class TheOnePSRuntime(RuntimeBase):
    def __init__(self) -> None: ...
    def build_compiled_startegy(self): ...
    def load_model(self, path: Any, mode: Any) -> None: ...
