from __future__ import annotations

from typing import Any

from ... import Tensor, nn
from ..ops import ConvNormActivation as ConvNormActivation

model_urls: Any

class SqueezeExcitation(nn.Layer):
    avgpool: Any = ...
    fc1: Any = ...
    fc2: Any = ...
    activation: Any = ...
    scale_activation: Any = ...
    def __init__(
        self, input_channels: Any, squeeze_channels: Any, activation: Any = ..., scale_activation: Any = ...
    ) -> None: ...
    def forward(self, input: Any) -> Tensor: ...

class InvertedResidualConfig:
    in_channels: Any = ...
    kernel: Any = ...
    expanded_channels: Any = ...
    out_channels: Any = ...
    use_se: Any = ...
    activation_layer: Any = ...
    stride: Any = ...
    def __init__(
        self,
        in_channels: Any,
        kernel: Any,
        expanded_channels: Any,
        out_channels: Any,
        use_se: Any,
        activation: Any,
        stride: Any,
        scale: float = ...,
    ) -> None: ...
    @staticmethod
    def adjust_channels(channels: Any, scale: float = ...) -> int: ...

class InvertedResidual(nn.Layer):
    use_res_connect: Any = ...
    use_se: Any = ...
    expand: Any = ...
    expand_conv: Any = ...
    bottleneck_conv: Any = ...
    mid_se: Any = ...
    linear_conv: Any = ...
    def __init__(
        self,
        in_channels: Any,
        expanded_channels: Any,
        out_channels: Any,
        filter_size: Any,
        stride: Any,
        use_se: Any,
        activation_layer: Any,
        norm_layer: Any,
    ) -> None: ...
    def forward(self, x: Any) -> Tensor: ...

class MobileNetV3(nn.Layer):
    config: Any = ...
    scale: Any = ...
    last_channel: Any = ...
    num_classes: Any = ...
    with_pool: Any = ...
    firstconv_in_channels: Any = ...
    lastconv_in_channels: Any = ...
    lastconv_out_channels: Any = ...
    conv: Any = ...
    blocks: Any = ...
    lastconv: Any = ...
    avgpool: Any = ...
    classifier: Any = ...
    def __init__(
        self, config: Any, last_channel: Any, scale: float = ..., num_classes: int = ..., with_pool: bool = ...
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class MobileNetV3Small(MobileNetV3):
    def __init__(
        self,
        scale: float = ...,
        num_classes: int = ...,
        with_pool: bool = ...,
    ) -> None: ...

class MobileNetV3Large(MobileNetV3):
    def __init__(
        self,
        scale: float = ...,
        num_classes: int = ...,
        with_pool: bool = ...,
    ) -> None: ...

def mobilenet_v3_small(
    pretrained: bool = ...,
    scale: float = ...,
    *,
    num_classes: int = ...,
    with_pool: bool = ...,
) -> MobileNetV3Small: ...
def mobilenet_v3_large(
    pretrained: bool = ...,
    scale: float = ...,
    *,
    num_classes: int = ...,
    with_pool: bool = ...,
) -> MobileNetV3Large: ...
