# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['paddle-stubs']

package_data = \
{'': ['*'],
 'paddle-stubs': ['_typing/*',
                  'amp/*',
                  'autograd/*',
                  'cost_model/*',
                  'dataset/*',
                  'device/*',
                  'device/cuda/*',
                  'distributed/*',
                  'distributed/auto_parallel/*',
                  'distributed/auto_parallel/cost/*',
                  'distributed/auto_parallel/operators/*',
                  'distributed/auto_parallel/tuner/*',
                  'distributed/fleet/*',
                  'distributed/fleet/base/*',
                  'distributed/fleet/data_generator/*',
                  'distributed/fleet/dataset/*',
                  'distributed/fleet/elastic/*',
                  'distributed/fleet/meta_optimizers/*',
                  'distributed/fleet/meta_optimizers/ascend/*',
                  'distributed/fleet/meta_optimizers/dygraph_optimizer/*',
                  'distributed/fleet/meta_optimizers/sharding/*',
                  'distributed/fleet/meta_parallel/*',
                  'distributed/fleet/meta_parallel/parallel_layers/*',
                  'distributed/fleet/meta_parallel/pp_utils/*',
                  'distributed/fleet/meta_parallel/sharding/*',
                  'distributed/fleet/metrics/*',
                  'distributed/fleet/runtime/*',
                  'distributed/fleet/utils/*',
                  'distributed/launch/*',
                  'distributed/launch/context/*',
                  'distributed/launch/controllers/*',
                  'distributed/launch/job/*',
                  'distributed/launch/plugins/*',
                  'distributed/launch/utils/*',
                  'distributed/metric/*',
                  'distributed/models/*',
                  'distributed/models/moe/*',
                  'distributed/passes/*',
                  'distributed/ps/*',
                  'distributed/ps/utils/*',
                  'distributed/sharding/*',
                  'distribution/*',
                  'fluid/*',
                  'fluid/contrib/*',
                  'fluid/contrib/decoder/*',
                  'fluid/contrib/extend_optimizer/*',
                  'fluid/contrib/layers/*',
                  'fluid/contrib/mixed_precision/*',
                  'fluid/contrib/mixed_precision/bf16/*',
                  'fluid/contrib/quantize/*',
                  'fluid/contrib/slim/*',
                  'fluid/contrib/slim/quantization/*',
                  'fluid/contrib/slim/quantization/imperative/*',
                  'fluid/contrib/sparsity/*',
                  'fluid/dataloader/*',
                  'fluid/distributed/*',
                  'fluid/dygraph/*',
                  'fluid/dygraph/amp/*',
                  'fluid/dygraph/dygraph_to_static/*',
                  'fluid/incubate/*',
                  'fluid/incubate/checkpoint/*',
                  'fluid/incubate/data_generator/*',
                  'fluid/incubate/fleet/*',
                  'fluid/incubate/fleet/base/*',
                  'fluid/incubate/fleet/collective/*',
                  'fluid/incubate/fleet/parameter_server/*',
                  'fluid/incubate/fleet/parameter_server/distribute_transpiler/*',
                  'fluid/incubate/fleet/parameter_server/ir/*',
                  'fluid/incubate/fleet/parameter_server/pslib/*',
                  'fluid/incubate/fleet/utils/*',
                  'fluid/inference/*',
                  'fluid/layers/*',
                  'fluid/transpiler/*',
                  'fluid/transpiler/details/*',
                  'framework/*',
                  'hapi/*',
                  'incubate/*',
                  'incubate/autograd/*',
                  'incubate/checkpoint/*',
                  'incubate/multiprocessing/*',
                  'incubate/nn/*',
                  'incubate/nn/functional/*',
                  'incubate/nn/layer/*',
                  'incubate/operators/*',
                  'incubate/optimizer/*',
                  'incubate/optimizer/functional/*',
                  'incubate/passes/*',
                  'incubate/tensor/*',
                  'io/*',
                  'jit/*',
                  'jit/dy2static/*',
                  'libs/*',
                  'metric/*',
                  'nn/*',
                  'nn/functional/*',
                  'nn/initializer/*',
                  'nn/layer/*',
                  'nn/quant/*',
                  'nn/utils/*',
                  'onnx/*',
                  'optimizer/*',
                  'profiler/*',
                  'reader/*',
                  'reader/tests/*',
                  'sparse/*',
                  'sparse/functional/*',
                  'sparse/layer/*',
                  'static/*',
                  'static/amp/*',
                  'static/nn/*',
                  'static/sparsity/*',
                  'tensor/*',
                  'text/*',
                  'text/datasets/*',
                  'utils/*',
                  'utils/cpp_extension/*',
                  'utils/gast/*',
                  'vision/*',
                  'vision/datasets/*',
                  'vision/models/*',
                  'vision/transforms/*']}

install_requires = \
['paddlepaddle>=2.3.0,<3.0.0', 'typing-extensions>=4.3.0,<5.0.0']

setup_kwargs = {
    'name': 'paddlepaddle-stubs',
    'version': '2.3.1a5',
    'description': '',
    'long_description': '# PaddlePaddle Stubs <sup>WIP</sup>\n\nA stubs package as described in [PEP 561](https://peps.python.org/pep-0561/) for [PaddlePaddle](https://github.com/PaddlePaddle/Paddle).\n\n<p align="center">\n   <a href="https://python.org/" target="_blank"><img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/paddlepaddle-stubs?logo=python&style=flat-square"></a>\n   <a href="https://pypi.org/project/paddlepaddle-stubs/" target="_blank"><img src="https://img.shields.io/pypi/v/paddlepaddle-stubs?style=flat-square" alt="pypi"></a>\n   <a href="https://pypi.org/project/paddlepaddle-stubs/" target="_blank"><img alt="PyPI - Downloads" src="https://img.shields.io/pypi/dm/paddlepaddle-stubs?style=flat-square"></a>\n   <a href="LICENSE"><img alt="LICENSE" src="https://img.shields.io/github/license/cattidea/paddlepaddle-stubs?style=flat-square"></a>\n   <a href="https://github.com/psf/black"><img alt="black" src="https://img.shields.io/badge/code%20style-black-000000?style=flat-square"></a>\n   <a href="https://gitmoji.dev"><img src="https://img.shields.io/badge/gitmoji-%20😜%20😍-FFDD67?style=flat-square" alt="Gitmoji"></a>\n</p>\n\n目前仅针对 [Pyright](https://github.com/microsoft/pyright) 进行了编写和测试，尚未支持 [Mypy](https://github.com/python/mypy)（Mypy 相对于 Pyright 太难用了，缺失功能太多），因此目前可能仅仅与 VS Code 的 Pylance 扩展一起工作良好～\n\n> **Note**\n>\n> 本 repo 非运行时库，因此本 repo 中所有示例和单测可能在运行时并不能正常运行，仅仅是为了更加全面和方便对类型进行检查而已。\n\n## Usage\n\n```bash\npip install paddlepaddle-stubs --pre\n```\n\n此时再打开编辑器，查看编辑器的类型提示～～～\n\nVS Code 推荐配置：\n\n```jsonc\n{\n   "python.languageServer": "Pylance",\n   // 现在有一些类型在 strict mode 工作的并不是很好，推荐先使用 basic mode\n   "python.analysis.typeCheckingMode": "basic",\n   "python.analysis.inlayHints.functionReturnTypes": true,\n   "python.analysis.inlayHints.variableTypes": true\n}\n```\n\n## Status\n\n起步阶段，最低支持 Python3.7，目前基于 PaddlePaddle 2.3.1 开发，第一个可用版本应当是 2.3.1 版本或者更晚的 2.4 版本～\n\n## Roadmap\n\nSee [paddlepaddle-stubs 2.3.1 Roadmap](https://github.com/orgs/cattidea/projects/3)\n\n### 2.3.1 alpha\n\n> **Note**\n>\n> 此时本 repo 可 public，并发布到 PyPI\n\n-  [x] 通过 basic mode 的类型检查\n-  [x] 完善全部 P1 级别的类型信息（strict 下工作良好）\n\n### 2.3.1 beta\n\n-  [ ] 完善全部 P2 级别的类型信息（strict 下工作良好）\n-  [ ] [官网示例高层 API 搭建 MNIST 示例代码](./examples/mnist_example.py)在 strict 模式下工作良好\n\n### Future\n\n之后应该是一边升级到新版本（2.4.0），一边继续完善 P3、P4、P5 级别的类型信息（strict 下工作良好）\n\n要添加的还有很多，各个 API 类型信息需要仔细填写（修改自动生成的 `Any`，添加返回值类型），有兴趣的小伙伴可以一起来参与呀～\n',
    'author': 'Nyakku Shigure',
    'author_email': 'sigure.qaq@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/cattidea/paddlepaddle-stubs',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
