# Generated by Django 2.2.4 on 2020-06-19 08:57

import django.contrib.postgres.indexes
from django.db import migrations, models
import django.db.models.deletion
import flatpages_i18n.models
import modeltrans.fields
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='FlatPage_i18n',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='title')),
                ('slug', models.SlugField(blank=True, default='', max_length=150, unique=True)),
                ('machine_name', models.SlugField(blank=True, help_text='unique', max_length=30, verbose_name='machine name')),
                ('content', models.TextField(blank=True, verbose_name='content')),
                ('template_name', models.CharField(blank=True, help_text="Example: 'flatpages_i18n/contact_page.html'. If this isn't provided, the system will use 'flatpages_i18n/default.html'.", max_length=70, verbose_name='template name')),
                ('registration_required', models.BooleanField(default=False, help_text='If this is checked, only logged-in users will be able to view the page.', verbose_name='registration required')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('i18n', modeltrans.fields.TranslationField(fields=('title', 'slug', 'content'), required_languages=(), virtual_fields=True)),
                ('sites', models.ManyToManyField(to='sites.Site')),
            ],
            options={
                'verbose_name': 'flat page',
                'verbose_name_plural': 'flat pages',
                'ordering': ('title',),
            },
            bases=(flatpages_i18n.models.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('machine_name', models.SlugField(unique=True)),
            ],
            options={
                'verbose_name': 'menu',
                'verbose_name_plural': 'menus',
            },
        ),
        migrations.CreateModel(
            name='MenuItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('custom_link', models.CharField(blank=True, max_length=200, verbose_name='custom link')),
                ('target', models.CharField(choices=[('_blank', 'Opens the linked document in a new window or tab'), ('_self', 'Opens the linked document in the same frame as it was clicked'), ('_parent', 'Opens the linked document in the parent frame'), ('_top', 'Opens the linked document in the full body of the window')], default='_self', max_length=7, verbose_name='target')),
                ('title', models.CharField(blank=True, max_length=255, verbose_name='title')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('i18n', modeltrans.fields.TranslationField(fields=('title', 'custom_link'), required_languages=(), virtual_fields=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('flatpage', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='flatpages_i18n.FlatPage_i18n', verbose_name='flatpage')),
                ('menu', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='item_set', to='flatpages_i18n.Menu', verbose_name='menu')),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='flatpages_i18n.MenuItem')),
            ],
            options={
                'verbose_name': 'menu item',
                'verbose_name_plural': 'menu items',
            },
        ),
        migrations.AddIndex(
            model_name='menuitem',
            index=django.contrib.postgres.indexes.GinIndex(fields=['i18n'], name='flatpages_i_i18n_4204f4_gin'),
        ),
        migrations.AddIndex(
            model_name='flatpage_i18n',
            index=django.contrib.postgres.indexes.GinIndex(fields=['i18n'], name='flatpages_i_i18n_ea673c_gin'),
        ),
    ]
