# Generated by Django 3.0.4 on 2020-03-31 12:48

import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
import django.contrib.postgres.indexes
import django.contrib.postgres.search
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import openstates.data.models.base
import re
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Bill",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="bill",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-bill/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-bill/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                ("identifier", models.CharField(max_length=100)),
                ("title", models.TextField()),
                (
                    "classification",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "subject",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_bill"},
        ),
        migrations.CreateModel(
            name="BillAction",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("description", models.TextField()),
                ("date", models.CharField(max_length=25)),
                (
                    "classification",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                ("order", models.PositiveIntegerField()),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, default=dict
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="actions",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billaction", "ordering": ["order"]},
        ),
        migrations.CreateModel(
            name="BillDocument",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("note", models.CharField(max_length=300)),
                ("date", models.CharField(max_length=10)),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, default=dict
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="documents",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billdocument"},
        ),
        migrations.CreateModel(
            name="BillVersion",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("note", models.CharField(max_length=300)),
                ("date", models.CharField(max_length=10)),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, default=dict
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="versions",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billversion"},
        ),
        migrations.CreateModel(
            name="BillVersionLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("media_type", models.CharField(max_length=100)),
                ("url", models.URLField(max_length=2000)),
                ("text", models.TextField(blank=True, default="")),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.BillVersion",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billversionlink"},
        ),
        migrations.CreateModel(
            name="Division",
            fields=[
                (
                    "id",
                    models.CharField(max_length=300, primary_key=True, serialize=False),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The name of the division.", max_length=300
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        help_text="An ISO-3166-1 alpha-2 code identifying the county where this division is found.",
                        max_length=2,
                    ),
                ),
                (
                    "subtype1",
                    models.CharField(
                        blank=True,
                        help_text="The first subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid1",
                    models.CharField(
                        blank=True,
                        help_text="The first subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "subtype2",
                    models.CharField(
                        blank=True,
                        help_text="The second subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid2",
                    models.CharField(
                        blank=True,
                        help_text="The second subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "subtype3",
                    models.CharField(
                        blank=True,
                        help_text="The third subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid3",
                    models.CharField(
                        blank=True,
                        help_text="The third subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "subtype4",
                    models.CharField(
                        blank=True,
                        help_text="The fourth subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid4",
                    models.CharField(
                        blank=True,
                        help_text="The fourth subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "subtype5",
                    models.CharField(
                        blank=True,
                        help_text="The fifth subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid5",
                    models.CharField(
                        blank=True,
                        help_text="The fifth subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "subtype6",
                    models.CharField(
                        blank=True,
                        help_text="The sixth subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid6",
                    models.CharField(
                        blank=True,
                        help_text="The sixth subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "subtype7",
                    models.CharField(
                        blank=True,
                        help_text="The seventh subtype in the unique identifier.",
                        max_length=50,
                    ),
                ),
                (
                    "subid7",
                    models.CharField(
                        blank=True,
                        help_text="The seventh subidentifier in the unique identifer.",
                        max_length=100,
                    ),
                ),
                (
                    "redirect",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Division",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_division"},
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="event",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-event/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-event/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                ("name", models.CharField(max_length=1000)),
                ("description", models.TextField()),
                ("classification", models.CharField(max_length=100)),
                ("start_date", models.CharField(max_length=25)),
                ("end_date", models.CharField(blank=True, max_length=25)),
                ("all_day", models.BooleanField(default=False)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("cancelled", "Cancelled"),
                            ("tentative", "Tentative"),
                            ("confirmed", "Confirmed"),
                            ("passed", "Passed"),
                        ],
                        max_length=20,
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_event"},
        ),
        migrations.CreateModel(
            name="EventAgendaItem",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("description", models.TextField()),
                (
                    "classification",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                ("order", models.CharField(blank=True, max_length=100)),
                (
                    "subjects",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "notes",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, default=dict
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="agenda",
                        to="data.Event",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventagendaitem"},
        ),
        migrations.CreateModel(
            name="EventAgendaMedia",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("note", models.CharField(max_length=300)),
                ("date", models.CharField(blank=True, max_length=25)),
                ("offset", models.PositiveIntegerField(null=True)),
                (
                    "agenda_item",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="media",
                        to="data.EventAgendaItem",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventagendamedia"},
        ),
        migrations.CreateModel(
            name="EventDocument",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("note", models.CharField(max_length=300)),
                ("date", models.CharField(blank=True, max_length=25)),
                (
                    "classification",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("agenda", "Agenda"),
                            ("minutes", "Minutes"),
                            ("transcript", "Transcript"),
                            ("testimony", "Testimony"),
                        ],
                        max_length=50,
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="documents",
                        to="data.Event",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventdocument"},
        ),
        migrations.CreateModel(
            name="EventMedia",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("note", models.CharField(max_length=300)),
                ("date", models.CharField(blank=True, max_length=25)),
                ("offset", models.PositiveIntegerField(null=True)),
                (
                    "classification",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("audio recording", "Audio Recording"),
                            ("video recording", "Video Recording"),
                        ],
                        max_length=50,
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="media",
                        to="data.Event",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventmedia"},
        ),
        migrations.CreateModel(
            name="Jurisdiction",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="jurisdiction",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-jurisdiction/country:[a-z]{2}(/[^\\W\\d]+:[\\w.~-]+)*/\\w+$",
                                regex="^ocd-jurisdiction/country:[a-z]{2}(/[^\\W\\d]+:[\\w.~-]+)*/\\w+$",
                            )
                        ],
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The common name of the Jurisdiction, such as 'Wyoming.'",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="The primary website of the Jurisdiction.",
                        max_length=2000,
                    ),
                ),
                (
                    "classification",
                    models.CharField(
                        choices=[
                            ("government", "Government"),
                            ("legislature", "Legislature"),
                            ("executive", "Executive"),
                            ("school", "School System"),
                            ("park", "Park District"),
                            ("sewer", "Sewer District"),
                            ("forest", "Forest Preserve District"),
                            ("transit_authority", "Transit Authority"),
                        ],
                        db_index=True,
                        default="government",
                        help_text="The type of Jurisdiction being defined.",
                        max_length=50,
                    ),
                ),
                (
                    "feature_flags",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        help_text="A list of features that are present for data in this jurisdiction.",
                        size=None,
                    ),
                ),
                (
                    "division",
                    models.ForeignKey(
                        help_text="A link to a Division related to this Jurisdiction.",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="jurisdictions",
                        to="data.Division",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_jurisdiction"},
        ),
        migrations.CreateModel(
            name="LegislativeSession",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("identifier", models.CharField(max_length=100)),
                ("name", models.CharField(max_length=300)),
                (
                    "classification",
                    models.CharField(
                        blank=True,
                        choices=[("primary", "Primary"), ("special", "Special")],
                        max_length=100,
                    ),
                ),
                ("start_date", models.CharField(max_length=10)),
                ("end_date", models.CharField(max_length=10)),
                (
                    "jurisdiction",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="legislative_sessions",
                        to="data.Jurisdiction",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_legislativesession"},
        ),
        migrations.CreateModel(
            name="Membership",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="membership",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-membership/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-membership/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                (
                    "person_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The name of the Person that is a member of the Organization.",
                        max_length=300,
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="A label describing the membership.",
                        max_length=300,
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        blank=True,
                        help_text="The role that the member fulfills in the Organization.",
                        max_length=300,
                    ),
                ),
                (
                    "start_date",
                    models.CharField(
                        blank=True,
                        help_text="The date on which the relationship began in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "end_date",
                    models.CharField(
                        blank=True,
                        help_text="The date on which the relationship ended in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_membership"},
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="organization",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-organization/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-organization/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The name of the Organization.", max_length=300
                    ),
                ),
                (
                    "image",
                    models.URLField(
                        blank=True,
                        help_text="A URL leading to an image that identifies the Organization visually.",
                        max_length=2000,
                    ),
                ),
                (
                    "classification",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("legislature", "Legislature"),
                            ("executive", "Executive"),
                            ("upper", "Upper Chamber"),
                            ("lower", "Lower Chamber"),
                            ("party", "Party"),
                            ("committee", "Committee"),
                            ("commission", "Commission"),
                            ("corporation", "Corporation"),
                            ("agency", "Agency"),
                            ("department", "Department"),
                            ("judiciary", "Judiciary"),
                        ],
                        help_text="The type of Organization being defined.",
                        max_length=100,
                    ),
                ),
                (
                    "founding_date",
                    models.CharField(
                        blank=True,
                        help_text="The founding date of the Organization in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "dissolution_date",
                    models.CharField(
                        blank=True,
                        help_text="The dissolution date of the Organization in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "jurisdiction",
                    models.ForeignKey(
                        help_text="A link to the Jurisdiction that contains this Organization.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="organizations",
                        to="data.Jurisdiction",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        help_text="A link to another Organization that serves as this Organization's parent.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="children",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_organization"},
        ),
        migrations.CreateModel(
            name="Person",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="person",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-person/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-person/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="A Person's preferred full name.",
                        max_length=300,
                    ),
                ),
                (
                    "sort_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A version of a Person's full name rearranged for alphabetical sorting.",
                        max_length=100,
                    ),
                ),
                (
                    "family_name",
                    models.CharField(
                        blank=True, help_text="A Person's family name.", max_length=100
                    ),
                ),
                (
                    "given_name",
                    models.CharField(
                        blank=True, help_text="A Person's given name.", max_length=100
                    ),
                ),
                (
                    "image",
                    models.URLField(
                        blank=True,
                        help_text="A URL leading to an image that identifies the Person visually.",
                        max_length=2000,
                    ),
                ),
                (
                    "gender",
                    models.CharField(
                        blank=True, help_text="A Person's gender", max_length=100
                    ),
                ),
                (
                    "summary",
                    models.CharField(
                        blank=True,
                        help_text="A short, one-line account of a Person's life.",
                        max_length=500,
                    ),
                ),
                (
                    "national_identity",
                    models.CharField(
                        blank=True,
                        help_text="The nation a Person is identified with.",
                        max_length=300,
                    ),
                ),
                (
                    "biography",
                    models.TextField(
                        blank=True, help_text="An extended account of a Person's life."
                    ),
                ),
                (
                    "birth_date",
                    models.CharField(
                        blank=True,
                        help_text="The date of a Person's birth in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "death_date",
                    models.CharField(
                        blank=True,
                        help_text="The date of a Person's death in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "people",
                "db_table": "opencivicdata_person",
            },
        ),
        migrations.CreateModel(
            name="Post",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        default=dict,
                        help_text="A key-value store for storing arbitrary information not covered elsewhere.",
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="post",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-post/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-post/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        help_text="A label describing the Post.", max_length=300
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        blank=True,
                        help_text="The function that the holder of the post fulfills.",
                        max_length=300,
                    ),
                ),
                (
                    "start_date",
                    models.CharField(
                        blank=True,
                        help_text="An optional start date for the Post in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "end_date",
                    models.CharField(
                        blank=True,
                        help_text="An optional end date for the Post in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "maximum_memberships",
                    models.PositiveIntegerField(
                        default=1,
                        help_text="The maximum number of people who can hold this Post.",
                    ),
                ),
                (
                    "division",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="The Division where the post exists.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="posts",
                        to="data.Division",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        help_text="The Organization in which the post is held.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="posts",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_post"},
        ),
        migrations.CreateModel(
            name="VoteEvent",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time of creation."
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="The date and time of the last update."
                    ),
                ),
                (
                    "locked_fields",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "id",
                    openstates.data.models.base.OCDIDField(
                        ocd_type="vote",
                        serialize=False,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["UNICODE"],
                                message="ID must match ^ocd-vote/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                                regex="^ocd-vote/[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$",
                            )
                        ],
                    ),
                ),
                ("identifier", models.CharField(blank=True, max_length=300)),
                ("motion_text", models.TextField()),
                (
                    "motion_classification",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                ("start_date", models.CharField(max_length=25)),
                ("end_date", models.CharField(blank=True, max_length=25)),
                (
                    "result",
                    models.CharField(
                        choices=[("pass", "Pass"), ("fail", "Fail")], max_length=50
                    ),
                ),
                (
                    "extras",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, default=dict
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="votes",
                        to="data.Bill",
                    ),
                ),
                (
                    "bill_action",
                    models.OneToOneField(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="vote",
                        to="data.BillAction",
                    ),
                ),
                (
                    "legislative_session",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="votes",
                        to="data.LegislativeSession",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="votes",
                        to="data.Organization",
                    ),
                ),
            ],
            options={
                "db_table": "opencivicdata_voteevent",
                "index_together": {
                    ("legislative_session", "bill"),
                    ("legislative_session", "identifier", "bill"),
                },
            },
        ),
        migrations.CreateModel(
            name="VoteSource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "vote_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sources",
                        to="data.VoteEvent",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_votesource"},
        ),
        migrations.CreateModel(
            name="VoteCount",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "option",
                    models.CharField(
                        choices=[
                            ("yes", "Yes"),
                            ("no", "No"),
                            ("absent", "Absent"),
                            ("abstain", "Abstain"),
                            ("not voting", "Not Voting"),
                            ("paired", "Paired"),
                            ("excused", "Excused"),
                            ("other", "Other"),
                        ],
                        max_length=50,
                    ),
                ),
                ("value", models.PositiveIntegerField()),
                (
                    "vote_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="counts",
                        to="data.VoteEvent",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_votecount"},
        ),
        migrations.CreateModel(
            name="SearchableBill",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "search_vector",
                    django.contrib.postgres.search.SearchVectorField(default=None),
                ),
                ("all_titles", models.TextField(default="")),
                ("raw_text", models.TextField(default="")),
                ("is_error", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "bill",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="searchable",
                        to="data.Bill",
                    ),
                ),
                (
                    "version_link",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="searchable",
                        to="data.BillVersionLink",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_searchablebill"},
        ),
        migrations.CreateModel(
            name="RelatedBill",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("identifier", models.CharField(max_length=100)),
                ("legislative_session", models.CharField(max_length=100)),
                (
                    "relation_type",
                    models.CharField(
                        choices=[
                            ("companion", "Companion"),
                            ("prior-session", "Prior Session"),
                            ("replaced-by", "Replaced By"),
                            ("replaces", "Replaces"),
                        ],
                        max_length=100,
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="related_bills",
                        to="data.Bill",
                    ),
                ),
                (
                    "related_bill",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="related_bills_reverse",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_relatedbill"},
        ),
        migrations.CreateModel(
            name="PostLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "post",
                    models.ForeignKey(
                        help_text="A reference to the Post connected to this link.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.Post",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_postlink"},
        ),
        migrations.CreateModel(
            name="PostContactDetail",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("address", "Postal Address"),
                            ("email", "Email"),
                            ("url", "URL"),
                            ("fax", "Fax"),
                            ("text", "Text Phone"),
                            ("voice", "Voice Phone"),
                            ("video", "Video Phone"),
                            ("pager", "Pager"),
                            ("textphone", "Device for people with hearing impairment"),
                        ],
                        help_text="The type of Contact being defined.",
                        max_length=50,
                    ),
                ),
                (
                    "value",
                    models.CharField(
                        help_text="The content of the Contact information like a phone number or email address.",
                        max_length=300,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note about the Contact value.",
                        max_length=300,
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="A title for the content of the Contact.",
                        max_length=300,
                    ),
                ),
                (
                    "post",
                    models.ForeignKey(
                        help_text="A link to the Post connected to this contact.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contact_details",
                        to="data.Post",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_postcontactdetail"},
        ),
        migrations.CreateModel(
            name="PersonVote",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "option",
                    models.CharField(
                        choices=[
                            ("yes", "Yes"),
                            ("no", "No"),
                            ("absent", "Absent"),
                            ("abstain", "Abstain"),
                            ("not voting", "Not Voting"),
                            ("paired", "Paired"),
                            ("excused", "Excused"),
                            ("other", "Other"),
                        ],
                        max_length=50,
                    ),
                ),
                ("voter_name", models.CharField(max_length=300)),
                ("note", models.TextField(blank=True)),
                (
                    "vote_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="votes",
                        to="data.VoteEvent",
                    ),
                ),
                (
                    "voter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="votes",
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_personvote"},
        ),
        migrations.CreateModel(
            name="PersonSource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        help_text="A link to the Person connected to this source.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sources",
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_personsource"},
        ),
        migrations.CreateModel(
            name="PersonName",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True, help_text="An alternative name.", max_length=500
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note about alternative name.",
                        max_length=500,
                    ),
                ),
                (
                    "start_date",
                    models.CharField(
                        blank=True,
                        help_text="An optional start date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "end_date",
                    models.CharField(
                        blank=True,
                        help_text="An optional end date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        help_text="A link to the Person connected to this alternative name.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="other_names",
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_personname"},
        ),
        migrations.CreateModel(
            name="PersonLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        help_text="A reference to the Person connected to this link.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_personlink"},
        ),
        migrations.CreateModel(
            name="PersonIdentifier",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "identifier",
                    models.CharField(
                        help_text="A unique identifier developed by an upstream or third party source.",
                        max_length=300,
                    ),
                ),
                (
                    "scheme",
                    models.CharField(
                        help_text="The name of the service that created the identifier.",
                        max_length=300,
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        help_text="A link to the Person connected to this alternative identifier.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="identifiers",
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_personidentifier"},
        ),
        migrations.CreateModel(
            name="PersonContactDetail",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("address", "Postal Address"),
                            ("email", "Email"),
                            ("url", "URL"),
                            ("fax", "Fax"),
                            ("text", "Text Phone"),
                            ("voice", "Voice Phone"),
                            ("video", "Video Phone"),
                            ("pager", "Pager"),
                            ("textphone", "Device for people with hearing impairment"),
                        ],
                        help_text="The type of Contact being defined.",
                        max_length=50,
                    ),
                ),
                (
                    "value",
                    models.CharField(
                        help_text="The content of the Contact information like a phone number or email address.",
                        max_length=300,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note about the Contact value.",
                        max_length=300,
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="A title for the content of the Contact.",
                        max_length=300,
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        help_text="A link to the Person connected to this contact.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contact_details",
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_personcontactdetail"},
        ),
        migrations.CreateModel(
            name="OrganizationSource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        help_text="A link to the Organization connected to this source.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sources",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_organizationsource"},
        ),
        migrations.CreateModel(
            name="OrganizationName",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True, help_text="An alternative name.", max_length=500
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note about alternative name.",
                        max_length=500,
                    ),
                ),
                (
                    "start_date",
                    models.CharField(
                        blank=True,
                        help_text="An optional start date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "end_date",
                    models.CharField(
                        blank=True,
                        help_text="An optional end date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                        max_length=10,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        help_text="A link to the Organization with this alternative name.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="other_names",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_organizationname"},
        ),
        migrations.CreateModel(
            name="OrganizationLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        help_text="A reference to the Organization connected to this link.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_organizationlink"},
        ),
        migrations.CreateModel(
            name="OrganizationIdentifier",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "identifier",
                    models.CharField(
                        help_text="A unique identifier developed by an upstream or third party source.",
                        max_length=300,
                    ),
                ),
                (
                    "scheme",
                    models.CharField(
                        help_text="The name of the service that created the identifier.",
                        max_length=300,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        help_text="Reference to the Organization identified by this alternative identifier.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="identifiers",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_organizationidentifier"},
        ),
        migrations.CreateModel(
            name="OrganizationContactDetail",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("address", "Postal Address"),
                            ("email", "Email"),
                            ("url", "URL"),
                            ("fax", "Fax"),
                            ("text", "Text Phone"),
                            ("voice", "Voice Phone"),
                            ("video", "Video Phone"),
                            ("pager", "Pager"),
                            ("textphone", "Device for people with hearing impairment"),
                        ],
                        help_text="The type of Contact being defined.",
                        max_length=50,
                    ),
                ),
                (
                    "value",
                    models.CharField(
                        help_text="The content of the Contact information like a phone number or email address.",
                        max_length=300,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note about the Contact value.",
                        max_length=300,
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="A title for the content of the Contact.",
                        max_length=300,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        help_text="A link to the Organization connected to this contact.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contact_details",
                        to="data.Organization",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_organizationcontactdetail"},
        ),
        migrations.CreateModel(
            name="MembershipLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "membership",
                    models.ForeignKey(
                        help_text="A reference to the Membership connected to this link.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.Membership",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_membershiplink"},
        ),
        migrations.CreateModel(
            name="MembershipContactDetail",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("address", "Postal Address"),
                            ("email", "Email"),
                            ("url", "URL"),
                            ("fax", "Fax"),
                            ("text", "Text Phone"),
                            ("voice", "Voice Phone"),
                            ("video", "Video Phone"),
                            ("pager", "Pager"),
                            ("textphone", "Device for people with hearing impairment"),
                        ],
                        help_text="The type of Contact being defined.",
                        max_length=50,
                    ),
                ),
                (
                    "value",
                    models.CharField(
                        help_text="The content of the Contact information like a phone number or email address.",
                        max_length=300,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note about the Contact value.",
                        max_length=300,
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="A title for the content of the Contact.",
                        max_length=300,
                    ),
                ),
                (
                    "membership",
                    models.ForeignKey(
                        help_text="A link to the Membership connected to this contact.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contact_details",
                        to="data.Membership",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_membershipcontactdetail"},
        ),
        migrations.AddField(
            model_name="membership",
            name="on_behalf_of",
            field=models.ForeignKey(
                help_text="The Organization on whose behalf the Person is a member of the Organization.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="memberships_on_behalf_of",
                to="data.Organization",
            ),
        ),
        migrations.AddField(
            model_name="membership",
            name="organization",
            field=models.ForeignKey(
                help_text="A link to the Organization in which the Person is a member.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="memberships",
                to="data.Organization",
            ),
        ),
        migrations.AddField(
            model_name="membership",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person that is a member of the Organization.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="memberships",
                to="data.Person",
            ),
        ),
        migrations.AddField(
            model_name="membership",
            name="post",
            field=models.ForeignKey(
                help_text="\tThe Post held by the member in the Organization.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="memberships",
                to="data.Post",
            ),
        ),
        migrations.CreateModel(
            name="EventSource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sources",
                        to="data.Event",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventsource"},
        ),
        migrations.CreateModel(
            name="EventRelatedEntity",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=2000)),
                ("entity_type", models.CharField(blank=True, max_length=20)),
                ("note", models.TextField()),
                (
                    "agenda_item",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="related_entities",
                        to="data.EventAgendaItem",
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Bill",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Organization",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Person",
                    ),
                ),
                (
                    "vote_event",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.VoteEvent",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventrelatedentity"},
        ),
        migrations.CreateModel(
            name="EventParticipant",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=2000)),
                ("entity_type", models.CharField(blank=True, max_length=20)),
                ("note", models.TextField()),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="participants",
                        to="data.Event",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Organization",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventparticipant"},
        ),
        migrations.CreateModel(
            name="EventMediaLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("media_type", models.CharField(max_length=100)),
                ("url", models.URLField(max_length=2000)),
                ("text", models.TextField(blank=True, default="")),
                (
                    "media",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.EventMedia",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventmedialink"},
        ),
        migrations.CreateModel(
            name="EventLocation",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=200)),
                ("url", models.URLField(blank=True, max_length=2000)),
                (
                    "coordinates",
                    django.contrib.gis.db.models.fields.PointField(
                        null=True, srid=4326
                    ),
                ),
                (
                    "jurisdiction",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="event_locations",
                        to="data.Jurisdiction",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventlocation"},
        ),
        migrations.CreateModel(
            name="EventLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.Event",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventlink"},
        ),
        migrations.CreateModel(
            name="EventDocumentLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("media_type", models.CharField(max_length=100)),
                ("url", models.URLField(max_length=2000)),
                ("text", models.TextField(blank=True, default="")),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.EventDocument",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventdocumentlink"},
        ),
        migrations.CreateModel(
            name="EventAgendaMediaLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("media_type", models.CharField(max_length=100)),
                ("url", models.URLField(max_length=2000)),
                ("text", models.TextField(blank=True, default="")),
                (
                    "media",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.EventAgendaMedia",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_eventagendamedialink"},
        ),
        migrations.AddField(
            model_name="event",
            name="jurisdiction",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="events",
                to="data.Jurisdiction",
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="data.EventLocation",
            ),
        ),
        migrations.CreateModel(
            name="BillTitle",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("title", models.TextField()),
                ("note", models.TextField(blank=True)),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="other_titles",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billtitle"},
        ),
        migrations.CreateModel(
            name="BillSponsorship",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=2000)),
                ("entity_type", models.CharField(blank=True, max_length=20)),
                ("primary", models.BooleanField(default=False)),
                ("classification", models.CharField(max_length=100)),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sponsorships",
                        to="data.Bill",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Organization",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billsponsorship"},
        ),
        migrations.CreateModel(
            name="BillSource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        help_text="A short, optional note related to an object.",
                        max_length=300,
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="A hyperlink related to an object.", max_length=2000
                    ),
                ),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sources",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billsource"},
        ),
        migrations.CreateModel(
            name="BillIdentifier",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "identifier",
                    models.CharField(
                        help_text="A unique identifier developed by an upstream or third party source.",
                        max_length=300,
                    ),
                ),
                (
                    "scheme",
                    models.CharField(
                        help_text="The name of the service that created the identifier.",
                        max_length=300,
                    ),
                ),
                ("note", models.TextField(blank=True)),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="other_identifiers",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billidentifier"},
        ),
        migrations.CreateModel(
            name="BillDocumentLink",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("media_type", models.CharField(max_length=100)),
                ("url", models.URLField(max_length=2000)),
                ("text", models.TextField(blank=True, default="")),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links",
                        to="data.BillDocument",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billdocumentlink"},
        ),
        migrations.CreateModel(
            name="BillActionRelatedEntity",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=2000)),
                ("entity_type", models.CharField(blank=True, max_length=20)),
                (
                    "action",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="related_entities",
                        to="data.BillAction",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Organization",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="data.Person",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billactionrelatedentity"},
        ),
        migrations.AddField(
            model_name="billaction",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="actions",
                to="data.Organization",
            ),
        ),
        migrations.CreateModel(
            name="BillAbstract",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("abstract", models.TextField()),
                ("note", models.TextField(blank=True)),
                ("date", models.TextField(blank=True, max_length=10)),
                (
                    "bill",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="abstracts",
                        to="data.Bill",
                    ),
                ),
            ],
            options={"db_table": "opencivicdata_billabstract"},
        ),
        migrations.AddField(
            model_name="bill",
            name="from_organization",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="bills",
                to="data.Organization",
            ),
        ),
        migrations.AddField(
            model_name="bill",
            name="legislative_session",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="bills",
                to="data.LegislativeSession",
            ),
        ),
        migrations.AddIndex(
            model_name="searchablebill",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["search_vector"], name="search_index"
            ),
        ),
        migrations.AlterIndexTogether(
            name="post", index_together={("organization", "label")}
        ),
        migrations.AlterIndexTogether(
            name="organization",
            index_together={
                ("classification", "name"),
                ("jurisdiction", "classification", "name"),
            },
        ),
        migrations.AlterIndexTogether(
            name="membership",
            index_together={("organization", "person", "label", "post")},
        ),
        migrations.AlterIndexTogether(
            name="event", index_together={("jurisdiction", "start_date", "name")}
        ),
        migrations.AlterIndexTogether(
            name="bill",
            index_together={("from_organization", "legislative_session", "identifier")},
        ),
    ]
