"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrModifyInstanceFleetByName = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 *
 */
class EmrModifyInstanceFleetByName extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceFleetByNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EmrModifyInstanceFleetByName);
            }
            throw error;
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: [
                    'elasticmapreduce:ModifyInstanceFleet',
                    'elasticmapreduce:ListInstanceFleets',
                ],
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'elasticmapreduce',
                        resource: 'cluster',
                        resourceName: '*',
                    }),
                ],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('elasticmapreduce', 'modifyInstanceFleetByName', sfn.IntegrationPattern.REQUEST_RESPONSE),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterId: this.props.clusterId,
                InstanceFleetName: this.props.instanceFleetName,
                InstanceFleet: {
                    TargetOnDemandCapacity: this.props.targetOnDemandCapacity,
                    TargetSpotCapacity: this.props.targetSpotCapacity,
                },
            }),
        };
    }
}
exports.EmrModifyInstanceFleetByName = EmrModifyInstanceFleetByName;
_a = JSII_RTTI_SYMBOL_1;
EmrModifyInstanceFleetByName[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceFleetByName", version: "1.198.1" };
//# sourceMappingURL=data:application/json;base64,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