# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ThreeFieldAppArgs', 'ThreeFieldApp']

@pulumi.input_type
class ThreeFieldAppArgs:
    def __init__(__self__, *,
                 button_selector: pulumi.Input[str],
                 extra_field_selector: pulumi.Input[str],
                 extra_field_value: pulumi.Input[str],
                 label: pulumi.Input[str],
                 password_selector: pulumi.Input[str],
                 url: pulumi.Input[str],
                 username_selector: pulumi.Input[str],
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 reveal_password: Optional[pulumi.Input[bool]] = None,
                 shared_password: Optional[pulumi.Input[str]] = None,
                 shared_username: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 url_regex: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]]] = None):
        """
        The set of arguments for constructing a ThreeFieldApp resource.
        :param pulumi.Input[str] button_selector: Login button field CSS selector
        :param pulumi.Input[str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[str] extra_field_value: Value for extra form field
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] password_selector: Login password field CSS selector
        :param pulumi.Input[str] url: Login URL
        :param pulumi.Input[str] username_selector: Login username field CSS selector
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] credentials_scheme: Application credentials scheme
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[bool] reveal_password: Allow user to reveal password
        :param pulumi.Input[str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]] users: Users associated with the application
        """
        pulumi.set(__self__, "button_selector", button_selector)
        pulumi.set(__self__, "extra_field_selector", extra_field_selector)
        pulumi.set(__self__, "extra_field_value", extra_field_value)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "password_selector", password_selector)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username_selector", username_selector)
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if credentials_scheme is not None:
            pulumi.set(__self__, "credentials_scheme", credentials_scheme)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if groups is not None:
            warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if reveal_password is not None:
            pulumi.set(__self__, "reveal_password", reveal_password)
        if shared_password is not None:
            pulumi.set(__self__, "shared_password", shared_password)
        if shared_username is not None:
            pulumi.set(__self__, "shared_username", shared_username)
        if skip_groups is not None:
            pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if users is not None:
            warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="buttonSelector")
    def button_selector(self) -> pulumi.Input[str]:
        """
        Login button field CSS selector
        """
        return pulumi.get(self, "button_selector")

    @button_selector.setter
    def button_selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_selector", value)

    @property
    @pulumi.getter(name="extraFieldSelector")
    def extra_field_selector(self) -> pulumi.Input[str]:
        """
        Extra field CSS selector
        """
        return pulumi.get(self, "extra_field_selector")

    @extra_field_selector.setter
    def extra_field_selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "extra_field_selector", value)

    @property
    @pulumi.getter(name="extraFieldValue")
    def extra_field_value(self) -> pulumi.Input[str]:
        """
        Value for extra form field
        """
        return pulumi.get(self, "extra_field_value")

    @extra_field_value.setter
    def extra_field_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "extra_field_value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="passwordSelector")
    def password_selector(self) -> pulumi.Input[str]:
        """
        Login password field CSS selector
        """
        return pulumi.get(self, "password_selector")

    @password_selector.setter
    def password_selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "password_selector", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="usernameSelector")
    def username_selector(self) -> pulumi.Input[str]:
        """
        Login username field CSS selector
        """
        return pulumi.get(self, "username_selector")

    @username_selector.setter
    def username_selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "username_selector", value)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_note", value)

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[str]]:
        """
        Displays specific appLinks for the app
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_links_json", value)

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Application credentials scheme
        """
        return pulumi.get(self, "credentials_scheme")

    @credentials_scheme.setter
    def credentials_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_scheme", value)

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enduser_note", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ios", value)

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_web", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Local path to logo of the application.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow user to reveal password
        """
        return pulumi.get(self, "reveal_password")

    @reveal_password.setter
    def reveal_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reveal_password", value)

    @property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> Optional[pulumi.Input[str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @shared_password.setter
    def shared_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_password", value)

    @property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> Optional[pulumi.Input[str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @shared_username.setter
    def shared_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_username", value)

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @skip_groups.setter
    def skip_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_groups", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regex that further restricts URL to the specified regex
        """
        return pulumi.get(self, "url_regex")

    @url_regex.setter
    def url_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_regex", value)

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template", value)

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[str]]:
        """
        Push username on update
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _ThreeFieldAppState:
    def __init__(__self__, *,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 button_selector: Optional[pulumi.Input[str]] = None,
                 credentials_scheme: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 extra_field_selector: Optional[pulumi.Input[str]] = None,
                 extra_field_value: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_selector: Optional[pulumi.Input[str]] = None,
                 reveal_password: Optional[pulumi.Input[bool]] = None,
                 shared_password: Optional[pulumi.Input[str]] = None,
                 shared_username: Optional[pulumi.Input[str]] = None,
                 sign_on_mode: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 url_regex: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 username_selector: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering ThreeFieldApp resources.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] button_selector: Login button field CSS selector
        :param pulumi.Input[str] credentials_scheme: Application credentials scheme
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[str] extra_field_value: Value for extra form field
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] logo_url: URL of the application's logo
        :param pulumi.Input[str] name: Name of the app.
        :param pulumi.Input[str] password_selector: Login password field CSS selector
        :param pulumi.Input[bool] reveal_password: Allow user to reveal password
        :param pulumi.Input[str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] url: Login URL
        :param pulumi.Input[str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[str] username_selector: Login username field CSS selector
        :param pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]] users: Users associated with the application
        """
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if button_selector is not None:
            pulumi.set(__self__, "button_selector", button_selector)
        if credentials_scheme is not None:
            pulumi.set(__self__, "credentials_scheme", credentials_scheme)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if extra_field_selector is not None:
            pulumi.set(__self__, "extra_field_selector", extra_field_selector)
        if extra_field_value is not None:
            pulumi.set(__self__, "extra_field_value", extra_field_value)
        if groups is not None:
            warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_selector is not None:
            pulumi.set(__self__, "password_selector", password_selector)
        if reveal_password is not None:
            pulumi.set(__self__, "reveal_password", reveal_password)
        if shared_password is not None:
            pulumi.set(__self__, "shared_password", shared_password)
        if shared_username is not None:
            pulumi.set(__self__, "shared_username", shared_username)
        if sign_on_mode is not None:
            pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        if skip_groups is not None:
            pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if username_selector is not None:
            pulumi.set(__self__, "username_selector", username_selector)
        if users is not None:
            warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_note", value)

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[str]]:
        """
        Displays specific appLinks for the app
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_links_json", value)

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @property
    @pulumi.getter(name="buttonSelector")
    def button_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Login button field CSS selector
        """
        return pulumi.get(self, "button_selector")

    @button_selector.setter
    def button_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_selector", value)

    @property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Application credentials scheme
        """
        return pulumi.get(self, "credentials_scheme")

    @credentials_scheme.setter
    def credentials_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_scheme", value)

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enduser_note", value)

    @property
    @pulumi.getter(name="extraFieldSelector")
    def extra_field_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Extra field CSS selector
        """
        return pulumi.get(self, "extra_field_selector")

    @extra_field_selector.setter
    def extra_field_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extra_field_selector", value)

    @property
    @pulumi.getter(name="extraFieldValue")
    def extra_field_value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for extra form field
        """
        return pulumi.get(self, "extra_field_value")

    @extra_field_value.setter
    def extra_field_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extra_field_value", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ios", value)

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_web", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Local path to logo of the application.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordSelector")
    def password_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Login password field CSS selector
        """
        return pulumi.get(self, "password_selector")

    @password_selector.setter
    def password_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_selector", value)

    @property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow user to reveal password
        """
        return pulumi.get(self, "reveal_password")

    @reveal_password.setter
    def reveal_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reveal_password", value)

    @property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> Optional[pulumi.Input[str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @shared_password.setter
    def shared_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_password", value)

    @property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> Optional[pulumi.Input[str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @shared_username.setter
    def shared_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_username", value)

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @sign_on_mode.setter
    def sign_on_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sign_on_mode", value)

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @skip_groups.setter
    def skip_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_groups", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regex that further restricts URL to the specified regex
        """
        return pulumi.get(self, "url_regex")

    @url_regex.setter
    def url_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_regex", value)

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template", value)

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[str]]:
        """
        Push username on update
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_type", value)

    @property
    @pulumi.getter(name="usernameSelector")
    def username_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Login username field CSS selector
        """
        return pulumi.get(self, "username_selector")

    @username_selector.setter
    def username_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_selector", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreeFieldAppUserArgs']]]]):
        pulumi.set(self, "users", value)


class ThreeFieldApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 button_selector: Optional[pulumi.Input[str]] = None,
                 credentials_scheme: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 extra_field_selector: Optional[pulumi.Input[str]] = None,
                 extra_field_value: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 password_selector: Optional[pulumi.Input[str]] = None,
                 reveal_password: Optional[pulumi.Input[bool]] = None,
                 shared_password: Optional[pulumi.Input[str]] = None,
                 shared_username: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 url_regex: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 username_selector: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThreeFieldAppUserArgs']]]]] = None,
                 __props__=None):
        """
        Create a ThreeFieldApp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] button_selector: Login button field CSS selector
        :param pulumi.Input[str] credentials_scheme: Application credentials scheme
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[str] extra_field_value: Value for extra form field
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] password_selector: Login password field CSS selector
        :param pulumi.Input[bool] reveal_password: Allow user to reveal password
        :param pulumi.Input[str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] url: Login URL
        :param pulumi.Input[str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[str] username_selector: Login username field CSS selector
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThreeFieldAppUserArgs']]]] users: Users associated with the application
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThreeFieldAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ThreeFieldApp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ThreeFieldAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThreeFieldAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 button_selector: Optional[pulumi.Input[str]] = None,
                 credentials_scheme: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 extra_field_selector: Optional[pulumi.Input[str]] = None,
                 extra_field_value: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 password_selector: Optional[pulumi.Input[str]] = None,
                 reveal_password: Optional[pulumi.Input[bool]] = None,
                 shared_password: Optional[pulumi.Input[str]] = None,
                 shared_username: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 url_regex: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 username_selector: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThreeFieldAppUserArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThreeFieldAppArgs.__new__(ThreeFieldAppArgs)

            __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
            __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
            __props__.__dict__["accessibility_self_service"] = accessibility_self_service
            __props__.__dict__["admin_note"] = admin_note
            __props__.__dict__["app_links_json"] = app_links_json
            __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
            if button_selector is None and not opts.urn:
                raise TypeError("Missing required property 'button_selector'")
            __props__.__dict__["button_selector"] = button_selector
            __props__.__dict__["credentials_scheme"] = credentials_scheme
            __props__.__dict__["enduser_note"] = enduser_note
            if extra_field_selector is None and not opts.urn:
                raise TypeError("Missing required property 'extra_field_selector'")
            __props__.__dict__["extra_field_selector"] = extra_field_selector
            if extra_field_value is None and not opts.urn:
                raise TypeError("Missing required property 'extra_field_value'")
            __props__.__dict__["extra_field_value"] = extra_field_value
            if groups is not None and not opts.urn:
                warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
            __props__.__dict__["groups"] = groups
            __props__.__dict__["hide_ios"] = hide_ios
            __props__.__dict__["hide_web"] = hide_web
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["logo"] = logo
            if password_selector is None and not opts.urn:
                raise TypeError("Missing required property 'password_selector'")
            __props__.__dict__["password_selector"] = password_selector
            __props__.__dict__["reveal_password"] = reveal_password
            __props__.__dict__["shared_password"] = shared_password
            __props__.__dict__["shared_username"] = shared_username
            __props__.__dict__["skip_groups"] = skip_groups
            __props__.__dict__["skip_users"] = skip_users
            __props__.__dict__["status"] = status
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["url_regex"] = url_regex
            __props__.__dict__["user_name_template"] = user_name_template
            __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
            __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
            __props__.__dict__["user_name_template_type"] = user_name_template_type
            if username_selector is None and not opts.urn:
                raise TypeError("Missing required property 'username_selector'")
            __props__.__dict__["username_selector"] = username_selector
            if users is not None and not opts.urn:
                warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
            __props__.__dict__["users"] = users
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sign_on_mode"] = None
        super(ThreeFieldApp, __self__).__init__(
            'okta:deprecated/threeFieldApp:ThreeFieldApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_self_service: Optional[pulumi.Input[bool]] = None,
            admin_note: Optional[pulumi.Input[str]] = None,
            app_links_json: Optional[pulumi.Input[str]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
            button_selector: Optional[pulumi.Input[str]] = None,
            credentials_scheme: Optional[pulumi.Input[str]] = None,
            enduser_note: Optional[pulumi.Input[str]] = None,
            extra_field_selector: Optional[pulumi.Input[str]] = None,
            extra_field_value: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hide_ios: Optional[pulumi.Input[bool]] = None,
            hide_web: Optional[pulumi.Input[bool]] = None,
            label: Optional[pulumi.Input[str]] = None,
            logo: Optional[pulumi.Input[str]] = None,
            logo_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password_selector: Optional[pulumi.Input[str]] = None,
            reveal_password: Optional[pulumi.Input[bool]] = None,
            shared_password: Optional[pulumi.Input[str]] = None,
            shared_username: Optional[pulumi.Input[str]] = None,
            sign_on_mode: Optional[pulumi.Input[str]] = None,
            skip_groups: Optional[pulumi.Input[bool]] = None,
            skip_users: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            url_regex: Optional[pulumi.Input[str]] = None,
            user_name_template: Optional[pulumi.Input[str]] = None,
            user_name_template_push_status: Optional[pulumi.Input[str]] = None,
            user_name_template_suffix: Optional[pulumi.Input[str]] = None,
            user_name_template_type: Optional[pulumi.Input[str]] = None,
            username_selector: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThreeFieldAppUserArgs']]]]] = None) -> 'ThreeFieldApp':
        """
        Get an existing ThreeFieldApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[bool] accessibility_self_service: Enable self service
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[str] button_selector: Login button field CSS selector
        :param pulumi.Input[str] credentials_scheme: Application credentials scheme
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[str] extra_field_value: Value for extra form field
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[bool] hide_web: Do not display application icon to users
        :param pulumi.Input[str] label: Pretty name of app.
        :param pulumi.Input[str] logo: Local path to logo of the application.
        :param pulumi.Input[str] logo_url: URL of the application's logo
        :param pulumi.Input[str] name: Name of the app.
        :param pulumi.Input[str] password_selector: Login password field CSS selector
        :param pulumi.Input[bool] reveal_password: Allow user to reveal password
        :param pulumi.Input[str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[bool] skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        :param pulumi.Input[bool] skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        :param pulumi.Input[str] status: Status of application.
        :param pulumi.Input[str] url: Login URL
        :param pulumi.Input[str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[str] user_name_template: Username template
        :param pulumi.Input[str] user_name_template_push_status: Push username on update
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[str] user_name_template_type: Username template type
        :param pulumi.Input[str] username_selector: Login username field CSS selector
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThreeFieldAppUserArgs']]]] users: Users associated with the application
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThreeFieldAppState.__new__(_ThreeFieldAppState)

        __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__.__dict__["accessibility_self_service"] = accessibility_self_service
        __props__.__dict__["admin_note"] = admin_note
        __props__.__dict__["app_links_json"] = app_links_json
        __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__.__dict__["button_selector"] = button_selector
        __props__.__dict__["credentials_scheme"] = credentials_scheme
        __props__.__dict__["enduser_note"] = enduser_note
        __props__.__dict__["extra_field_selector"] = extra_field_selector
        __props__.__dict__["extra_field_value"] = extra_field_value
        __props__.__dict__["groups"] = groups
        __props__.__dict__["hide_ios"] = hide_ios
        __props__.__dict__["hide_web"] = hide_web
        __props__.__dict__["label"] = label
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["password_selector"] = password_selector
        __props__.__dict__["reveal_password"] = reveal_password
        __props__.__dict__["shared_password"] = shared_password
        __props__.__dict__["shared_username"] = shared_username
        __props__.__dict__["sign_on_mode"] = sign_on_mode
        __props__.__dict__["skip_groups"] = skip_groups
        __props__.__dict__["skip_users"] = skip_users
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        __props__.__dict__["url_regex"] = url_regex
        __props__.__dict__["user_name_template"] = user_name_template
        __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
        __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
        __props__.__dict__["user_name_template_type"] = user_name_template_type
        __props__.__dict__["username_selector"] = username_selector
        __props__.__dict__["users"] = users
        return ThreeFieldApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable self service
        """
        return pulumi.get(self, "accessibility_self_service")

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> pulumi.Output[Optional[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> pulumi.Output[Optional[str]]:
        """
        Displays specific appLinks for the app
        """
        return pulumi.get(self, "app_links_json")

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @property
    @pulumi.getter(name="buttonSelector")
    def button_selector(self) -> pulumi.Output[str]:
        """
        Login button field CSS selector
        """
        return pulumi.get(self, "button_selector")

    @property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        Application credentials scheme
        """
        return pulumi.get(self, "credentials_scheme")

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> pulumi.Output[Optional[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @property
    @pulumi.getter(name="extraFieldSelector")
    def extra_field_selector(self) -> pulumi.Output[str]:
        """
        Extra field CSS selector
        """
        return pulumi.get(self, "extra_field_selector")

    @property
    @pulumi.getter(name="extraFieldValue")
    def extra_field_value(self) -> pulumi.Output[str]:
        """
        Value for extra form field
        """
        return pulumi.get(self, "extra_field_value")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Pretty name of app.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[str]]:
        """
        Local path to logo of the application.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[str]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordSelector")
    def password_selector(self) -> pulumi.Output[str]:
        """
        Login password field CSS selector
        """
        return pulumi.get(self, "password_selector")

    @property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow user to reveal password
        """
        return pulumi.get(self, "reveal_password")

    @property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> pulumi.Output[Optional[str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> pulumi.Output[Optional[str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> pulumi.Output[Optional[str]]:
        """
        A regex that further restricts URL to the specified regex
        """
        return pulumi.get(self, "url_regex")

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[Optional[str]]:
        """
        Username template
        """
        return pulumi.get(self, "user_name_template")

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> pulumi.Output[Optional[str]]:
        """
        Push username on update
        """
        return pulumi.get(self, "user_name_template_push_status")

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[Optional[str]]:
        """
        Username template type
        """
        return pulumi.get(self, "user_name_template_type")

    @property
    @pulumi.getter(name="usernameSelector")
    def username_selector(self) -> pulumi.Output[str]:
        """
        Login username field CSS selector
        """
        return pulumi.get(self, "username_selector")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.ThreeFieldAppUser']]]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")

