# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetNetworkZoneResult',
    'AwaitableGetNetworkZoneResult',
    'get_network_zone',
    'get_network_zone_output',
]

@pulumi.output_type
class GetNetworkZoneResult:
    """
    A collection of values returned by getNetworkZone.
    """
    def __init__(__self__, asns=None, dynamic_locations=None, dynamic_proxy_type=None, gateways=None, id=None, name=None, proxies=None, type=None, usage=None):
        if asns and not isinstance(asns, list):
            raise TypeError("Expected argument 'asns' to be a list")
        pulumi.set(__self__, "asns", asns)
        if dynamic_locations and not isinstance(dynamic_locations, list):
            raise TypeError("Expected argument 'dynamic_locations' to be a list")
        pulumi.set(__self__, "dynamic_locations", dynamic_locations)
        if dynamic_proxy_type and not isinstance(dynamic_proxy_type, str):
            raise TypeError("Expected argument 'dynamic_proxy_type' to be a str")
        pulumi.set(__self__, "dynamic_proxy_type", dynamic_proxy_type)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if proxies and not isinstance(proxies, list):
            raise TypeError("Expected argument 'proxies' to be a list")
        pulumi.set(__self__, "proxies", proxies)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def asns(self) -> Sequence[str]:
        """
        Array of Autonomous System Numbers.
        """
        return pulumi.get(self, "asns")

    @property
    @pulumi.getter(name="dynamicLocations")
    def dynamic_locations(self) -> Sequence[str]:
        """
        Array of locations.
        """
        return pulumi.get(self, "dynamic_locations")

    @property
    @pulumi.getter(name="dynamicProxyType")
    def dynamic_proxy_type(self) -> str:
        """
        Type of proxy being controlled by this dynamic network zone.
        """
        return pulumi.get(self, "dynamic_proxy_type")

    @property
    @pulumi.getter
    def gateways(self) -> Sequence[str]:
        """
        Array of values in CIDR/range form.
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the network zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the network zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def proxies(self) -> Sequence[str]:
        """
        Array of values in CIDR/range form.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Network Zone.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        Usage of the Network Zone.
        """
        return pulumi.get(self, "usage")


class AwaitableGetNetworkZoneResult(GetNetworkZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkZoneResult(
            asns=self.asns,
            dynamic_locations=self.dynamic_locations,
            dynamic_proxy_type=self.dynamic_proxy_type,
            gateways=self.gateways,
            id=self.id,
            name=self.name,
            proxies=self.proxies,
            type=self.type,
            usage=self.usage)


def get_network_zone(id: Optional[str] = None,
                     name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkZoneResult:
    """
    Use this data source to retrieve a network zone from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_network_zone(name="Block Antarctica")
    ```


    :param str id: ID of the network zone to retrieve, conflicts with `name`.
    :param str name: Name of the network zone to retrieve, conflicts with `id`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:index/getNetworkZone:getNetworkZone', __args__, opts=opts, typ=GetNetworkZoneResult).value

    return AwaitableGetNetworkZoneResult(
        asns=__ret__.asns,
        dynamic_locations=__ret__.dynamic_locations,
        dynamic_proxy_type=__ret__.dynamic_proxy_type,
        gateways=__ret__.gateways,
        id=__ret__.id,
        name=__ret__.name,
        proxies=__ret__.proxies,
        type=__ret__.type,
        usage=__ret__.usage)


@_utilities.lift_output_func(get_network_zone)
def get_network_zone_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkZoneResult]:
    """
    Use this data source to retrieve a network zone from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_network_zone(name="Block Antarctica")
    ```


    :param str id: ID of the network zone to retrieve, conflicts with `name`.
    :param str name: Name of the network zone to retrieve, conflicts with `id`.
    """
    ...
