"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Marketplacecommerceanalytics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [marketplacecommerceanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacecommerceanalyticsservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Marketplacecommerceanalytics extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [marketplacecommerceanalytics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacecommerceanalyticsservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'marketplacecommerceanalytics';
        this.accessLevelList = {
            Write: [
                'GenerateDataSet',
                'StartSupportDataExport'
            ]
        };
    }
    /**
     * Request a data set to be published to your Amazon S3 bucket.
     *
     * Access Level: Write
     */
    toGenerateDataSet() {
        return this.to('GenerateDataSet');
    }
    /**
     * Request a support data set to be published to your Amazon S3 bucket.
     *
     * Access Level: Write
     */
    toStartSupportDataExport() {
        return this.to('StartSupportDataExport');
    }
}
exports.Marketplacecommerceanalytics = Marketplacecommerceanalytics;
_a = JSII_RTTI_SYMBOL_1;
Marketplacecommerceanalytics[_a] = { fqn: "iam-floyd.Marketplacecommerceanalytics", version: "0.322.0" };
//# sourceMappingURL=data:application/json;base64,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