"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplacePrivate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplacePrivate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'AssociateProductsWithPrivateMarketplace',
                'CreatePrivateMarketplaceRequests',
                'DisassociateProductsFromPrivateMarketplace'
            ],
            List: [
                'DescribePrivateMarketplaceRequests',
                'ListPrivateMarketplaceRequests'
            ]
        };
    }
    /**
     * Grants permission to add new approved products to the Private Marketplace. Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toAssociateProductsWithPrivateMarketplace() {
        return this.to('AssociateProductsWithPrivateMarketplace');
    }
    /**
     * Grants permission to create a new request for a product or products to be associated with the Private Marketplace. This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toCreatePrivateMarketplaceRequests() {
        return this.to('CreatePrivateMarketplaceRequests');
    }
    /**
     * Grants permission to describe requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceRequests() {
        return this.to('DescribePrivateMarketplaceRequests');
    }
    /**
     * Grants permission to remove approved products from the Private Marketplace. Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDisassociateProductsFromPrivateMarketplace() {
        return this.to('DisassociateProductsFromPrivateMarketplace');
    }
    /**
     * Grants permission to get a queryable list for requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toListPrivateMarketplaceRequests() {
        return this.to('ListPrivateMarketplaceRequests');
    }
}
exports.AwsMarketplacePrivate = AwsMarketplacePrivate;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplacePrivate[_a] = { fqn: "iam-floyd.AwsMarketplacePrivate", version: "0.322.0" };
//# sourceMappingURL=data:application/json;base64,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