"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mobiletargeting = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [mobiletargeting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpoint.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mobiletargeting extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mobiletargeting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpoint.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'mobiletargeting';
        this.accessLevelList = {
            Write: [
                'CreateApp',
                'CreateCampaign',
                'CreateEmailTemplate',
                'CreateExportJob',
                'CreateImportJob',
                'CreateInAppTemplate',
                'CreateJourney',
                'CreatePushTemplate',
                'CreateRecommenderConfiguration',
                'CreateSegment',
                'CreateSmsTemplate',
                'CreateVoiceTemplate',
                'DeleteAdmChannel',
                'DeleteApnsChannel',
                'DeleteApnsSandboxChannel',
                'DeleteApnsVoipChannel',
                'DeleteApnsVoipSandboxChannel',
                'DeleteApp',
                'DeleteBaiduChannel',
                'DeleteCampaign',
                'DeleteEmailChannel',
                'DeleteEmailTemplate',
                'DeleteEndpoint',
                'DeleteEventStream',
                'DeleteGcmChannel',
                'DeleteInAppTemplate',
                'DeleteJourney',
                'DeletePushTemplate',
                'DeleteRecommenderConfiguration',
                'DeleteSegment',
                'DeleteSmsChannel',
                'DeleteSmsTemplate',
                'DeleteUserEndpoints',
                'DeleteVoiceChannel',
                'DeleteVoiceTemplate',
                'PutEventStream',
                'PutEvents',
                'RemoveAttributes',
                'SendMessages',
                'SendUsersMessages',
                'UpdateAdmChannel',
                'UpdateApnsChannel',
                'UpdateApnsSandboxChannel',
                'UpdateApnsVoipChannel',
                'UpdateApnsVoipSandboxChannel',
                'UpdateApplicationSettings',
                'UpdateBaiduChannel',
                'UpdateCampaign',
                'UpdateEmailChannel',
                'UpdateEmailTemplate',
                'UpdateEndpoint',
                'UpdateEndpointsBatch',
                'UpdateGcmChannel',
                'UpdateInAppTemplate',
                'UpdateJourney',
                'UpdateJourneyState',
                'UpdatePushTemplate',
                'UpdateRecommenderConfiguration',
                'UpdateSegment',
                'UpdateSmsChannel',
                'UpdateSmsTemplate',
                'UpdateTemplateActiveVersion',
                'UpdateVoiceChannel',
                'UpdateVoiceTemplate'
            ],
            Read: [
                'GetAdmChannel',
                'GetApnsChannel',
                'GetApnsSandboxChannel',
                'GetApnsVoipChannel',
                'GetApnsVoipSandboxChannel',
                'GetApp',
                'GetApplicationDateRangeKpi',
                'GetApps',
                'GetBaiduChannel',
                'GetCampaign',
                'GetCampaignDateRangeKpi',
                'GetCampaignVersion',
                'GetEmailChannel',
                'GetEmailTemplate',
                'GetEndpoint',
                'GetEventStream',
                'GetExportJob',
                'GetGcmChannel',
                'GetImportJob',
                'GetInAppMessages',
                'GetInAppTemplate',
                'GetJourney',
                'GetJourneyDateRangeKpi',
                'GetJourneyExecutionActivityMetrics',
                'GetJourneyExecutionMetrics',
                'GetPushTemplate',
                'GetRecommenderConfiguration',
                'GetReports',
                'GetSegment',
                'GetSegmentVersion',
                'GetSmsChannel',
                'GetSmsTemplate',
                'GetUserEndpoints',
                'GetVoiceChannel',
                'GetVoiceTemplate',
                'ListTagsForResource',
                'PhoneNumberValidate',
                'VerifyOTPMessage'
            ],
            List: [
                'GetApplicationSettings',
                'GetCampaignActivities',
                'GetCampaignVersions',
                'GetCampaigns',
                'GetChannels',
                'GetExportJobs',
                'GetImportJobs',
                'GetRecommenderConfigurations',
                'GetSegmentExportJobs',
                'GetSegmentImportJobs',
                'GetSegmentVersions',
                'GetSegments',
                'ListJourneys',
                'ListTemplateVersions',
                'ListTemplates'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an app
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Grants permission to create a campaign for an app
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaigns.html#rest-api-campaigns-methods
     */
    toCreateCampaign() {
        return this.to('CreateCampaign');
    }
    /**
     * Grants permission to create an email template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     */
    toCreateEmailTemplate() {
        return this.to('CreateEmailTemplate');
    }
    /**
     * Grants permission to create an export job that exports endpoint definitions to Amazon S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     */
    toCreateExportJob() {
        return this.to('CreateExportJob');
    }
    /**
     * Grants permission to import endpoint definitions from to create a segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-jobs.html#rest-api-import-jobs-methods
     */
    toCreateImportJob() {
        return this.to('CreateImportJob');
    }
    /**
     * Grants permission to create an in-app message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#templates-template-name-inapp-http-methods
     */
    toCreateInAppTemplate() {
        return this.to('CreateInAppTemplate');
    }
    /**
     * Grants permission to create a Journey for an app
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     */
    toCreateJourney() {
        return this.to('CreateJourney');
    }
    /**
     * Grants permission to create a push notification template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     */
    toCreatePushTemplate() {
        return this.to('CreatePushTemplate');
    }
    /**
     * Grants permission to create an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html#CreateRecommenderConfiguration
     */
    toCreateRecommenderConfiguration() {
        return this.to('CreateRecommenderConfiguration');
    }
    /**
     * Grants permission to create a segment that is based on endpoint data reported to Pinpoint by your app. To allow a user to create a segment by importing endpoint data from outside of Pinpoint, allow the mobiletargeting:CreateImportJob action
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segments.html#rest-api-segments-methods
     */
    toCreateSegment() {
        return this.to('CreateSegment');
    }
    /**
     * Grants permission to create an sms message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     */
    toCreateSmsTemplate() {
        return this.to('CreateSmsTemplate');
    }
    /**
     * Grants permission to create a voice message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     */
    toCreateVoiceTemplate() {
        return this.to('CreateVoiceTemplate');
    }
    /**
     * Grants permission to delete the ADM channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-adm-channel.html#rest-api-adm-channel-methods
     */
    toDeleteAdmChannel() {
        return this.to('DeleteAdmChannel');
    }
    /**
     * Grants permission to delete the APNs channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-channel.html#rest-api-apns-channel-methods
     */
    toDeleteApnsChannel() {
        return this.to('DeleteApnsChannel');
    }
    /**
     * Grants permission to delete the APNs sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-sandbox-channel.html#rest-api-apns-sandbox-channel-methods
     */
    toDeleteApnsSandboxChannel() {
        return this.to('DeleteApnsSandboxChannel');
    }
    /**
     * Grants permission to delete the APNs VoIP channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-channel.html#rest-api-apns-voip-channel-methods
     */
    toDeleteApnsVoipChannel() {
        return this.to('DeleteApnsVoipChannel');
    }
    /**
     * Grants permission to delete the APNs VoIP sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-sandbox-channel.html#rest-api-apns-voip-sandbox-channel-methods
     */
    toDeleteApnsVoipSandboxChannel() {
        return this.to('DeleteApnsVoipSandboxChannel');
    }
    /**
     * Grants permission to delete a specific campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Grants permission to delete the Baidu channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-baidu-channel.html#rest-api-baidu-channel-methods
     */
    toDeleteBaiduChannel() {
        return this.to('DeleteBaiduChannel');
    }
    /**
     * Grants permission to delete a specific campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign.html#rest-api-campaign-methods
     */
    toDeleteCampaign() {
        return this.to('DeleteCampaign');
    }
    /**
     * Grants permission to delete the email channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-email-channel.html#rest-api-email-channel-methods
     */
    toDeleteEmailChannel() {
        return this.to('DeleteEmailChannel');
    }
    /**
     * Grants permission to delete an email template or an email template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     */
    toDeleteEmailTemplate() {
        return this.to('DeleteEmailTemplate');
    }
    /**
     * Grants permission to delete an endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoint.html#rest-api-endpoint-methods
     */
    toDeleteEndpoint() {
        return this.to('DeleteEndpoint');
    }
    /**
     * Grants permission to delete the event stream for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-event-stream.html#rest-api-event-stream-methods
     */
    toDeleteEventStream() {
        return this.to('DeleteEventStream');
    }
    /**
     * Grants permission to delete the GCM channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-gcm-channel.html#rest-api-gcm-channel-methods
     */
    toDeleteGcmChannel() {
        return this.to('DeleteGcmChannel');
    }
    /**
     * Grants permission to delete an in-app message template or an in-app message template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#templates-template-name-inapp-http-methods
     */
    toDeleteInAppTemplate() {
        return this.to('DeleteInAppTemplate');
    }
    /**
     * Grants permission to delete a specific journey
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     */
    toDeleteJourney() {
        return this.to('DeleteJourney');
    }
    /**
     * Grants permission to delete a push notification template or a push notification template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     */
    toDeletePushTemplate() {
        return this.to('DeletePushTemplate');
    }
    /**
     * Grants permission to delete an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#DeleteRecommenderConfiguration
     */
    toDeleteRecommenderConfiguration() {
        return this.to('DeleteRecommenderConfiguration');
    }
    /**
     * Grants permission to delete a specific segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment.html#rest-api-segment-methods
     */
    toDeleteSegment() {
        return this.to('DeleteSegment');
    }
    /**
     * Grants permission to delete the SMS channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-sms-channel.html#rest-api-sms-channel-methods
     */
    toDeleteSmsChannel() {
        return this.to('DeleteSmsChannel');
    }
    /**
     * Grants permission to delete an sms message template or an sms message template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     */
    toDeleteSmsTemplate() {
        return this.to('DeleteSmsTemplate');
    }
    /**
     * Grants permission to delete all of the endpoints that are associated with a user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-user.html#rest-api-user-methods
     */
    toDeleteUserEndpoints() {
        return this.to('DeleteUserEndpoints');
    }
    /**
     * Grants permission to delete the Voice channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-voice-channel.html#rest-api-voice-channel-methods
     */
    toDeleteVoiceChannel() {
        return this.to('DeleteVoiceChannel');
    }
    /**
     * Grants permission to delete a voice message template or a voice message template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     */
    toDeleteVoiceTemplate() {
        return this.to('DeleteVoiceTemplate');
    }
    /**
     * Grants permission to retrieve information about the Amazon Device Messaging (ADM) channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-adm-channel.html#rest-api-adm-channel-methods
     */
    toGetAdmChannel() {
        return this.to('GetAdmChannel');
    }
    /**
     * Grants permission to retrieve information about the APNs channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-channel.html#rest-api-apns-channel-methods
     */
    toGetApnsChannel() {
        return this.to('GetApnsChannel');
    }
    /**
     * Grants permission to retrieve information about the APNs sandbox channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-sandbox-channel.html#rest-api-apns-sandbox-channel-methods
     */
    toGetApnsSandboxChannel() {
        return this.to('GetApnsSandboxChannel');
    }
    /**
     * Grants permission to retrieve information about the APNs VoIP channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-channel.html#rest-api-apns-voip-channel-methods
     */
    toGetApnsVoipChannel() {
        return this.to('GetApnsVoipChannel');
    }
    /**
     * Grants permission to retrieve information about the APNs VoIP sandbox channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-sandbox-channel.html#rest-api-apns-voip-sandbox-channel-methods
     */
    toGetApnsVoipSandboxChannel() {
        return this.to('GetApnsVoipSandboxChannel');
    }
    /**
     * Grants permission to retrieve information about a specific app in your Amazon Pinpoint account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     */
    toGetApp() {
        return this.to('GetApp');
    }
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard metric that applies to an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-kpis-daterange-kpi-name.html#GetApplicationDateRangeKpi
     */
    toGetApplicationDateRangeKpi() {
        return this.to('GetApplicationDateRangeKpi');
    }
    /**
     * Grants permission to retrieve the default settings for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-settings.html#rest-api-settings-methods
     */
    toGetApplicationSettings() {
        return this.to('GetApplicationSettings');
    }
    /**
     * Grants permission to retrieve a list of apps in your Amazon Pinpoint account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apps.html#rest-api-apps-methods
     */
    toGetApps() {
        return this.to('GetApps');
    }
    /**
     * Grants permission to retrieve information about the Baidu channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-baidu-channel.html#rest-api-baidu-channel-methods
     */
    toGetBaiduChannel() {
        return this.to('GetBaiduChannel');
    }
    /**
     * Grants permission to retrieve information about a specific campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign.html#rest-api-campaign-methods
     */
    toGetCampaign() {
        return this.to('GetCampaign');
    }
    /**
     * Grants permission to retrieve information about the activities performed by a campaign
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign-activities.html#rest-api-campaign-activities-methods
     */
    toGetCampaignActivities() {
        return this.to('GetCampaignActivities');
    }
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard metric that applies to a campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-kpis-daterange-kpi-name.html#GetCampaignDateRangeKpi
     */
    toGetCampaignDateRangeKpi() {
        return this.to('GetCampaignDateRangeKpi');
    }
    /**
     * Grants permission to retrieve information about a specific campaign version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign-version.html#rest-api-campaign-version-methods
     */
    toGetCampaignVersion() {
        return this.to('GetCampaignVersion');
    }
    /**
     * Grants permission to retrieve information about the current and prior versions of a campaign
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign-versions.html#rest-api-campaign-versions-methods
     */
    toGetCampaignVersions() {
        return this.to('GetCampaignVersions');
    }
    /**
     * Grants permission to retrieve information about all campaigns for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaigns.html#rest-api-campaigns-methods
     */
    toGetCampaigns() {
        return this.to('GetCampaigns');
    }
    /**
     * Grants permission to get all channels information for your app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-channels.html#rest-api-channels-methods
     */
    toGetChannels() {
        return this.to('GetChannels');
    }
    /**
     * Grants permission to obtain information about the email channel in an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-email-channel.html#rest-api-email-channel-methods
     */
    toGetEmailChannel() {
        return this.to('GetEmailChannel');
    }
    /**
     * Grants permission to retrieve information about a specific or the active version of an email template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     */
    toGetEmailTemplate() {
        return this.to('GetEmailTemplate');
    }
    /**
     * Grants permission to retrieve information about a specific endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoint.html#rest-api-endpoint-methods
     */
    toGetEndpoint() {
        return this.to('GetEndpoint');
    }
    /**
     * Grants permission to retrieve information about the event stream for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-event-stream.html#rest-api-event-stream-methods
     */
    toGetEventStream() {
        return this.to('GetEventStream');
    }
    /**
     * Grants permission to obtain information about a specific export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     */
    toGetExportJob() {
        return this.to('GetExportJob');
    }
    /**
     * Grants permission to retrieve a list of all of the export jobs for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     */
    toGetExportJobs() {
        return this.to('GetExportJobs');
    }
    /**
     * Grants permission to retrieve information about the GCM channel for an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-gcm-channel.html#rest-api-gcm-channel-methods
     */
    toGetGcmChannel() {
        return this.to('GetGcmChannel');
    }
    /**
     * Grants permission to retrieve information about a specific import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-job.html#rest-api-import-job-methods
     */
    toGetImportJob() {
        return this.to('GetImportJob');
    }
    /**
     * Grants permission to retrieve information about all import jobs for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-jobs.html#rest-api-import-jobs-methods
     */
    toGetImportJobs() {
        return this.to('GetImportJobs');
    }
    /**
     * Grants permission to retrive in-app messages for the given endpoint id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id-inappmessages.html
     */
    toGetInAppMessages() {
        return this.to('GetInAppMessages');
    }
    /**
     * Grants permission to retrieve information about a specific or the active version of an in-app message template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#templates-template-name-inapp-http-methods
     */
    toGetInAppTemplate() {
        return this.to('GetInAppTemplate');
    }
    /**
     * Grants permission to retrieve information about a specific journey
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     */
    toGetJourney() {
        return this.to('GetJourney');
    }
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard engagement metric that applies to a journey
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-kpis-daterange-kpi-name.html#GetJourneyDateRangeKpi
     */
    toGetJourneyDateRangeKpi() {
        return this.to('GetJourneyDateRangeKpi');
    }
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey activity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-activities-journey-activity-id-execution-metrics.html#GetJourneyExecutionActivityMetrics
     */
    toGetJourneyExecutionActivityMetrics() {
        return this.to('GetJourneyExecutionActivityMetrics');
    }
    /**
     * Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-execution-metrics.html#GetJourneyExecutionMetrics
     */
    toGetJourneyExecutionMetrics() {
        return this.to('GetJourneyExecutionMetrics');
    }
    /**
     * Grants permission to retrieve information about a specific or the active version of an push notification template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     */
    toGetPushTemplate() {
        return this.to('GetPushTemplate');
    }
    /**
     * Grants permission to retrieve information about an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#GetRecommenderConfiguration
     */
    toGetRecommenderConfiguration() {
        return this.to('GetRecommenderConfiguration');
    }
    /**
     * Grants permission to retrieve information about all the recommender model configurations that are associated with an Amazon Pinpoint account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html#GetRecommenderConfigurations
     */
    toGetRecommenderConfigurations() {
        return this.to('GetRecommenderConfigurations');
    }
    /**
     * Grants permission to mobiletargeting:GetReports
     *
     * Access Level: Read
     */
    toGetReports() {
        return this.to('GetReports');
    }
    /**
     * Grants permission to retrieve information about a specific segment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment.html#rest-api-segment-methods
     */
    toGetSegment() {
        return this.to('GetSegment');
    }
    /**
     * Grants permission to retrieve information about jobs that export endpoint definitions from segments to Amazon S3
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     */
    toGetSegmentExportJobs() {
        return this.to('GetSegmentExportJobs');
    }
    /**
     * Grants permission to retrieve information about jobs that create segments by importing endpoint definitions from
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-jobs.html#rest-api-import-jobs-methods
     */
    toGetSegmentImportJobs() {
        return this.to('GetSegmentImportJobs');
    }
    /**
     * Grants permission to retrieve information about a specific segment version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment-version.html#rest-api-segment-version-methods
     */
    toGetSegmentVersion() {
        return this.to('GetSegmentVersion');
    }
    /**
     * Grants permission to retrieve information about the current and prior versions of a segment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment-versions.html#rest-api-segment-versions-methods
     */
    toGetSegmentVersions() {
        return this.to('GetSegmentVersions');
    }
    /**
     * Grants permission to retrieve information about the segments for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segments.html#rest-api-segments-methods
     */
    toGetSegments() {
        return this.to('GetSegments');
    }
    /**
     * Grants permission to obtain information about the SMS channel in an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-sms-channel.html#rest-api-sms-channel-methods
     */
    toGetSmsChannel() {
        return this.to('GetSmsChannel');
    }
    /**
     * Grants permission to retrieve information about a specific or the active version of an sms message template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     */
    toGetSmsTemplate() {
        return this.to('GetSmsTemplate');
    }
    /**
     * Grants permission to retrieve information about the endpoints that are associated with a user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-user.html#rest-api-user-methods
     */
    toGetUserEndpoints() {
        return this.to('GetUserEndpoints');
    }
    /**
     * Grants permission to obtain information about the Voice channel in an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-voice-channel.html#rest-api-voice-channel-methods
     */
    toGetVoiceChannel() {
        return this.to('GetVoiceChannel');
    }
    /**
     * Grants permission to retrieve information about a specific or the active version of a voice message template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     */
    toGetVoiceTemplate() {
        return this.to('GetVoiceTemplate');
    }
    /**
     * Grants permission to retrieve information about all journeys for an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html#apps-application-id-journeys-http-methods
     */
    toListJourneys() {
        return this.to('ListJourneys');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-tags.html#rest-api-tags-methods-get
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve all versions about a specific template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-template-type-versions.html#templates-template-name-template-type-versions-http-methods
     */
    toListTemplateVersions() {
        return this.to('ListTemplateVersions');
    }
    /**
     * Grants permission to retrieve metadata about the queried templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html#templates-http-methods
     */
    toListTemplates() {
        return this.to('ListTemplates');
    }
    /**
     * Grants permission to obtain metadata for a phone number, such as the number type (mobile, landline, or VoIP), location, and provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-phone-number-validate.html#rest-api-phone-number-validate-methods
     */
    toPhoneNumberValidate() {
        return this.to('PhoneNumberValidate');
    }
    /**
     * Grants permission to create or update an event stream for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-event-stream.html#rest-api-event-stream-methods
     */
    toPutEventStream() {
        return this.to('PutEventStream');
    }
    /**
     * Grants permission to create or update events for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-events.html#rest-api-events-methods
     */
    toPutEvents() {
        return this.to('PutEvents');
    }
    /**
     * Grants permission to remove the attributes for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     */
    toRemoveAttributes() {
        return this.to('RemoveAttributes');
    }
    /**
     * Grants permission to send an SMS message or push notification to specific endpoints
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-messages.html#rest-api-messages-methods
     */
    toSendMessages() {
        return this.to('SendMessages');
    }
    /**
     * Grants permission to send an SMS message or push notification to all endpoints that are associated with a specific user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-users-messages.html#rest-api-users-messages-methods
     */
    toSendUsersMessages() {
        return this.to('SendUsersMessages');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-tags.html#rest-api-tags-methods-post
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-tags.html#rest-api-tags-methods-delete
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the Amazon Device Messaging (ADM) channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-adm-channel.html#rest-api-adm-channel-methods
     */
    toUpdateAdmChannel() {
        return this.to('UpdateAdmChannel');
    }
    /**
     * Grants permission to update the Apple Push Notification service (APNs) channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-channel.html#rest-api-apns-channel-methods
     */
    toUpdateApnsChannel() {
        return this.to('UpdateApnsChannel');
    }
    /**
     * Grants permission to update the Apple Push Notification service (APNs) sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-sandbox-channel.html#rest-api-apns-sandbox-channel-methods
     */
    toUpdateApnsSandboxChannel() {
        return this.to('UpdateApnsSandboxChannel');
    }
    /**
     * Grants permission to update the Apple Push Notification service (APNs) VoIP channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-channel.html#rest-api-apns-voip-channel-methods
     */
    toUpdateApnsVoipChannel() {
        return this.to('UpdateApnsVoipChannel');
    }
    /**
     * Grants permission to update the Apple Push Notification service (APNs) VoIP sandbox channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-sandbox-channel.html#rest-api-apns-voip-sandbox-channel-methods
     */
    toUpdateApnsVoipSandboxChannel() {
        return this.to('UpdateApnsVoipSandboxChannel');
    }
    /**
     * Grants permission to update the default settings for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-settings.html#rest-api-settings-methods
     */
    toUpdateApplicationSettings() {
        return this.to('UpdateApplicationSettings');
    }
    /**
     * Grants permission to update the Baidu channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-baidu-channel.html#rest-api-baidu-channel-methods
     */
    toUpdateBaiduChannel() {
        return this.to('UpdateBaiduChannel');
    }
    /**
     * Grants permission to update a specific campaign
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign.html#rest-api-campaign-methods
     */
    toUpdateCampaign() {
        return this.to('UpdateCampaign');
    }
    /**
     * Grants permission to update the email channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-email-channel.html#rest-api-email-channel-methods
     */
    toUpdateEmailChannel() {
        return this.to('UpdateEmailChannel');
    }
    /**
     * Grants permission to update a specific email template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     */
    toUpdateEmailTemplate() {
        return this.to('UpdateEmailTemplate');
    }
    /**
     * Grants permission to create an endpoint or update the information for an endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoint.html#rest-api-endpoint-methods
     */
    toUpdateEndpoint() {
        return this.to('UpdateEndpoint');
    }
    /**
     * Grants permission to create or update endpoints as a batch operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoints.html#rest-api-endpoints-methods
     */
    toUpdateEndpointsBatch() {
        return this.to('UpdateEndpointsBatch');
    }
    /**
     * Grants permission to update the Firebase Cloud Messaging (FCM) or Google Cloud Messaging (GCM) API key that allows to send push notifications to your Android app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-gcm-channel.html#rest-api-gcm-channel-methods
     */
    toUpdateGcmChannel() {
        return this.to('UpdateGcmChannel');
    }
    /**
     * Grants permission to update a specific in-app message template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-inapp.html#templates-template-name-inapp-http-methods
     */
    toUpdateInAppTemplate() {
        return this.to('UpdateInAppTemplate');
    }
    /**
     * Grants permission to update a specific journey
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     */
    toUpdateJourney() {
        return this.to('UpdateJourney');
    }
    /**
     * Grants permission to update a specific journey state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-state.html#apps-application-id-journeys-journey-id-state-http-methods
     */
    toUpdateJourneyState() {
        return this.to('UpdateJourneyState');
    }
    /**
     * Grants permission to update a specific push notification template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     */
    toUpdatePushTemplate() {
        return this.to('UpdatePushTemplate');
    }
    /**
     * Grants permission to update an Amazon Pinpoint configuration for a recommender model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#UpdateRecommenderConfiguration
     */
    toUpdateRecommenderConfiguration() {
        return this.to('UpdateRecommenderConfiguration');
    }
    /**
     * Grants permission to update a specific segment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment.html#rest-api-segment-methods
     */
    toUpdateSegment() {
        return this.to('UpdateSegment');
    }
    /**
     * Grants permission to update the SMS channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-sms-channel.html#rest-api-sms-channel-methods
     */
    toUpdateSmsChannel() {
        return this.to('UpdateSmsChannel');
    }
    /**
     * Grants permission to update a specific sms message template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     */
    toUpdateSmsTemplate() {
        return this.to('UpdateSmsTemplate');
    }
    /**
     * Grants permission to update the active version parameter of a specific template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-template-type-versions.html#templates-template-name-template-type-versions-http-methods
     */
    toUpdateTemplateActiveVersion() {
        return this.to('UpdateTemplateActiveVersion');
    }
    /**
     * Grants permission to update the Voice channel for an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-voice-channel.html#rest-api-voice-channel-methods
     */
    toUpdateVoiceChannel() {
        return this.to('UpdateVoiceChannel');
    }
    /**
     * Grants permission to update a specific voice message template under the same version or generate a new version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     */
    toUpdateVoiceTemplate() {
        return this.to('UpdateVoiceTemplate');
    }
    /**
     * Grants permission to check the validity of One-Time Passwords (OTPs)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-verify-otp.html
     */
    toVerifyOTPMessage() {
        return this.to('VerifyOTPMessage');
    }
    /**
     * Adds a resource of type apps to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/developerguide/gettingstarted.html#gettingstarted-addapp
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApps(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:apps/${appId}`);
    }
    /**
     * Adds a resource of type campaigns to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaigns.html
     *
     * @param appId - Identifier for the appId.
     * @param campaignId - Identifier for the campaignId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCampaigns(appId, campaignId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:apps/${appId}/campaigns/${campaignId}`);
    }
    /**
     * Adds a resource of type journeys to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html
     *
     * @param appId - Identifier for the appId.
     * @param journeyId - Identifier for the journeyId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJourneys(appId, journeyId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:apps/${appId}/journeys/${journeyId}`);
    }
    /**
     * Adds a resource of type segments to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segments.html
     *
     * @param appId - Identifier for the appId.
     * @param segmentId - Identifier for the segmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSegments(appId, segmentId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:apps/${appId}/segments/${segmentId}`);
    }
    /**
     * Adds a resource of type templates to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param channelType - Identifier for the channelType.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTemplates(templateName, channelType, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:templates/${templateName}/${channelType}`);
    }
    /**
     * Adds a resource of type recommenders to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html
     *
     * @param recommenderId - Identifier for the recommenderId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRecommenders(recommenderId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:recommenders/${recommenderId}`);
    }
    /**
     * Adds a resource of type phone-number-validate to the statement
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/phone-number-validate.html
     *
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onPhoneNumberValidate(account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mobiletargeting:${region || '*'}:${account || '*'}:phone/number/validate`);
    }
}
exports.Mobiletargeting = Mobiletargeting;
_a = JSII_RTTI_SYMBOL_1;
Mobiletargeting[_a] = { fqn: "iam-floyd.Mobiletargeting", version: "0.322.0" };
//# sourceMappingURL=data:application/json;base64,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