import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [elastic-inference](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticinference.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ElasticInference extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [elastic-inference](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticinference.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to customer for connecting to Elastic Inference accelerator
     *
     * Access Level: Write
     */
    toConnect(): this;
    /**
     * Grants permission to describe the locations in which a given accelerator type or set of types is present in a given region
     *
     * Access Level: List
     */
    toDescribeAcceleratorOfferings(): this;
    /**
     * Grants permission to describe the accelerator types available in a given region, as well as their characteristics, such as memory and throughput
     *
     * Access Level: List
     */
    toDescribeAcceleratorTypes(): this;
    /**
     * Grants permission to describe information over a provided set of accelerators belonging to an account
     *
     * Access Level: List
     */
    toDescribeAccelerators(): this;
    /**
     * Grants permission to list all tags on an Amazon RDS resource
     *
     * Access Level: Read
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to assign one or more tags (key-value pairs) to the specified QuickSight resource
     *
     * Access Level: Tagging
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag or tags from a resource
     *
     * Access Level: Tagging
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type accelerator to the statement
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAccelerator(acceleratorId: string, account?: string, region?: string, partition?: string): this;
}
