"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Aps extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aps';
        this.accessLevelList = {
            Write: [
                'CreateAlertManagerAlerts',
                'CreateAlertManagerDefinition',
                'CreateRuleGroupsNamespace',
                'CreateWorkspace',
                'DeleteAlertManagerDefinition',
                'DeleteAlertManagerSilence',
                'DeleteRuleGroupsNamespace',
                'DeleteWorkspace',
                'PutAlertManagerDefinition',
                'PutAlertManagerSilences',
                'PutRuleGroupsNamespace',
                'RemoteWrite',
                'UpdateWorkspaceAlias'
            ],
            Read: [
                'DescribeAlertManagerDefinition',
                'DescribeRuleGroupsNamespace',
                'DescribeWorkspace',
                'GetAlertManagerSilence',
                'GetAlertManagerStatus',
                'GetLabels',
                'GetMetricMetadata',
                'GetSeries',
                'ListAlertManagerAlertGroups',
                'ListAlertManagerAlerts',
                'ListAlertManagerReceivers',
                'ListAlertManagerSilences',
                'ListAlerts',
                'ListRules',
                'ListTagsForResource',
                'QueryMetrics'
            ],
            List: [
                'ListRuleGroupsNamespaces',
                'ListWorkspaces'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create alerts
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateAlertManagerAlerts
     */
    toCreateAlertManagerAlerts() {
        return this.to('CreateAlertManagerAlerts');
    }
    /**
     * Grants permission to create an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateAlertManagerDefinition
     */
    toCreateAlertManagerDefinition() {
        return this.to('CreateAlertManagerDefinition');
    }
    /**
     * Grants permission to create a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateRuleGroupsNamespace
     */
    toCreateRuleGroupsNamespace() {
        return this.to('CreateRuleGroupsNamespace');
    }
    /**
     * Grants permission to create a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateWorkspace
     */
    toCreateWorkspace() {
        return this.to('CreateWorkspace');
    }
    /**
     * Grants permission to delete an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteAlertManagerDefinition
     */
    toDeleteAlertManagerDefinition() {
        return this.to('DeleteAlertManagerDefinition');
    }
    /**
     * Grants permission to delete a silence
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteAlertManagerSilence
     */
    toDeleteAlertManagerSilence() {
        return this.to('DeleteAlertManagerSilence');
    }
    /**
     * Grants permission to delete a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteRuleGroupsNamespace
     */
    toDeleteRuleGroupsNamespace() {
        return this.to('DeleteRuleGroupsNamespace');
    }
    /**
     * Grants permission to delete a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteWorkspace
     */
    toDeleteWorkspace() {
        return this.to('DeleteWorkspace');
    }
    /**
     * Grants permission to describe an alert manager definition
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeAlertManagerDefinition
     */
    toDescribeAlertManagerDefinition() {
        return this.to('DescribeAlertManagerDefinition');
    }
    /**
     * Grants permission to describe a rule groups namespace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeRuleGroupsNamespace
     */
    toDescribeRuleGroupsNamespace() {
        return this.to('DescribeRuleGroupsNamespace');
    }
    /**
     * Grants permission to describe a workspace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeWorkspace
     */
    toDescribeWorkspace() {
        return this.to('DescribeWorkspace');
    }
    /**
     * Grants permission to get a silence
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetAlertManagerSilence
     */
    toGetAlertManagerSilence() {
        return this.to('GetAlertManagerSilence');
    }
    /**
     * Grants permission to get current status of an alertmanager
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetAlertManagerStatus
     */
    toGetAlertManagerStatus() {
        return this.to('GetAlertManagerStatus');
    }
    /**
     * Grants permission to retrieve AMP workspace labels
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetLabels
     */
    toGetLabels() {
        return this.to('GetLabels');
    }
    /**
     * Grants permission to retrieve the metadata for AMP workspace metrics
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetMetricMetadata
     */
    toGetMetricMetadata() {
        return this.to('GetMetricMetadata');
    }
    /**
     * Grants permission to retrieve AMP workspace time series data
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetSeries
     */
    toGetSeries() {
        return this.to('GetSeries');
    }
    /**
     * Grants permission to list groups
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerAlertGroups
     */
    toListAlertManagerAlertGroups() {
        return this.to('ListAlertManagerAlertGroups');
    }
    /**
     * Grants permission to list alerts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerAlerts
     */
    toListAlertManagerAlerts() {
        return this.to('ListAlertManagerAlerts');
    }
    /**
     * Grants permission to list receivers
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerReceivers
     */
    toListAlertManagerReceivers() {
        return this.to('ListAlertManagerReceivers');
    }
    /**
     * Grants permission to list silences
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerSilences
     */
    toListAlertManagerSilences() {
        return this.to('ListAlertManagerSilences');
    }
    /**
     * Grants permission to list active alerts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlerts
     */
    toListAlerts() {
        return this.to('ListAlerts');
    }
    /**
     * Grants permission to list rule groups namespaces
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListRuleGroupsNamespaces
     */
    toListRuleGroupsNamespaces() {
        return this.to('ListRuleGroupsNamespaces');
    }
    /**
     * Grants permission to list alerting and recording rules
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListRules
     */
    toListRules() {
        return this.to('ListRules');
    }
    /**
     * Grants permission to list tags on an AMP resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListTagsForResource
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list workspaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListWorkspaces
     */
    toListWorkspaces() {
        return this.to('ListWorkspaces');
    }
    /**
     * Grants permission to update an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutAlertManagerDefinition
     */
    toPutAlertManagerDefinition() {
        return this.to('PutAlertManagerDefinition');
    }
    /**
     * Grants permission to create or update a silence
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutAlertManagerSilences
     */
    toPutAlertManagerSilences() {
        return this.to('PutAlertManagerSilences');
    }
    /**
     * Grants permission to update a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutRuleGroupsNamespace
     */
    toPutRuleGroupsNamespace() {
        return this.to('PutRuleGroupsNamespace');
    }
    /**
     * Grants permission to run a query on AMP workspace metrics
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-QueryMetrics
     */
    toQueryMetrics() {
        return this.to('QueryMetrics');
    }
    /**
     * Grants permission to perform a remote write operation to initiate the streaming of metrics to AMP workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-RemoteWrite
     */
    toRemoteWrite() {
        return this.to('RemoteWrite');
    }
    /**
     * Grants permission to tag an AMP resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-TagResource
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag an AMP resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UntagResource
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to modify the alias of existing AMP workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UpdateWorkspaceAlias
     */
    toUpdateWorkspaceAlias() {
        return this.to('UpdateWorkspaceAlias');
    }
    /**
     * Adds a resource of type workspace to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onWorkspace(workspaceId, account, region, partition) {
        return this.on(`arn:${partition || Aps.defaultPartition}:aps:${region || '*'}:${account || '*'}:workspace/${workspaceId}`);
    }
    /**
     * Adds a resource of type rulegroupsnamespace to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param namespace - Identifier for the namespace.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onRulegroupsnamespace(workspaceId, namespace, account, region, partition) {
        return this.on(`arn:${partition || Aps.defaultPartition}:aps:${region || '*'}:${account || '*'}:rulegroupsnamespace/${workspaceId}/${namespace}`);
    }
}
exports.Aps = Aps;
_a = JSII_RTTI_SYMBOL_1;
Aps[_a] = { fqn: "iam-floyd.Aps", version: "0.361.0" };
//# sourceMappingURL=data:application/json;base64,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