import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [timestream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontimestream.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Timestream extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [timestream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontimestream.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel queries in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_CancelQuery.html
     */
    toCancelQuery(): this;
    /**
     * Grants permission to create a database in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_CreateDatabase.html
     */
    toCreateDatabase(): this;
    /**
     * Grants permission to create a scheduled query in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_CreateScheduledQuery.html
     */
    toCreateScheduledQuery(): this;
    /**
     * Grants permission to create a table in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_CreateTable.html
     */
    toCreateTable(): this;
    /**
     * Grants permission to delete a database in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DeleteDatabase.html
     */
    toDeleteDatabase(): this;
    /**
     * Grants permission to delete a scheduled query in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_DeleteScheduledQuery.html
     */
    toDeleteScheduledQuery(): this;
    /**
     * Grants permission to delete a table in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DeleteTable.html
     */
    toDeleteTable(): this;
    /**
     * Grants permission to describe a database in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeDatabase.html
     */
    toDescribeDatabase(): this;
    /**
     * Grants permission to describe timestream endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeEndpoints.html
     */
    toDescribeEndpoints(): this;
    /**
     * Grants permission to describe a scheduled query in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_DescribeScheduledQuery.html
     */
    toDescribeScheduledQuery(): this;
    /**
     * Grants permission to describe a table in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeTable.html
     */
    toDescribeTable(): this;
    /**
     * Grants permission to execute a scheduled query in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_ExecuteScheduledQuery.html
     */
    toExecuteScheduledQuery(): this;
    /**
     * Grants permission to list databases in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListDatabases.html
     */
    toListDatabases(): this;
    /**
     * Grants permission to list measures of a table in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_Query.html
     */
    toListMeasures(): this;
    /**
     * Grants permission to list scheduled queries in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_ListScheduledQueries.html
     */
    toListScheduledQueries(): this;
    /**
     * Grants permission to list tables in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListTables.html
     */
    toListTables(): this;
    /**
     * Grants permission to list tags of a resource in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to issue prepare queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_PrepareQuery.html
     */
    toPrepareQuery(): this;
    /**
     * Grants permission to issue 'select from table' queries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_Query.html
     */
    toSelect(): this;
    /**
     * Grants permission to issue 'select 1' queries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_Query.html
     */
    toSelectValues(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a database in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UpdateDatabase.html
     */
    toUpdateDatabase(): this;
    /**
     * Grants permission to update a scheduled query in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_UpdateScheduledQuery.html
     */
    toUpdateScheduledQuery(): this;
    /**
     * Grants permission to update a table in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UpdateTable.html
     */
    toUpdateTable(): this;
    /**
     * Grants permission to ingest data to a table in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_WriteRecords.html
     */
    toWriteRecords(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_Database.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatabase(databaseName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_Table.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTable(databaseName: string, tableName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type scheduled-query to the statement
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ScheduledQuery.html
     *
     * @param scheduledQueryName - Identifier for the scheduledQueryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScheduledQuery(scheduledQueryName: string, account?: string, region?: string, partition?: string): this;
}
