"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDestination = void 0;
/**
 * Use a SQS queue as a Lambda destination.
 */
class SqsDestination {
    /**
     *
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration.
     */
    bind(_scope, fn, _options) {
        // deduplicated automatically
        this.queue.grantSendMessages(fn);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDestination = SqsDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQU9BLE1BQWEsY0FBYzs7OztJQUN6QixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7Ozs7SUFLTSxJQUFJLENBQUMsTUFBaUIsRUFBRSxFQUFvQixFQUFFLFFBQW9DO1FBQ3ZGLDZCQUE2QjtRQUM3QixJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBRWpDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFmRCx3Q0FlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNxcyBmcm9tICdAYXdzLWNkay9hd3Mtc3FzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNxc0Rlc3RpbmF0aW9uIGltcGxlbWVudHMgbGFtYmRhLklEZXN0aW5hdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcXVldWU6IHNxcy5JUXVldWUpIHtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBmbjogbGFtYmRhLklGdW5jdGlvbiwgX29wdGlvbnM/OiBsYW1iZGEuRGVzdGluYXRpb25PcHRpb25zKTogbGFtYmRhLkRlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICAvLyBkZWR1cGxpY2F0ZWQgYXV0b21hdGljYWxseVxuICAgIHRoaXMucXVldWUuZ3JhbnRTZW5kTWVzc2FnZXMoZm4pO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGRlc3RpbmF0aW9uOiB0aGlzLnF1ZXVlLnF1ZXVlQXJuLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==