#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Nov  5 14:42:51 2020

@author: RMS671214
"""

from faspy.basel.liquidity import hqla
# Top Level
hqlass = hqla.Level("HQLA", None)
hqlass.child["Level1"] = hqla.Level("Level1", None)
# Level 1
lvl1 = hqlass.child["Level1"]
lvl1.child['Coins'] = hqla.Level("Coins and Bank Notes", 1.00)
lvl1.child['Coins'].amount = 1_000_000_000

lvl1.child['BNM_Reserves'] = hqla.Level("BNM Reserves", 1.00)
lvl1.child['BNM_Reserves'].amount = 2_000_000_000

lvl1.child['Securities'] = hqla.Level("Marketable Securities", 1.00)
lvl1.child['Securities'].amount = 3_000_000_000

lvl1.child['Non_MYR_Assets'] = hqla.Level("Non MYR Assets", 1.00)
lvl1.child['Non_MYR_Assets'].amount = 4_000_000_000

lvl1.child['MYR_Assets'] = hqla.Level("MYR Assets", 1.00)
lvl1.child['MYR_Assets'].amount = 5_000_000_000

# Level2
hqlass.child["Level2"] = hqla.Level("Level2", None)
level2 = hqlass.child["Level2"]
level2.child["Level2A"] = hqla.Level("Level2A", None)
level2A = level2.child["Level2A"]
level2A.child["Cagamas"] = hqla.Level("Cagamas", 0.85)
level2A.child["Cagamas"].amount = 4_000_000_000

level2A.child["PDS"] = hqla.Level("PDS", 0.85)
level2A.child["PDS"].amount = 2_000_000_000

level2.child["Level2B"] = hqla.Level("Level2B", None)
level2B = level2.child["Level2B"]
level2B.child["RMBS"] = hqla.Level("RMBS", 0.75)
level2B.child["RMBS"].amount = 1_000_000_000

level2B.child["PDS"] = hqla.Level("PDS", 0.50)
level2B.child["PDS"].amount = 2_000_000_000

level2B.child["Equity"] = hqla.Level("Equity", 0.50)
level2B.child["Equity"].amount = 3_000_000_000

# Cash Outflow
oflow = hqla.Level("Outflow", None)
oflow.child["retail_deposit"] = hqla.Level("A. Retail Deposits", None)
rdepo = oflow.child["retail_deposit"]
rdepo.child["deposits"] = hqla.Level("Demand deposits and term seposits " +
                                         "(less than 30 days maturity", None)
depo = rdepo.child["deposits"]
depo.child["stable_depo"] = hqla.Level("Stable deposits (deposit insurance " +
                                           "scheme meeting additional criteria)", 0.03)
depo.child["stable_depo"].amount = 1_000_000_000

depo.child["stable_depo2"] = hqla.Level("Stable deposits ", 0.05)
depo.child["stable_depo2"].amount = 4_000_000_000

depo.child["stable_depo3"] = hqla.Level("Less stable retail deposits ", 0.1)
depo.child["stable_depo3"].amount = 250_000_000

rdepo.child["term_deposit"] = hqla.Level("Term deposits with residual maturity " +
                                             "greater than 30 days)", 0.00)

oflow.child["unsecured_wholesale"] = hqla.Level("B. Unsecured wholesale funding", None)
unsecured = oflow.child["unsecured_wholesale"]
unsecured.child["deposits"] = hqla.Level("Demand and term deposits(less than " +
                                             "30 days maturity) provided by " +
                                             "small business customers", None)
udepo = unsecured.child["deposits"]
udepo.child["stable_deposits"] = hqla.Level("Stable Deposits", 0.05)
udepo.child["stable_deposits"].amount = 2_000_000_000

udepo.child["less_stable_deposits"] = hqla.Level("Less Stable Deposits", 0.1)
udepo.child["less_stable_deposits"].amount = 500_000_000
desc = "".join(["Operational deposits generated by clearing, custody and cash ",
                "management activities"])
unsecured.child["operational_deposit"] = hqla.Level(desc, 0.25)
unsecured.child["operational_deposit"].amount = 75_000_000
odepo = unsecured.child["operational_deposit"]
odepo.child["deposit_insurance"] = hqla.Level(desc, 0.05)
odepo.child["deposit_insurance"].amount = 150_000_000

desc= "Cooperative banks in an institutional network (qualifying deposits with the centralised institution)"
unsecured.child["cooperative"] = hqla.Level(desc, 0.25)
unsecured.child["cooperative"].amount = 2_000_000_000

desc = "Non-financial corporates, sovereigns, central banks, multilateral development banks, and PSEs"
unsecured.child["nonfinancial"] = hqla.Level(desc, 0.4)
unsecured.child["nonfinancial"].amount = 750_000_000

desc = "If the entire amount fully covered by deposit insurance scheme"
nonfin = unsecured.child["nonfinancial"]
nonfin.child["deposit_insurance"] = hqla.Level(desc, 0.25)
nonfin.child["deposit_insurance"].amount = 0

desc = "Other legal entity customers"
unsecured.child["others"] = hqla.Level(desc, 1.00)
unsecured.child["others"].amount = 100_000_000

oflow.child["secured"] = hqla.Level("C. Secured Funding", None)
secured = oflow.child["secured"]
desc = "Secured funding transactions with a central bank counterparty or backed by Level 1 assets with any counterparty."
secured.child["central_banks"] = hqla.Level(desc, 0.00)
secured.child["central_banks"].amount = 0

desc = "Secured funding transactions backed by Level 2A assets, with any counterparty"
secured.child["level2A_assets"] = hqla.Level(desc, 0.15)
secured.child["level2A_assets"].amount = 0

desc = "• Secured funding transactions backed by non-Level 1 or non-Level 2A assets, with domestic sovereigns, multilateral development banks, or domestic PSEs as a counterparty"
secured.child["non_level2A_assets"] = hqla.Level(desc, 0.25)
secured.child["non_level2A_assets"].amount = 0

desc = "Backed by RMBS eligible for inclusion in Level 2B"
secured.child["level2B_RMBS"] = hqla.Level(desc, 0.25)
secured.child["level2B_RMBS"].amount = 0

desc = "Backed by other Level 2B assets"
secured.child["level2B_others"] = hqla.Level(desc, 0.50)
secured.child["level2B_others"].amount = 0

desc = "All other secured funding transactions"
secured.child["others"] = hqla.Level(desc, 1.00)
secured.child["others"].amount = 0

oflow.child["additional"] = hqla.Level("D. Additional requirements:", None)
add = oflow.child["additional"]
desc = "Liquidity needs (eg collateral calls) related to financing transactions, derivatives and other contracts"
add.child["liquidity"] = hqla.Level(desc, None)

desc = "Market valuation changes on derivatives transactions (largest absolute net 30-day collateral flows realised during the preceding 24 months)"
add.child["derivative_changes"] = hqla.Level(desc, None)

desc = "Valuation changes on non-Level 1 posted collateral securing derivatives"
add.child["non_level1_changes"] = hqla.Level(desc, 0.2)

desc = "Excess collateral held by a bank related to derivative transactions that could contractually be called at any time by its counterparty"
add.child["excess_coll"] = hqla.Level(desc, 1.00)

desc = "Liquidity needs related to collateral contractually due from the reporting bank on derivatives transactions"
add.child["coll_liq"] = hqla.Level(desc, 1.00)

desc = "Increased liquidity needs related to derivative transactions that allow collateral substitution to non-HQLA assets"
add.child["inc_liquidity"] = hqla.Level(desc, 1.00)

desc = "ABCP, SIVs, conduits, SPVs, etc:"
add.child["conduits"] = hqla.Level(desc, None)
cond = add.child["conduits"]
desc = "Liabilities from maturing ABCP, SIVs, SPVs, etc (applied to maturing amounts and returnable assets)"
cond.child["liabilities"] = hqla.Level(desc, 1.00)

desc = "• Asset Backed Securities (including covered bonds) applied to maturing amounts."
cond.child["assets"] = hqla.Level(desc, 1.00)

desc = "Currently undrawn committed credit and liquidity facilities provided to:"
add.child["uncommitted"] = hqla.Level(desc, 1.00)
unc = add.child["uncommitted"]

desc = "retail and small business clients"
unc.child["retail"] = hqla.Level(desc, 0.05)

desc = "• non-financial corporates, sovereigns and central banks, multilateral development banks, and PSEs"
unc.child["non_fi"] = hqla.Level(desc, None)
nonfi = unc.child["non_fi"]
nonfi.child["credit"] = hqla.Level("Credit", 0.1)
nonfi.child["liquidity"] = hqla.Level("Liquidity", 0.3)

desc = "• banks subject to prudential supervision"
unc.child["prudent"] = hqla.Level(desc, 0.4)
prudent = unc.child["prudent"]

desc = " other financial institutions (include securities firms, insurance companies)"
unc.child["other_fi"] = hqla.Level(desc, None)
ofi = unc.child["other_fi"]
ofi.child["credit"] = hqla.Level("Credit", 0.4)
ofi.child["liquidity"] = hqla.Level("Liquidity", 1.00)

desc = "• other legal entity customers, credit and liquidity facilities"
unc.child["other_le"] = hqla.Level(desc, 1.00)

desc = "Other contingent funding liabilities (such as guarantees, letters of credit, revocable credit and liquidity facilities, etc)"
add.child["others"] = hqla.Level(desc, None)
oth = add.child["others"]

oth.child["trade_fin"] = hqla.Level("Trade Finance", 0.05)
desc = "Customer short positions covered by other customers’ collateral"
oth.child["other_coll"] = hqla.Level(desc, 0.50)

desc = "Any additional contractual outflows"
add.child["add_outflow"] = hqla.Level(desc, 1.00)

desc = "Net derivative cash outflows"
add.child["der_outflow"] = hqla.Level(desc, 1.00)

desc = "Any other contractual cash outflows"
add.child["other_cash_outflow"] = hqla.Level(desc, 1.00)

# Cash Inflow
iflow = hqla.Level("Outflow", None)
iflow.child["level1"] = hqla.Level("Level 1 assets", 0.00)
iflow.child["level2A"] = hqla.Level("Level 2A assets", 0.15)
iflow.child["level2A"].amount = 200_000_000
iflow.child["level2B"] = hqla.Level("Level 2B assets", None)
lvl2b = iflow.child["level2B"]
lvl2b.child["RMBS"] = hqla.Level("Eligible RMBS", 0.25)
lvl2b.child["Others"] = hqla.Level("Other assets", 0.50)
lvl2b.child["Others"].amount = 50_000_000

desc = "Margin lending backed by all other collateral"
iflow.child["margin"] = hqla.Level(desc, 0.50)
iflow.child["margin"].amount = 50_000_000

desc = "All other assets"
iflow.child["other_assets"] = hqla.Level(desc, 1.00)
iflow.child["other_assets"].amount = 25_000_000

desc = "Credit or liquidity facilities provided to the reporting bank"
iflow.child["cr_liq"] = hqla.Level(desc, 0.00)
iflow.child["cr_liq"].amount = 10_000_000_000

desc = "Operational deposits held at other financial institutions (include deposits held at centralised institution of network of co-operative banks)"
iflow.child["op_depo"] = hqla.Level(desc, 0.00)
iflow.child["op_depo"].amount = 1_000_000_000

desc = "Other inflows by counterparty:  "
iflow.child["other_inflows"] = hqla.Level(desc, None)
oiflow = iflow.child["other_inflows"]
desc = "Amounts to be received from retail counterparties "
oiflow.child["retail"] = hqla.Level(desc, 0.5)
oiflow.child["retail"].amount = 50_000_000

desc = "Amounts to be received from non-financial wholesale counterparties, from transactions other than those listed in above inflow categories"
oiflow.child["wholesale"] = hqla.Level(desc, 0.5)
oiflow.child["wholesale"].amount = 70_000_000

desc = "Amounts to be received from financial institutions and central banks, from transactions other than those listed in above inflow categories"
oiflow.child["fis"] = hqla.Level(desc, 1.00)
oiflow.child["fis"].amount = 80_000_000

desc = "Net derivative cash inflows"
iflow.child["def_flows"] = hqla.Level(desc, 1.00)
iflow.child["def_flows"].amount = 25_000_000

desc = "Other contractual cash inflows"
iflow.child["others"] = hqla.Level(desc, None)

print(iflow.value())
print(iflow.get_array())

# %%
import pandas as pd
pdhqla = pd.DataFrame(hqlass.get_array())




