/////////////////////////////////////////////////////////////////////////////
// This C file has been created automatically. Do not edit!!!
/////////////////////////////////////////////////////////////////////////////

/** @file mm_tables.c

 File ``mm_tables.c`` contains functions for supporting the 
 operations \f$x_\epsilon x_\pi\f$ and \f$y_f x_e x_\epsilon\f$ on 
 the vectors of the 198884-dimesional represention  \f$\rho_p\f$
 modulo a small number \f$p\f$. These operations are implemented
 in separate packages for the differnet values of \f$p\f$. But
 there are commom preprocessing steps required for all
 values \f$p\f$. These common preprocessing steps are 
 implemented here. 
 
 The monomial operations \f$x_\epsilon, x_\pi, y_f, x_e\f$ are as
 defined in the **API Reference**, section **The monster group**.
 Here \f$\epsilon\f$ is an element of the Golay cocode represented
 as a 12-bit integer. \f$f\f$ and \f$e\f$ are elements of the
 Parker loop represented as 13-bit integers.  \f$\pi\f$ is
 a automorphism of the Parker loop. In the **API Reference**,
 section **Automorphisms of the Parker loop**  we number
 a certain set of these automorphisms in the same way as the
 elements of the Mathieu group \f$M_{24}\f$. We denote
 such an automorphism  \f$\pi\f$ by its number.
*/
#include <stdint.h>

#include "mat24_functions.h"
#include "mm_basics.h"

// %%EXPORT_KWD MM_BASICS_API


// %%GEN h
// %%GEN c



// %%GEN h
// %%GEN c



// %%GEN ch
#ifdef __cplusplus
extern "C" {
#endif
// %%GEN c

//  %%GEN h
//  %%GEN c




/**
  @var MM_SUB_OCTAD_ELEMENT_TABLE

  For ``0 <= i < 759``, the entries ``8*i,...8*i+7`` in the
  table ``MM_SUB_OCTAD_ELEMENT_TABLE`` are the bit positions of the
  octad with the number ``i`` (in natural order).
*/
// %%EXPORT_TABLE
MM_BASICS_API
const uint8_t MM_SUB_OCTAD_ELEMENT_TABLE[759*8] = { 
    // %%TABLE MM_OctadElementsTable, uint8
0x00,0x01,0x02,0x03,0x08,0x09,0x0a,0x0b,
0x00,0x01,0x02,0x03,0x0c,0x0d,0x0e,0x0f,
0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
0x00,0x01,0x02,0x03,0x10,0x11,0x12,0x13,
0x08,0x09,0x0a,0x0b,0x10,0x11,0x12,0x13,
0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,
0x04,0x05,0x06,0x07,0x14,0x15,0x16,0x17,
0x00,0x01,0x02,0x03,0x14,0x15,0x16,0x17,
0x08,0x09,0x0a,0x0b,0x14,0x15,0x16,0x17,
0x0c,0x0d,0x0e,0x0f,0x14,0x15,0x16,0x17,
0x04,0x05,0x06,0x07,0x10,0x11,0x12,0x13,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
0x04,0x05,0x06,0x07,0x0c,0x0d,0x0e,0x0f,
0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
0x0a,0x0b,0x0e,0x0f,0x12,0x13,0x16,0x17,
0x08,0x09,0x0c,0x0d,0x12,0x13,0x16,0x17,
0x08,0x09,0x0e,0x0f,0x10,0x11,0x16,0x17,
0x0a,0x0b,0x0c,0x0d,0x10,0x11,0x16,0x17,
0x08,0x09,0x0e,0x0f,0x12,0x13,0x14,0x15,
0x0a,0x0b,0x0c,0x0d,0x12,0x13,0x14,0x15,
0x0a,0x0b,0x0e,0x0f,0x10,0x11,0x14,0x15,
0x08,0x09,0x0c,0x0d,0x10,0x11,0x14,0x15,
0x09,0x0b,0x0d,0x0f,0x11,0x13,0x15,0x17,
0x08,0x0a,0x0c,0x0e,0x11,0x13,0x15,0x17,
0x08,0x0a,0x0d,0x0f,0x10,0x12,0x15,0x17,
0x09,0x0b,0x0c,0x0e,0x10,0x12,0x15,0x17,
0x08,0x0a,0x0d,0x0f,0x11,0x13,0x14,0x16,
0x09,0x0b,0x0c,0x0e,0x11,0x13,0x14,0x16,
0x09,0x0b,0x0d,0x0f,0x10,0x12,0x14,0x16,
0x08,0x0a,0x0c,0x0e,0x10,0x12,0x14,0x16,
0x09,0x0a,0x0d,0x0e,0x11,0x12,0x15,0x16,
0x08,0x0b,0x0c,0x0f,0x11,0x12,0x15,0x16,
0x08,0x0b,0x0d,0x0e,0x10,0x13,0x15,0x16,
0x09,0x0a,0x0c,0x0f,0x10,0x13,0x15,0x16,
0x08,0x0b,0x0d,0x0e,0x11,0x12,0x14,0x17,
0x09,0x0a,0x0c,0x0f,0x11,0x12,0x14,0x17,
0x09,0x0a,0x0d,0x0e,0x10,0x13,0x14,0x17,
0x08,0x0b,0x0c,0x0f,0x10,0x13,0x14,0x17,
0x06,0x07,0x0e,0x0f,0x11,0x13,0x15,0x16,
0x04,0x05,0x0c,0x0d,0x10,0x12,0x14,0x17,
0x06,0x07,0x0c,0x0d,0x10,0x12,0x15,0x16,
0x04,0x05,0x0e,0x0f,0x11,0x13,0x14,0x17,
0x06,0x07,0x0c,0x0d,0x11,0x13,0x14,0x17,
0x04,0x05,0x0e,0x0f,0x10,0x12,0x15,0x16,
0x06,0x07,0x0e,0x0f,0x10,0x12,0x14,0x17,
0x04,0x05,0x0c,0x0d,0x11,0x13,0x15,0x16,
0x06,0x07,0x0a,0x0b,0x11,0x12,0x15,0x17,
0x04,0x05,0x08,0x09,0x10,0x13,0x14,0x16,
0x06,0x07,0x08,0x09,0x10,0x13,0x15,0x17,
0x04,0x05,0x0a,0x0b,0x11,0x12,0x14,0x16,
0x06,0x07,0x08,0x09,0x11,0x12,0x14,0x16,
0x04,0x05,0x0a,0x0b,0x10,0x13,0x15,0x17,
0x06,0x07,0x0a,0x0b,0x10,0x13,0x14,0x16,
0x04,0x05,0x08,0x09,0x11,0x12,0x15,0x17,
0x06,0x07,0x09,0x0b,0x0d,0x0e,0x16,0x17,
0x06,0x07,0x08,0x0a,0x0c,0x0f,0x16,0x17,
0x04,0x05,0x08,0x0a,0x0c,0x0f,0x14,0x15,
0x04,0x05,0x09,0x0b,0x0d,0x0e,0x14,0x15,
0x06,0x07,0x08,0x0a,0x0d,0x0e,0x14,0x15,
0x06,0x07,0x09,0x0b,0x0c,0x0f,0x14,0x15,
0x04,0x05,0x09,0x0b,0x0c,0x0f,0x16,0x17,
0x04,0x05,0x08,0x0a,0x0d,0x0e,0x16,0x17,
0x06,0x07,0x09,0x0a,0x0d,0x0f,0x12,0x13,
0x06,0x07,0x08,0x0b,0x0c,0x0e,0x12,0x13,
0x06,0x07,0x08,0x0b,0x0d,0x0f,0x10,0x11,
0x06,0x07,0x09,0x0a,0x0c,0x0e,0x10,0x11,
0x04,0x05,0x08,0x0b,0x0c,0x0e,0x10,0x11,
0x04,0x05,0x09,0x0a,0x0d,0x0f,0x10,0x11,
0x04,0x05,0x09,0x0a,0x0c,0x0e,0x12,0x13,
0x04,0x05,0x08,0x0b,0x0d,0x0f,0x12,0x13,
0x05,0x07,0x0d,0x0f,0x11,0x12,0x16,0x17,
0x04,0x06,0x0c,0x0e,0x10,0x13,0x14,0x15,
0x05,0x07,0x0c,0x0e,0x10,0x13,0x16,0x17,
0x04,0x06,0x0d,0x0f,0x11,0x12,0x14,0x15,
0x05,0x07,0x0c,0x0e,0x11,0x12,0x14,0x15,
0x04,0x06,0x0d,0x0f,0x10,0x13,0x16,0x17,
0x05,0x07,0x0d,0x0f,0x10,0x13,0x14,0x15,
0x04,0x06,0x0c,0x0e,0x11,0x12,0x16,0x17,
0x05,0x07,0x0a,0x0b,0x0d,0x0e,0x11,0x13,
0x05,0x07,0x08,0x09,0x0c,0x0f,0x11,0x13,
0x05,0x07,0x08,0x09,0x0d,0x0e,0x10,0x12,
0x05,0x07,0x0a,0x0b,0x0c,0x0f,0x10,0x12,
0x04,0x06,0x08,0x09,0x0c,0x0f,0x10,0x12,
0x04,0x06,0x0a,0x0b,0x0d,0x0e,0x10,0x12,
0x04,0x06,0x0a,0x0b,0x0c,0x0f,0x11,0x13,
0x04,0x06,0x08,0x09,0x0d,0x0e,0x11,0x13,
0x05,0x07,0x09,0x0b,0x12,0x13,0x15,0x16,
0x04,0x06,0x08,0x0a,0x10,0x11,0x14,0x17,
0x05,0x07,0x08,0x0a,0x10,0x11,0x15,0x16,
0x04,0x06,0x09,0x0b,0x12,0x13,0x14,0x17,
0x05,0x07,0x08,0x0a,0x12,0x13,0x14,0x17,
0x04,0x06,0x09,0x0b,0x10,0x11,0x15,0x16,
0x05,0x07,0x09,0x0b,0x10,0x11,0x14,0x17,
0x04,0x06,0x08,0x0a,0x12,0x13,0x15,0x16,
0x05,0x07,0x09,0x0a,0x0e,0x0f,0x15,0x17,
0x05,0x07,0x08,0x0b,0x0c,0x0d,0x15,0x17,
0x04,0x06,0x08,0x0b,0x0c,0x0d,0x14,0x16,
0x04,0x06,0x09,0x0a,0x0e,0x0f,0x14,0x16,
0x05,0x07,0x08,0x0b,0x0e,0x0f,0x14,0x16,
0x05,0x07,0x09,0x0a,0x0c,0x0d,0x14,0x16,
0x04,0x06,0x09,0x0a,0x0c,0x0d,0x15,0x17,
0x04,0x06,0x08,0x0b,0x0e,0x0f,0x15,0x17,
0x05,0x06,0x0d,0x0e,0x12,0x13,0x15,0x17,
0x04,0x07,0x0c,0x0f,0x10,0x11,0x14,0x16,
0x05,0x06,0x0c,0x0f,0x10,0x11,0x15,0x17,
0x04,0x07,0x0d,0x0e,0x12,0x13,0x14,0x16,
0x05,0x06,0x0c,0x0f,0x12,0x13,0x14,0x16,
0x04,0x07,0x0d,0x0e,0x10,0x11,0x15,0x17,
0x05,0x06,0x0d,0x0e,0x10,0x11,0x14,0x16,
0x04,0x07,0x0c,0x0f,0x12,0x13,0x15,0x17,
0x05,0x06,0x0a,0x0b,0x0d,0x0f,0x15,0x16,
0x05,0x06,0x08,0x09,0x0c,0x0e,0x15,0x16,
0x04,0x07,0x08,0x09,0x0c,0x0e,0x14,0x17,
0x04,0x07,0x0a,0x0b,0x0d,0x0f,0x14,0x17,
0x05,0x06,0x08,0x09,0x0d,0x0f,0x14,0x17,
0x05,0x06,0x0a,0x0b,0x0c,0x0e,0x14,0x17,
0x04,0x07,0x0a,0x0b,0x0c,0x0e,0x15,0x16,
0x04,0x07,0x08,0x09,0x0d,0x0f,0x15,0x16,
0x05,0x06,0x09,0x0b,0x0e,0x0f,0x11,0x12,
0x05,0x06,0x08,0x0a,0x0c,0x0d,0x11,0x12,
0x05,0x06,0x08,0x0a,0x0e,0x0f,0x10,0x13,
0x05,0x06,0x09,0x0b,0x0c,0x0d,0x10,0x13,
0x04,0x07,0x08,0x0a,0x0c,0x0d,0x10,0x13,
0x04,0x07,0x09,0x0b,0x0e,0x0f,0x10,0x13,
0x04,0x07,0x09,0x0b,0x0c,0x0d,0x11,0x12,
0x04,0x07,0x08,0x0a,0x0e,0x0f,0x11,0x12,
0x05,0x06,0x09,0x0a,0x11,0x13,0x16,0x17,
0x04,0x07,0x08,0x0b,0x10,0x12,0x14,0x15,
0x05,0x06,0x08,0x0b,0x10,0x12,0x16,0x17,
0x04,0x07,0x09,0x0a,0x11,0x13,0x14,0x15,
0x05,0x06,0x08,0x0b,0x11,0x13,0x14,0x15,
0x04,0x07,0x09,0x0a,0x10,0x12,0x16,0x17,
0x05,0x06,0x09,0x0a,0x10,0x12,0x14,0x15,
0x04,0x07,0x08,0x0b,0x11,0x13,0x16,0x17,
0x02,0x03,0x0e,0x0f,0x11,0x12,0x15,0x17,
0x00,0x01,0x0c,0x0d,0x11,0x12,0x15,0x17,
0x00,0x01,0x0e,0x0f,0x10,0x13,0x15,0x17,
0x02,0x03,0x0c,0x0d,0x10,0x13,0x15,0x17,
0x00,0x01,0x0e,0x0f,0x11,0x12,0x14,0x16,
0x02,0x03,0x0c,0x0d,0x11,0x12,0x14,0x16,
0x02,0x03,0x0e,0x0f,0x10,0x13,0x14,0x16,
0x00,0x01,0x0c,0x0d,0x10,0x13,0x14,0x16,
0x02,0x03,0x0a,0x0b,0x11,0x13,0x15,0x16,
0x00,0x01,0x08,0x09,0x11,0x13,0x15,0x16,
0x00,0x01,0x0a,0x0b,0x10,0x12,0x15,0x16,
0x02,0x03,0x08,0x09,0x10,0x12,0x15,0x16,
0x00,0x01,0x0a,0x0b,0x11,0x13,0x14,0x17,
0x02,0x03,0x08,0x09,0x11,0x13,0x14,0x17,
0x02,0x03,0x0a,0x0b,0x10,0x12,0x14,0x17,
0x00,0x01,0x08,0x09,0x10,0x12,0x14,0x17,
0x02,0x03,0x09,0x0b,0x0d,0x0e,0x12,0x13,
0x00,0x01,0x08,0x0a,0x0d,0x0e,0x12,0x13,
0x00,0x01,0x09,0x0b,0x0c,0x0f,0x12,0x13,
0x02,0x03,0x08,0x0a,0x0c,0x0f,0x12,0x13,
0x00,0x01,0x09,0x0b,0x0d,0x0e,0x10,0x11,
0x02,0x03,0x08,0x0a,0x0d,0x0e,0x10,0x11,
0x02,0x03,0x09,0x0b,0x0c,0x0f,0x10,0x11,
0x00,0x01,0x08,0x0a,0x0c,0x0f,0x10,0x11,
0x02,0x03,0x09,0x0a,0x0d,0x0f,0x16,0x17,
0x00,0x01,0x08,0x0b,0x0d,0x0f,0x16,0x17,
0x00,0x01,0x09,0x0a,0x0c,0x0e,0x16,0x17,
0x02,0x03,0x08,0x0b,0x0c,0x0e,0x16,0x17,
0x00,0x01,0x09,0x0a,0x0d,0x0f,0x14,0x15,
0x02,0x03,0x08,0x0b,0x0d,0x0f,0x14,0x15,
0x02,0x03,0x09,0x0a,0x0c,0x0e,0x14,0x15,
0x00,0x01,0x08,0x0b,0x0c,0x0e,0x14,0x15,
0x02,0x03,0x06,0x07,0x12,0x13,0x16,0x17,
0x00,0x01,0x04,0x05,0x10,0x11,0x14,0x15,
0x00,0x01,0x06,0x07,0x10,0x11,0x16,0x17,
0x02,0x03,0x04,0x05,0x12,0x13,0x14,0x15,
0x00,0x01,0x06,0x07,0x12,0x13,0x14,0x15,
0x02,0x03,0x04,0x05,0x10,0x11,0x16,0x17,
0x02,0x03,0x06,0x07,0x10,0x11,0x14,0x15,
0x00,0x01,0x04,0x05,0x12,0x13,0x16,0x17,
0x02,0x03,0x06,0x07,0x0a,0x0b,0x0e,0x0f,
0x00,0x01,0x06,0x07,0x08,0x09,0x0e,0x0f,
0x00,0x01,0x06,0x07,0x0a,0x0b,0x0c,0x0d,
0x02,0x03,0x06,0x07,0x08,0x09,0x0c,0x0d,
0x00,0x01,0x04,0x05,0x08,0x09,0x0c,0x0d,
0x02,0x03,0x04,0x05,0x0a,0x0b,0x0c,0x0d,
0x02,0x03,0x04,0x05,0x08,0x09,0x0e,0x0f,
0x00,0x01,0x04,0x05,0x0a,0x0b,0x0e,0x0f,
0x02,0x03,0x05,0x07,0x0d,0x0e,0x15,0x16,
0x00,0x01,0x05,0x07,0x0c,0x0f,0x15,0x16,
0x00,0x01,0x04,0x06,0x0c,0x0f,0x14,0x17,
0x02,0x03,0x04,0x06,0x0d,0x0e,0x14,0x17,
0x00,0x01,0x05,0x07,0x0d,0x0e,0x14,0x17,
0x02,0x03,0x05,0x07,0x0c,0x0f,0x14,0x17,
0x02,0x03,0x04,0x06,0x0c,0x0f,0x15,0x16,
0x00,0x01,0x04,0x06,0x0d,0x0e,0x15,0x16,
0x02,0x03,0x05,0x07,0x09,0x0a,0x11,0x12,
0x00,0x01,0x05,0x07,0x08,0x0b,0x11,0x12,
0x00,0x01,0x05,0x07,0x09,0x0a,0x10,0x13,
0x02,0x03,0x05,0x07,0x08,0x0b,0x10,0x13,
0x00,0x01,0x04,0x06,0x08,0x0b,0x10,0x13,
0x02,0x03,0x04,0x06,0x09,0x0a,0x10,0x13,
0x02,0x03,0x04,0x06,0x08,0x0b,0x11,0x12,
0x00,0x01,0x04,0x06,0x09,0x0a,0x11,0x12,
0x02,0x03,0x05,0x06,0x0d,0x0f,0x11,0x13,
0x00,0x01,0x05,0x06,0x0c,0x0e,0x11,0x13,
0x00,0x01,0x05,0x06,0x0d,0x0f,0x10,0x12,
0x02,0x03,0x05,0x06,0x0c,0x0e,0x10,0x12,
0x00,0x01,0x04,0x07,0x0c,0x0e,0x10,0x12,
0x02,0x03,0x04,0x07,0x0d,0x0f,0x10,0x12,
0x02,0x03,0x04,0x07,0x0c,0x0e,0x11,0x13,
0x00,0x01,0x04,0x07,0x0d,0x0f,0x11,0x13,
0x02,0x03,0x05,0x06,0x09,0x0b,0x15,0x17,
0x00,0x01,0x05,0x06,0x08,0x0a,0x15,0x17,
0x00,0x01,0x04,0x07,0x08,0x0a,0x14,0x16,
0x02,0x03,0x04,0x07,0x09,0x0b,0x14,0x16,
0x00,0x01,0x05,0x06,0x09,0x0b,0x14,0x16,
0x02,0x03,0x05,0x06,0x08,0x0a,0x14,0x16,
0x02,0x03,0x04,0x07,0x08,0x0a,0x15,0x17,
0x00,0x01,0x04,0x07,0x09,0x0b,0x15,0x17,
0x01,0x03,0x0d,0x0f,0x12,0x13,0x15,0x16,
0x00,0x02,0x0c,0x0e,0x12,0x13,0x15,0x16,
0x00,0x02,0x0d,0x0f,0x10,0x11,0x15,0x16,
0x01,0x03,0x0c,0x0e,0x10,0x11,0x15,0x16,
0x00,0x02,0x0d,0x0f,0x12,0x13,0x14,0x17,
0x01,0x03,0x0c,0x0e,0x12,0x13,0x14,0x17,
0x01,0x03,0x0d,0x0f,0x10,0x11,0x14,0x17,
0x00,0x02,0x0c,0x0e,0x10,0x11,0x14,0x17,
0x01,0x03,0x0a,0x0b,0x0d,0x0e,0x15,0x17,
0x00,0x02,0x08,0x09,0x0d,0x0e,0x15,0x17,
0x00,0x02,0x0a,0x0b,0x0c,0x0f,0x15,0x17,
0x01,0x03,0x08,0x09,0x0c,0x0f,0x15,0x17,
0x00,0x02,0x0a,0x0b,0x0d,0x0e,0x14,0x16,
0x01,0x03,0x08,0x09,0x0d,0x0e,0x14,0x16,
0x01,0x03,0x0a,0x0b,0x0c,0x0f,0x14,0x16,
0x00,0x02,0x08,0x09,0x0c,0x0f,0x14,0x16,
0x01,0x03,0x09,0x0b,0x11,0x12,0x16,0x17,
0x00,0x02,0x08,0x0a,0x11,0x12,0x16,0x17,
0x00,0x02,0x09,0x0b,0x10,0x13,0x16,0x17,
0x01,0x03,0x08,0x0a,0x10,0x13,0x16,0x17,
0x00,0x02,0x09,0x0b,0x11,0x12,0x14,0x15,
0x01,0x03,0x08,0x0a,0x11,0x12,0x14,0x15,
0x01,0x03,0x09,0x0b,0x10,0x13,0x14,0x15,
0x00,0x02,0x08,0x0a,0x10,0x13,0x14,0x15,
0x01,0x03,0x09,0x0a,0x0e,0x0f,0x11,0x13,
0x00,0x02,0x08,0x0b,0x0e,0x0f,0x11,0x13,
0x00,0x02,0x09,0x0a,0x0c,0x0d,0x11,0x13,
0x01,0x03,0x08,0x0b,0x0c,0x0d,0x11,0x13,
0x00,0x02,0x09,0x0a,0x0e,0x0f,0x10,0x12,
0x01,0x03,0x08,0x0b,0x0e,0x0f,0x10,0x12,
0x01,0x03,0x09,0x0a,0x0c,0x0d,0x10,0x12,
0x00,0x02,0x08,0x0b,0x0c,0x0d,0x10,0x12,
0x01,0x03,0x06,0x07,0x0d,0x0e,0x11,0x12,
0x00,0x02,0x06,0x07,0x0c,0x0f,0x11,0x12,
0x00,0x02,0x06,0x07,0x0d,0x0e,0x10,0x13,
0x01,0x03,0x06,0x07,0x0c,0x0f,0x10,0x13,
0x00,0x02,0x04,0x05,0x0c,0x0f,0x10,0x13,
0x01,0x03,0x04,0x05,0x0d,0x0e,0x10,0x13,
0x01,0x03,0x04,0x05,0x0c,0x0f,0x11,0x12,
0x00,0x02,0x04,0x05,0x0d,0x0e,0x11,0x12,
0x01,0x03,0x06,0x07,0x09,0x0a,0x15,0x16,
0x00,0x02,0x06,0x07,0x08,0x0b,0x15,0x16,
0x00,0x02,0x04,0x05,0x08,0x0b,0x14,0x17,
0x01,0x03,0x04,0x05,0x09,0x0a,0x14,0x17,
0x00,0x02,0x06,0x07,0x09,0x0a,0x14,0x17,
0x01,0x03,0x06,0x07,0x08,0x0b,0x14,0x17,
0x01,0x03,0x04,0x05,0x08,0x0b,0x15,0x16,
0x00,0x02,0x04,0x05,0x09,0x0a,0x15,0x16,
0x01,0x03,0x05,0x07,0x11,0x13,0x15,0x17,
0x00,0x02,0x04,0x06,0x10,0x12,0x14,0x16,
0x00,0x02,0x05,0x07,0x10,0x12,0x15,0x17,
0x01,0x03,0x04,0x06,0x11,0x13,0x14,0x16,
0x00,0x02,0x05,0x07,0x11,0x13,0x14,0x16,
0x01,0x03,0x04,0x06,0x10,0x12,0x15,0x17,
0x01,0x03,0x05,0x07,0x10,0x12,0x14,0x16,
0x00,0x02,0x04,0x06,0x11,0x13,0x15,0x17,
0x01,0x03,0x05,0x07,0x09,0x0b,0x0d,0x0f,
0x00,0x02,0x05,0x07,0x08,0x0a,0x0d,0x0f,
0x00,0x02,0x05,0x07,0x09,0x0b,0x0c,0x0e,
0x01,0x03,0x05,0x07,0x08,0x0a,0x0c,0x0e,
0x00,0x02,0x04,0x06,0x08,0x0a,0x0c,0x0e,
0x01,0x03,0x04,0x06,0x09,0x0b,0x0c,0x0e,
0x01,0x03,0x04,0x06,0x08,0x0a,0x0d,0x0f,
0x00,0x02,0x04,0x06,0x09,0x0b,0x0d,0x0f,
0x01,0x03,0x05,0x06,0x0e,0x0f,0x16,0x17,
0x00,0x02,0x05,0x06,0x0c,0x0d,0x16,0x17,
0x00,0x02,0x04,0x07,0x0c,0x0d,0x14,0x15,
0x01,0x03,0x04,0x07,0x0e,0x0f,0x14,0x15,
0x00,0x02,0x05,0x06,0x0e,0x0f,0x14,0x15,
0x01,0x03,0x05,0x06,0x0c,0x0d,0x14,0x15,
0x01,0x03,0x04,0x07,0x0c,0x0d,0x16,0x17,
0x00,0x02,0x04,0x07,0x0e,0x0f,0x16,0x17,
0x01,0x03,0x05,0x06,0x0a,0x0b,0x12,0x13,
0x00,0x02,0x05,0x06,0x08,0x09,0x12,0x13,
0x00,0x02,0x05,0x06,0x0a,0x0b,0x10,0x11,
0x01,0x03,0x05,0x06,0x08,0x09,0x10,0x11,
0x00,0x02,0x04,0x07,0x08,0x09,0x10,0x11,
0x01,0x03,0x04,0x07,0x0a,0x0b,0x10,0x11,
0x01,0x03,0x04,0x07,0x08,0x09,0x12,0x13,
0x00,0x02,0x04,0x07,0x0a,0x0b,0x12,0x13,
0x01,0x02,0x0d,0x0e,0x11,0x13,0x16,0x17,
0x00,0x03,0x0c,0x0f,0x11,0x13,0x16,0x17,
0x00,0x03,0x0d,0x0e,0x10,0x12,0x16,0x17,
0x01,0x02,0x0c,0x0f,0x10,0x12,0x16,0x17,
0x00,0x03,0x0d,0x0e,0x11,0x13,0x14,0x15,
0x01,0x02,0x0c,0x0f,0x11,0x13,0x14,0x15,
0x01,0x02,0x0d,0x0e,0x10,0x12,0x14,0x15,
0x00,0x03,0x0c,0x0f,0x10,0x12,0x14,0x15,
0x01,0x02,0x0a,0x0b,0x0d,0x0f,0x11,0x12,
0x00,0x03,0x08,0x09,0x0d,0x0f,0x11,0x12,
0x00,0x03,0x0a,0x0b,0x0c,0x0e,0x11,0x12,
0x01,0x02,0x08,0x09,0x0c,0x0e,0x11,0x12,
0x00,0x03,0x0a,0x0b,0x0d,0x0f,0x10,0x13,
0x01,0x02,0x08,0x09,0x0d,0x0f,0x10,0x13,
0x01,0x02,0x0a,0x0b,0x0c,0x0e,0x10,0x13,
0x00,0x03,0x08,0x09,0x0c,0x0e,0x10,0x13,
0x01,0x02,0x09,0x0b,0x0e,0x0f,0x15,0x16,
0x00,0x03,0x08,0x0a,0x0e,0x0f,0x15,0x16,
0x00,0x03,0x09,0x0b,0x0c,0x0d,0x15,0x16,
0x01,0x02,0x08,0x0a,0x0c,0x0d,0x15,0x16,
0x00,0x03,0x09,0x0b,0x0e,0x0f,0x14,0x17,
0x01,0x02,0x08,0x0a,0x0e,0x0f,0x14,0x17,
0x01,0x02,0x09,0x0b,0x0c,0x0d,0x14,0x17,
0x00,0x03,0x08,0x0a,0x0c,0x0d,0x14,0x17,
0x01,0x02,0x09,0x0a,0x12,0x13,0x15,0x17,
0x00,0x03,0x08,0x0b,0x12,0x13,0x15,0x17,
0x00,0x03,0x09,0x0a,0x10,0x11,0x15,0x17,
0x01,0x02,0x08,0x0b,0x10,0x11,0x15,0x17,
0x00,0x03,0x09,0x0a,0x12,0x13,0x14,0x16,
0x01,0x02,0x08,0x0b,0x12,0x13,0x14,0x16,
0x01,0x02,0x09,0x0a,0x10,0x11,0x14,0x16,
0x00,0x03,0x08,0x0b,0x10,0x11,0x14,0x16,
0x01,0x02,0x06,0x07,0x0d,0x0f,0x15,0x17,
0x00,0x03,0x06,0x07,0x0c,0x0e,0x15,0x17,
0x00,0x03,0x04,0x05,0x0c,0x0e,0x14,0x16,
0x01,0x02,0x04,0x05,0x0d,0x0f,0x14,0x16,
0x00,0x03,0x06,0x07,0x0d,0x0f,0x14,0x16,
0x01,0x02,0x06,0x07,0x0c,0x0e,0x14,0x16,
0x01,0x02,0x04,0x05,0x0c,0x0e,0x15,0x17,
0x00,0x03,0x04,0x05,0x0d,0x0f,0x15,0x17,
0x01,0x02,0x06,0x07,0x09,0x0b,0x11,0x13,
0x00,0x03,0x06,0x07,0x08,0x0a,0x11,0x13,
0x00,0x03,0x06,0x07,0x09,0x0b,0x10,0x12,
0x01,0x02,0x06,0x07,0x08,0x0a,0x10,0x12,
0x00,0x03,0x04,0x05,0x08,0x0a,0x10,0x12,
0x01,0x02,0x04,0x05,0x09,0x0b,0x10,0x12,
0x01,0x02,0x04,0x05,0x08,0x0a,0x11,0x13,
0x00,0x03,0x04,0x05,0x09,0x0b,0x11,0x13,
0x01,0x02,0x05,0x07,0x0e,0x0f,0x12,0x13,
0x00,0x03,0x05,0x07,0x0c,0x0d,0x12,0x13,
0x00,0x03,0x05,0x07,0x0e,0x0f,0x10,0x11,
0x01,0x02,0x05,0x07,0x0c,0x0d,0x10,0x11,
0x00,0x03,0x04,0x06,0x0c,0x0d,0x10,0x11,
0x01,0x02,0x04,0x06,0x0e,0x0f,0x10,0x11,
0x01,0x02,0x04,0x06,0x0c,0x0d,0x12,0x13,
0x00,0x03,0x04,0x06,0x0e,0x0f,0x12,0x13,
0x01,0x02,0x05,0x07,0x0a,0x0b,0x16,0x17,
0x00,0x03,0x05,0x07,0x08,0x09,0x16,0x17,
0x00,0x03,0x04,0x06,0x08,0x09,0x14,0x15,
0x01,0x02,0x04,0x06,0x0a,0x0b,0x14,0x15,
0x00,0x03,0x05,0x07,0x0a,0x0b,0x14,0x15,
0x01,0x02,0x05,0x07,0x08,0x09,0x14,0x15,
0x01,0x02,0x04,0x06,0x08,0x09,0x16,0x17,
0x00,0x03,0x04,0x06,0x0a,0x0b,0x16,0x17,
0x01,0x02,0x05,0x06,0x11,0x12,0x15,0x16,
0x00,0x03,0x04,0x07,0x10,0x13,0x14,0x17,
0x00,0x03,0x05,0x06,0x10,0x13,0x15,0x16,
0x01,0x02,0x04,0x07,0x11,0x12,0x14,0x17,
0x00,0x03,0x05,0x06,0x11,0x12,0x14,0x17,
0x01,0x02,0x04,0x07,0x10,0x13,0x15,0x16,
0x01,0x02,0x05,0x06,0x10,0x13,0x14,0x17,
0x00,0x03,0x04,0x07,0x11,0x12,0x15,0x16,
0x01,0x02,0x05,0x06,0x09,0x0a,0x0d,0x0e,
0x00,0x03,0x05,0x06,0x08,0x0b,0x0d,0x0e,
0x00,0x03,0x05,0x06,0x09,0x0a,0x0c,0x0f,
0x01,0x02,0x05,0x06,0x08,0x0b,0x0c,0x0f,
0x00,0x03,0x04,0x07,0x08,0x0b,0x0c,0x0f,
0x01,0x02,0x04,0x07,0x09,0x0a,0x0c,0x0f,
0x01,0x02,0x04,0x07,0x08,0x0b,0x0d,0x0e,
0x00,0x03,0x04,0x07,0x09,0x0a,0x0d,0x0e,
0x01,0x02,0x03,0x04,0x08,0x0c,0x10,0x14,
0x00,0x04,0x09,0x0a,0x0b,0x0c,0x10,0x14,
0x00,0x04,0x08,0x0d,0x0e,0x0f,0x10,0x14,
0x00,0x04,0x08,0x0c,0x11,0x12,0x13,0x14,
0x00,0x04,0x08,0x0c,0x10,0x15,0x16,0x17,
0x00,0x05,0x06,0x07,0x08,0x0c,0x10,0x14,
0x00,0x05,0x06,0x07,0x09,0x0d,0x11,0x15,
0x00,0x04,0x09,0x0d,0x11,0x14,0x16,0x17,
0x00,0x04,0x09,0x0d,0x10,0x12,0x13,0x15,
0x00,0x04,0x09,0x0c,0x0e,0x0f,0x11,0x15,
0x00,0x04,0x08,0x0a,0x0b,0x0d,0x11,0x15,
0x01,0x02,0x03,0x04,0x09,0x0d,0x11,0x15,
0x00,0x05,0x06,0x07,0x0a,0x0e,0x12,0x16,
0x00,0x04,0x0a,0x0e,0x12,0x14,0x15,0x17,
0x00,0x04,0x0a,0x0e,0x10,0x11,0x13,0x16,
0x00,0x04,0x0a,0x0c,0x0d,0x0f,0x12,0x16,
0x00,0x04,0x08,0x09,0x0b,0x0e,0x12,0x16,
0x01,0x02,0x03,0x04,0x0a,0x0e,0x12,0x16,
0x00,0x05,0x06,0x07,0x0b,0x0f,0x13,0x17,
0x00,0x04,0x0b,0x0f,0x13,0x14,0x15,0x16,
0x00,0x04,0x0b,0x0f,0x10,0x11,0x12,0x17,
0x00,0x04,0x0b,0x0c,0x0d,0x0e,0x13,0x17,
0x00,0x04,0x08,0x09,0x0a,0x0f,0x13,0x17,
0x01,0x02,0x03,0x04,0x0b,0x0f,0x13,0x17,
0x00,0x05,0x09,0x0a,0x0b,0x0d,0x12,0x17,
0x01,0x02,0x03,0x05,0x08,0x0d,0x12,0x17,
0x00,0x05,0x08,0x0c,0x0e,0x0f,0x12,0x17,
0x00,0x05,0x08,0x0d,0x10,0x11,0x13,0x17,
0x00,0x05,0x08,0x0d,0x12,0x14,0x15,0x16,
0x00,0x04,0x06,0x07,0x08,0x0d,0x12,0x17,
0x00,0x05,0x09,0x0d,0x0e,0x0f,0x13,0x16,
0x01,0x02,0x03,0x05,0x09,0x0c,0x13,0x16,
0x00,0x05,0x08,0x0a,0x0b,0x0c,0x13,0x16,
0x00,0x05,0x09,0x0c,0x10,0x11,0x12,0x16,
0x00,0x05,0x09,0x0c,0x13,0x14,0x15,0x17,
0x00,0x04,0x06,0x07,0x09,0x0c,0x13,0x16,
0x00,0x05,0x0a,0x0f,0x11,0x12,0x13,0x15,
0x01,0x02,0x03,0x05,0x0a,0x0f,0x10,0x15,
0x00,0x05,0x08,0x09,0x0b,0x0f,0x10,0x15,
0x00,0x05,0x0a,0x0c,0x0d,0x0e,0x10,0x15,
0x00,0x04,0x06,0x07,0x0a,0x0f,0x10,0x15,
0x00,0x05,0x0a,0x0f,0x10,0x14,0x16,0x17,
0x00,0x05,0x0b,0x0e,0x11,0x15,0x16,0x17,
0x00,0x04,0x06,0x07,0x0b,0x0e,0x11,0x14,
0x01,0x02,0x03,0x05,0x0b,0x0e,0x11,0x14,
0x00,0x05,0x08,0x09,0x0a,0x0e,0x11,0x14,
0x00,0x05,0x0b,0x0c,0x0d,0x0f,0x11,0x14,
0x00,0x05,0x0b,0x0e,0x10,0x12,0x13,0x14,
0x00,0x06,0x09,0x0a,0x0b,0x0e,0x13,0x15,
0x01,0x02,0x03,0x06,0x08,0x0e,0x13,0x15,
0x00,0x06,0x08,0x0c,0x0d,0x0f,0x13,0x15,
0x00,0x06,0x08,0x0e,0x10,0x11,0x12,0x15,
0x00,0x06,0x08,0x0e,0x13,0x14,0x16,0x17,
0x00,0x04,0x05,0x07,0x08,0x0e,0x13,0x15,
0x00,0x06,0x09,0x0f,0x12,0x15,0x16,0x17,
0x00,0x04,0x05,0x07,0x09,0x0f,0x12,0x14,
0x01,0x02,0x03,0x06,0x09,0x0f,0x12,0x14,
0x00,0x06,0x08,0x0a,0x0b,0x0f,0x12,0x14,
0x00,0x06,0x09,0x0c,0x0d,0x0e,0x12,0x14,
0x00,0x06,0x09,0x0f,0x10,0x11,0x13,0x14,
0x00,0x06,0x0a,0x0d,0x0e,0x0f,0x11,0x17,
0x01,0x02,0x03,0x06,0x0a,0x0c,0x11,0x17,
0x00,0x06,0x08,0x09,0x0b,0x0c,0x11,0x17,
0x00,0x06,0x0a,0x0c,0x10,0x12,0x13,0x17,
0x00,0x06,0x0a,0x0c,0x11,0x14,0x15,0x16,
0x00,0x04,0x05,0x07,0x0a,0x0c,0x11,0x17,
0x00,0x06,0x0b,0x0d,0x11,0x12,0x13,0x16,
0x01,0x02,0x03,0x06,0x0b,0x0d,0x10,0x16,
0x00,0x06,0x08,0x09,0x0a,0x0d,0x10,0x16,
0x00,0x06,0x0b,0x0c,0x0e,0x0f,0x10,0x16,
0x00,0x04,0x05,0x07,0x0b,0x0d,0x10,0x16,
0x00,0x06,0x0b,0x0d,0x10,0x14,0x15,0x17,
0x00,0x07,0x09,0x0a,0x0b,0x0f,0x11,0x16,
0x01,0x02,0x03,0x07,0x08,0x0f,0x11,0x16,
0x00,0x07,0x08,0x0c,0x0d,0x0e,0x11,0x16,
0x00,0x07,0x08,0x0f,0x10,0x12,0x13,0x16,
0x00,0x07,0x08,0x0f,0x11,0x14,0x15,0x17,
0x00,0x04,0x05,0x06,0x08,0x0f,0x11,0x16,
0x00,0x07,0x09,0x0e,0x11,0x12,0x13,0x17,
0x01,0x02,0x03,0x07,0x09,0x0e,0x10,0x17,
0x00,0x07,0x08,0x0a,0x0b,0x0e,0x10,0x17,
0x00,0x07,0x09,0x0c,0x0d,0x0f,0x10,0x17,
0x00,0x04,0x05,0x06,0x09,0x0e,0x10,0x17,
0x00,0x07,0x09,0x0e,0x10,0x14,0x15,0x16,
0x00,0x07,0x0a,0x0d,0x13,0x15,0x16,0x17,
0x00,0x04,0x05,0x06,0x0a,0x0d,0x13,0x14,
0x01,0x02,0x03,0x07,0x0a,0x0d,0x13,0x14,
0x00,0x07,0x08,0x09,0x0b,0x0d,0x13,0x14,
0x00,0x07,0x0a,0x0c,0x0e,0x0f,0x13,0x14,
0x00,0x07,0x0a,0x0d,0x10,0x11,0x12,0x14,
0x00,0x07,0x0b,0x0d,0x0e,0x0f,0x12,0x15,
0x01,0x02,0x03,0x07,0x0b,0x0c,0x12,0x15,
0x00,0x07,0x08,0x09,0x0a,0x0c,0x12,0x15,
0x00,0x07,0x0b,0x0c,0x10,0x11,0x13,0x15,
0x00,0x07,0x0b,0x0c,0x12,0x14,0x16,0x17,
0x00,0x04,0x05,0x06,0x0b,0x0c,0x12,0x15,
0x01,0x05,0x06,0x07,0x08,0x0d,0x13,0x16,
0x01,0x04,0x08,0x0d,0x13,0x14,0x15,0x17,
0x01,0x04,0x08,0x0d,0x10,0x11,0x12,0x16,
0x01,0x04,0x08,0x0c,0x0e,0x0f,0x13,0x16,
0x00,0x02,0x03,0x04,0x08,0x0d,0x13,0x16,
0x01,0x04,0x09,0x0a,0x0b,0x0d,0x13,0x16,
0x01,0x05,0x06,0x07,0x09,0x0c,0x12,0x17,
0x01,0x04,0x09,0x0c,0x12,0x14,0x15,0x16,
0x01,0x04,0x09,0x0c,0x10,0x11,0x13,0x17,
0x01,0x04,0x08,0x0a,0x0b,0x0c,0x12,0x17,
0x00,0x02,0x03,0x04,0x09,0x0c,0x12,0x17,
0x01,0x04,0x09,0x0d,0x0e,0x0f,0x12,0x17,
0x01,0x04,0x0a,0x0f,0x10,0x12,0x13,0x14,
0x01,0x04,0x0a,0x0c,0x0d,0x0e,0x11,0x14,
0x01,0x04,0x08,0x09,0x0b,0x0f,0x11,0x14,
0x00,0x02,0x03,0x04,0x0a,0x0f,0x11,0x14,
0x01,0x05,0x06,0x07,0x0a,0x0f,0x11,0x14,
0x01,0x04,0x0a,0x0f,0x11,0x15,0x16,0x17,
0x01,0x04,0x0b,0x0e,0x10,0x14,0x16,0x17,
0x01,0x05,0x06,0x07,0x0b,0x0e,0x10,0x15,
0x01,0x04,0x0b,0x0c,0x0d,0x0f,0x10,0x15,
0x01,0x04,0x08,0x09,0x0a,0x0e,0x10,0x15,
0x00,0x02,0x03,0x04,0x0b,0x0e,0x10,0x15,
0x01,0x04,0x0b,0x0e,0x11,0x12,0x13,0x15,
0x01,0x05,0x08,0x0d,0x0e,0x0f,0x11,0x15,
0x01,0x05,0x09,0x0a,0x0b,0x0c,0x11,0x15,
0x00,0x02,0x03,0x05,0x08,0x0c,0x11,0x15,
0x01,0x05,0x08,0x0c,0x10,0x12,0x13,0x15,
0x01,0x05,0x08,0x0c,0x11,0x14,0x16,0x17,
0x01,0x04,0x06,0x07,0x08,0x0c,0x11,0x15,
0x01,0x04,0x06,0x07,0x09,0x0d,0x10,0x14,
0x01,0x05,0x09,0x0d,0x10,0x15,0x16,0x17,
0x01,0x05,0x09,0x0d,0x11,0x12,0x13,0x14,
0x00,0x02,0x03,0x05,0x09,0x0d,0x10,0x14,
0x01,0x05,0x08,0x0a,0x0b,0x0d,0x10,0x14,
0x01,0x05,0x09,0x0c,0x0e,0x0f,0x10,0x14,
0x00,0x02,0x03,0x05,0x0a,0x0e,0x13,0x17,
0x01,0x05,0x08,0x09,0x0b,0x0e,0x13,0x17,
0x01,0x05,0x0a,0x0c,0x0d,0x0f,0x13,0x17,
0x01,0x05,0x0a,0x0e,0x10,0x11,0x12,0x17,
0x01,0x05,0x0a,0x0e,0x13,0x14,0x15,0x16,
0x01,0x04,0x06,0x07,0x0a,0x0e,0x13,0x17,
0x00,0x02,0x03,0x05,0x0b,0x0f,0x12,0x16,
0x01,0x05,0x08,0x09,0x0a,0x0f,0x12,0x16,
0x01,0x05,0x0b,0x0c,0x0d,0x0e,0x12,0x16,
0x01,0x05,0x0b,0x0f,0x10,0x11,0x13,0x16,
0x01,0x05,0x0b,0x0f,0x12,0x14,0x15,0x17,
0x01,0x04,0x06,0x07,0x0b,0x0f,0x12,0x16,
0x01,0x06,0x08,0x0f,0x11,0x12,0x13,0x17,
0x01,0x06,0x09,0x0a,0x0b,0x0f,0x10,0x17,
0x00,0x02,0x03,0x06,0x08,0x0f,0x10,0x17,
0x01,0x06,0x08,0x0c,0x0d,0x0e,0x10,0x17,
0x01,0x04,0x05,0x07,0x08,0x0f,0x10,0x17,
0x01,0x06,0x08,0x0f,0x10,0x14,0x15,0x16,
0x00,0x02,0x03,0x06,0x09,0x0e,0x11,0x16,
0x01,0x06,0x08,0x0a,0x0b,0x0e,0x11,0x16,
0x01,0x06,0x09,0x0c,0x0d,0x0f,0x11,0x16,
0x01,0x06,0x09,0x0e,0x10,0x12,0x13,0x16,
0x01,0x06,0x09,0x0e,0x11,0x14,0x15,0x17,
0x01,0x04,0x05,0x07,0x09,0x0e,0x11,0x16,
0x00,0x02,0x03,0x06,0x0a,0x0d,0x12,0x15,
0x01,0x06,0x08,0x09,0x0b,0x0d,0x12,0x15,
0x01,0x06,0x0a,0x0c,0x0e,0x0f,0x12,0x15,
0x01,0x06,0x0a,0x0d,0x10,0x11,0x13,0x15,
0x01,0x06,0x0a,0x0d,0x12,0x14,0x16,0x17,
0x01,0x04,0x05,0x07,0x0a,0x0d,0x12,0x15,
0x01,0x06,0x0b,0x0c,0x13,0x15,0x16,0x17,
0x01,0x04,0x05,0x07,0x0b,0x0c,0x13,0x14,
0x01,0x06,0x0b,0x0d,0x0e,0x0f,0x13,0x14,
0x00,0x02,0x03,0x06,0x0b,0x0c,0x13,0x14,
0x01,0x06,0x08,0x09,0x0a,0x0c,0x13,0x14,
0x01,0x06,0x0b,0x0c,0x10,0x11,0x12,0x14,
0x01,0x07,0x08,0x0e,0x12,0x15,0x16,0x17,
0x01,0x04,0x05,0x06,0x08,0x0e,0x12,0x14,
0x01,0x07,0x09,0x0a,0x0b,0x0e,0x12,0x14,
0x00,0x02,0x03,0x07,0x08,0x0e,0x12,0x14,
0x01,0x07,0x08,0x0c,0x0d,0x0f,0x12,0x14,
0x01,0x07,0x08,0x0e,0x10,0x11,0x13,0x14,
0x00,0x02,0x03,0x07,0x09,0x0f,0x13,0x15,
0x01,0x07,0x08,0x0a,0x0b,0x0f,0x13,0x15,
0x01,0x07,0x09,0x0c,0x0d,0x0e,0x13,0x15,
0x01,0x07,0x09,0x0f,0x10,0x11,0x12,0x15,
0x01,0x07,0x09,0x0f,0x13,0x14,0x16,0x17,
0x01,0x04,0x05,0x06,0x09,0x0f,0x13,0x15,
0x01,0x07,0x0a,0x0c,0x11,0x12,0x13,0x16,
0x01,0x07,0x0a,0x0d,0x0e,0x0f,0x10,0x16,
0x00,0x02,0x03,0x07,0x0a,0x0c,0x10,0x16,
0x01,0x07,0x08,0x09,0x0b,0x0c,0x10,0x16,
0x01,0x04,0x05,0x06,0x0a,0x0c,0x10,0x16,
0x01,0x07,0x0a,0x0c,0x10,0x14,0x15,0x17,
0x00,0x02,0x03,0x07,0x0b,0x0d,0x11,0x17,
0x01,0x07,0x08,0x09,0x0a,0x0d,0x11,0x17,
0x01,0x07,0x0b,0x0c,0x0e,0x0f,0x11,0x17,
0x01,0x07,0x0b,0x0d,0x10,0x12,0x13,0x17,
0x01,0x07,0x0b,0x0d,0x11,0x14,0x15,0x16,
0x01,0x04,0x05,0x06,0x0b,0x0d,0x11,0x17,
0x02,0x05,0x06,0x07,0x08,0x0e,0x11,0x17,
0x02,0x04,0x08,0x0e,0x11,0x14,0x15,0x16,
0x02,0x04,0x08,0x0e,0x10,0x12,0x13,0x17,
0x02,0x04,0x08,0x0c,0x0d,0x0f,0x11,0x17,
0x00,0x01,0x03,0x04,0x08,0x0e,0x11,0x17,
0x02,0x04,0x09,0x0a,0x0b,0x0e,0x11,0x17,
0x02,0x04,0x09,0x0f,0x10,0x14,0x15,0x17,
0x02,0x05,0x06,0x07,0x09,0x0f,0x10,0x16,
0x02,0x04,0x09,0x0c,0x0d,0x0e,0x10,0x16,
0x02,0x04,0x08,0x0a,0x0b,0x0f,0x10,0x16,
0x00,0x01,0x03,0x04,0x09,0x0f,0x10,0x16,
0x02,0x04,0x09,0x0f,0x11,0x12,0x13,0x16,
0x02,0x05,0x06,0x07,0x0a,0x0c,0x13,0x15,
0x02,0x04,0x0a,0x0c,0x13,0x14,0x16,0x17,
0x02,0x04,0x0a,0x0c,0x10,0x11,0x12,0x15,
0x02,0x04,0x08,0x09,0x0b,0x0c,0x13,0x15,
0x00,0x01,0x03,0x04,0x0a,0x0c,0x13,0x15,
0x02,0x04,0x0a,0x0d,0x0e,0x0f,0x13,0x15,
0x02,0x04,0x0b,0x0d,0x10,0x11,0x13,0x14,
0x02,0x04,0x0b,0x0c,0x0e,0x0f,0x12,0x14,
0x02,0x04,0x08,0x09,0x0a,0x0d,0x12,0x14,
0x00,0x01,0x03,0x04,0x0b,0x0d,0x12,0x14,
0x02,0x05,0x06,0x07,0x0b,0x0d,0x12,0x14,
0x02,0x04,0x0b,0x0d,0x12,0x15,0x16,0x17,
0x02,0x05,0x08,0x0f,0x13,0x15,0x16,0x17,
0x02,0x04,0x06,0x07,0x08,0x0f,0x13,0x14,
0x02,0x05,0x09,0x0a,0x0b,0x0f,0x13,0x14,
0x00,0x01,0x03,0x05,0x08,0x0f,0x13,0x14,
0x02,0x05,0x08,0x0c,0x0d,0x0e,0x13,0x14,
0x02,0x05,0x08,0x0f,0x10,0x11,0x12,0x14,
0x00,0x01,0x03,0x05,0x09,0x0e,0x12,0x15,
0x02,0x05,0x08,0x0a,0x0b,0x0e,0x12,0x15,
0x02,0x05,0x09,0x0c,0x0d,0x0f,0x12,0x15,
0x02,0x05,0x09,0x0e,0x10,0x11,0x13,0x15,
0x02,0x05,0x09,0x0e,0x12,0x14,0x16,0x17,
0x02,0x04,0x06,0x07,0x09,0x0e,0x12,0x15,
0x00,0x01,0x03,0x05,0x0a,0x0d,0x11,0x16,
0x02,0x05,0x08,0x09,0x0b,0x0d,0x11,0x16,
0x02,0x05,0x0a,0x0c,0x0e,0x0f,0x11,0x16,
0x02,0x05,0x0a,0x0d,0x10,0x12,0x13,0x16,
0x02,0x05,0x0a,0x0d,0x11,0x14,0x15,0x17,
0x02,0x04,0x06,0x07,0x0a,0x0d,0x11,0x16,
0x02,0x05,0x0b,0x0c,0x11,0x12,0x13,0x17,
0x02,0x05,0x0b,0x0d,0x0e,0x0f,0x10,0x17,
0x00,0x01,0x03,0x05,0x0b,0x0c,0x10,0x17,
0x02,0x05,0x08,0x09,0x0a,0x0c,0x10,0x17,
0x02,0x04,0x06,0x07,0x0b,0x0c,0x10,0x17,
0x02,0x05,0x0b,0x0c,0x10,0x14,0x15,0x16,
0x02,0x06,0x08,0x0d,0x0e,0x0f,0x12,0x16,
0x02,0x06,0x09,0x0a,0x0b,0x0c,0x12,0x16,
0x00,0x01,0x03,0x06,0x08,0x0c,0x12,0x16,
0x02,0x06,0x08,0x0c,0x10,0x11,0x13,0x16,
0x02,0x06,0x08,0x0c,0x12,0x14,0x15,0x17,
0x02,0x04,0x05,0x07,0x08,0x0c,0x12,0x16,
0x00,0x01,0x03,0x06,0x09,0x0d,0x13,0x17,
0x02,0x06,0x08,0x0a,0x0b,0x0d,0x13,0x17,
0x02,0x06,0x09,0x0c,0x0e,0x0f,0x13,0x17,
0x02,0x06,0x09,0x0d,0x10,0x11,0x12,0x17,
0x02,0x06,0x09,0x0d,0x13,0x14,0x15,0x16,
0x02,0x04,0x05,0x07,0x09,0x0d,0x13,0x17,
0x02,0x04,0x05,0x07,0x0a,0x0e,0x10,0x14,
0x02,0x06,0x0a,0x0e,0x10,0x15,0x16,0x17,
0x02,0x06,0x0a,0x0e,0x11,0x12,0x13,0x14,
0x00,0x01,0x03,0x06,0x0a,0x0e,0x10,0x14,
0x02,0x06,0x08,0x09,0x0b,0x0e,0x10,0x14,
0x02,0x06,0x0a,0x0c,0x0d,0x0f,0x10,0x14,
0x00,0x01,0x03,0x06,0x0b,0x0f,0x11,0x15,
0x02,0x06,0x08,0x09,0x0a,0x0f,0x11,0x15,
0x02,0x06,0x0b,0x0c,0x0d,0x0e,0x11,0x15,
0x02,0x06,0x0b,0x0f,0x10,0x12,0x13,0x15,
0x02,0x06,0x0b,0x0f,0x11,0x14,0x16,0x17,
0x02,0x04,0x05,0x07,0x0b,0x0f,0x11,0x15,
0x02,0x07,0x08,0x0d,0x11,0x12,0x13,0x15,
0x02,0x07,0x09,0x0a,0x0b,0x0d,0x10,0x15,
0x00,0x01,0x03,0x07,0x08,0x0d,0x10,0x15,
0x02,0x07,0x08,0x0c,0x0e,0x0f,0x10,0x15,
0x02,0x04,0x05,0x06,0x08,0x0d,0x10,0x15,
0x02,0x07,0x08,0x0d,0x10,0x14,0x16,0x17,
0x02,0x07,0x09,0x0c,0x11,0x15,0x16,0x17,
0x02,0x04,0x05,0x06,0x09,0x0c,0x11,0x14,
0x02,0x07,0x09,0x0d,0x0e,0x0f,0x11,0x14,
0x00,0x01,0x03,0x07,0x09,0x0c,0x11,0x14,
0x02,0x07,0x08,0x0a,0x0b,0x0c,0x11,0x14,
0x02,0x07,0x09,0x0c,0x10,0x12,0x13,0x14,
0x00,0x01,0x03,0x07,0x0a,0x0f,0x12,0x17,
0x02,0x07,0x08,0x09,0x0b,0x0f,0x12,0x17,
0x02,0x07,0x0a,0x0c,0x0d,0x0e,0x12,0x17,
0x02,0x07,0x0a,0x0f,0x10,0x11,0x13,0x17,
0x02,0x07,0x0a,0x0f,0x12,0x14,0x15,0x16,
0x02,0x04,0x05,0x06,0x0a,0x0f,0x12,0x17,
0x00,0x01,0x03,0x07,0x0b,0x0e,0x13,0x16,
0x02,0x07,0x08,0x09,0x0a,0x0e,0x13,0x16,
0x02,0x07,0x0b,0x0c,0x0d,0x0f,0x13,0x16,
0x02,0x07,0x0b,0x0e,0x10,0x11,0x12,0x16,
0x02,0x07,0x0b,0x0e,0x13,0x14,0x15,0x17,
0x02,0x04,0x05,0x06,0x0b,0x0e,0x13,0x16,
0x03,0x05,0x06,0x07,0x08,0x0f,0x12,0x15,
0x03,0x04,0x08,0x0f,0x12,0x14,0x16,0x17,
0x03,0x04,0x08,0x0f,0x10,0x11,0x13,0x15,
0x03,0x04,0x08,0x0c,0x0d,0x0e,0x12,0x15,
0x00,0x01,0x02,0x04,0x08,0x0f,0x12,0x15,
0x03,0x04,0x09,0x0a,0x0b,0x0f,0x12,0x15,
0x03,0x04,0x09,0x0e,0x10,0x11,0x12,0x14,
0x03,0x04,0x09,0x0c,0x0d,0x0f,0x13,0x14,
0x03,0x04,0x08,0x0a,0x0b,0x0e,0x13,0x14,
0x00,0x01,0x02,0x04,0x09,0x0e,0x13,0x14,
0x03,0x05,0x06,0x07,0x09,0x0e,0x13,0x14,
0x03,0x04,0x09,0x0e,0x13,0x15,0x16,0x17,
0x03,0x04,0x0a,0x0d,0x10,0x14,0x15,0x16,
0x03,0x05,0x06,0x07,0x0a,0x0d,0x10,0x17,
0x03,0x04,0x0a,0x0c,0x0e,0x0f,0x10,0x17,
0x03,0x04,0x08,0x09,0x0b,0x0d,0x10,0x17,
0x00,0x01,0x02,0x04,0x0a,0x0d,0x10,0x17,
0x03,0x04,0x0a,0x0d,0x11,0x12,0x13,0x17,
0x03,0x05,0x06,0x07,0x0b,0x0c,0x11,0x16,
0x03,0x04,0x0b,0x0c,0x11,0x14,0x15,0x17,
0x03,0x04,0x0b,0x0c,0x10,0x12,0x13,0x16,
0x03,0x04,0x08,0x09,0x0a,0x0c,0x11,0x16,
0x00,0x01,0x02,0x04,0x0b,0x0c,0x11,0x16,
0x03,0x04,0x0b,0x0d,0x0e,0x0f,0x11,0x16,
0x03,0x05,0x08,0x0e,0x11,0x12,0x13,0x16,
0x03,0x05,0x09,0x0a,0x0b,0x0e,0x10,0x16,
0x00,0x01,0x02,0x05,0x08,0x0e,0x10,0x16,
0x03,0x05,0x08,0x0c,0x0d,0x0f,0x10,0x16,
0x03,0x04,0x06,0x07,0x08,0x0e,0x10,0x16,
0x03,0x05,0x08,0x0e,0x10,0x14,0x15,0x17,
0x00,0x01,0x02,0x05,0x09,0x0f,0x11,0x17,
0x03,0x05,0x08,0x0a,0x0b,0x0f,0x11,0x17,
0x03,0x05,0x09,0x0c,0x0d,0x0e,0x11,0x17,
0x03,0x05,0x09,0x0f,0x10,0x12,0x13,0x17,
0x03,0x05,0x09,0x0f,0x11,0x14,0x15,0x16,
0x03,0x04,0x06,0x07,0x09,0x0f,0x11,0x17,
0x03,0x05,0x0a,0x0c,0x12,0x15,0x16,0x17,
0x03,0x04,0x06,0x07,0x0a,0x0c,0x12,0x14,
0x03,0x05,0x0a,0x0d,0x0e,0x0f,0x12,0x14,
0x00,0x01,0x02,0x05,0x0a,0x0c,0x12,0x14,
0x03,0x05,0x08,0x09,0x0b,0x0c,0x12,0x14,
0x03,0x05,0x0a,0x0c,0x10,0x11,0x13,0x14,
0x00,0x01,0x02,0x05,0x0b,0x0d,0x13,0x15,
0x03,0x05,0x08,0x09,0x0a,0x0d,0x13,0x15,
0x03,0x05,0x0b,0x0c,0x0e,0x0f,0x13,0x15,
0x03,0x05,0x0b,0x0d,0x10,0x11,0x12,0x15,
0x03,0x05,0x0b,0x0d,0x13,0x14,0x16,0x17,
0x03,0x04,0x06,0x07,0x0b,0x0d,0x13,0x15,
0x03,0x06,0x08,0x0d,0x11,0x15,0x16,0x17,
0x03,0x04,0x05,0x07,0x08,0x0d,0x11,0x14,
0x03,0x06,0x09,0x0a,0x0b,0x0d,0x11,0x14,
0x00,0x01,0x02,0x06,0x08,0x0d,0x11,0x14,
0x03,0x06,0x08,0x0c,0x0e,0x0f,0x11,0x14,
0x03,0x06,0x08,0x0d,0x10,0x12,0x13,0x14,
0x03,0x06,0x09,0x0c,0x11,0x12,0x13,0x15,
0x03,0x06,0x09,0x0d,0x0e,0x0f,0x10,0x15,
0x00,0x01,0x02,0x06,0x09,0x0c,0x10,0x15,
0x03,0x06,0x08,0x0a,0x0b,0x0c,0x10,0x15,
0x03,0x04,0x05,0x07,0x09,0x0c,0x10,0x15,
0x03,0x06,0x09,0x0c,0x10,0x14,0x16,0x17,
0x00,0x01,0x02,0x06,0x0a,0x0f,0x13,0x16,
0x03,0x06,0x08,0x09,0x0b,0x0f,0x13,0x16,
0x03,0x06,0x0a,0x0c,0x0d,0x0e,0x13,0x16,
0x03,0x06,0x0a,0x0f,0x10,0x11,0x12,0x16,
0x03,0x06,0x0a,0x0f,0x13,0x14,0x15,0x17,
0x03,0x04,0x05,0x07,0x0a,0x0f,0x13,0x16,
0x00,0x01,0x02,0x06,0x0b,0x0e,0x12,0x17,
0x03,0x06,0x08,0x09,0x0a,0x0e,0x12,0x17,
0x03,0x06,0x0b,0x0c,0x0d,0x0f,0x12,0x17,
0x03,0x06,0x0b,0x0e,0x10,0x11,0x13,0x17,
0x03,0x06,0x0b,0x0e,0x12,0x14,0x15,0x16,
0x03,0x04,0x05,0x07,0x0b,0x0e,0x12,0x17,
0x03,0x07,0x08,0x0d,0x0e,0x0f,0x13,0x17,
0x03,0x07,0x09,0x0a,0x0b,0x0c,0x13,0x17,
0x00,0x01,0x02,0x07,0x08,0x0c,0x13,0x17,
0x03,0x07,0x08,0x0c,0x10,0x11,0x12,0x17,
0x03,0x07,0x08,0x0c,0x13,0x14,0x15,0x16,
0x03,0x04,0x05,0x06,0x08,0x0c,0x13,0x17,
0x00,0x01,0x02,0x07,0x09,0x0d,0x12,0x16,
0x03,0x07,0x08,0x0a,0x0b,0x0d,0x12,0x16,
0x03,0x07,0x09,0x0c,0x0e,0x0f,0x12,0x16,
0x03,0x07,0x09,0x0d,0x10,0x11,0x13,0x16,
0x03,0x07,0x09,0x0d,0x12,0x14,0x15,0x17,
0x03,0x04,0x05,0x06,0x09,0x0d,0x12,0x16,
0x00,0x01,0x02,0x07,0x0a,0x0e,0x11,0x15,
0x03,0x07,0x08,0x09,0x0b,0x0e,0x11,0x15,
0x03,0x07,0x0a,0x0c,0x0d,0x0f,0x11,0x15,
0x03,0x07,0x0a,0x0e,0x10,0x12,0x13,0x15,
0x03,0x07,0x0a,0x0e,0x11,0x14,0x16,0x17,
0x03,0x04,0x05,0x06,0x0a,0x0e,0x11,0x15,
0x03,0x04,0x05,0x06,0x0b,0x0f,0x10,0x14,
0x03,0x07,0x0b,0x0f,0x10,0x15,0x16,0x17,
0x03,0x07,0x0b,0x0f,0x11,0x12,0x13,0x14,
0x00,0x01,0x02,0x07,0x0b,0x0f,0x10,0x14,
0x03,0x07,0x08,0x09,0x0a,0x0f,0x10,0x14,
0x03,0x07,0x0b,0x0c,0x0d,0x0e,0x10,0x14
};


/// @cond DO_NOT_DOCUMENT 


// Let o be an octad. Let {i},{j}, i != j be the even cocode word 
// which is a subset of octad  o,  such that precisely the i1-th and 
// the i2-th bit  of octad  o  is set, as in module mm_aux.c. Then 
// entry  8 * i + j  in the folllowing table is the number of the
// subocatad  {i},{j} in the standard numbering given in module
// mm_aux.c.
static const uint8_t MM_SUB_PERM64_TABLE[64] = { 
    // %%TABLE MM_PERM64_TABLE, uint8
0x00,0x01,0x02,0x04,0x08,0x10,0x20,0x3f,
0x01,0x00,0x03,0x05,0x09,0x11,0x21,0x3e,
0x02,0x03,0x00,0x06,0x0a,0x12,0x22,0x3d,
0x04,0x05,0x06,0x00,0x0c,0x14,0x24,0x3b,
0x08,0x09,0x0a,0x0c,0x00,0x18,0x28,0x37,
0x10,0x11,0x12,0x14,0x18,0x00,0x30,0x2f,
0x20,0x21,0x22,0x24,0x28,0x30,0x00,0x1f,
0x3f,0x3e,0x3d,0x3b,0x37,0x2f,0x1f,0x00
};


// Let o be an octad. Let b_0,...,b_7 be the elements of octad 
// o in natural order. Let x = sum 2**i * x_i, i = 0,...,7.
// Then sum (x_i * b_i) is a suboctad as defined in function
// mat24_suboctad_to_cocode() in module mat24_functions.c.  
// In that function we also define a natural numbering of the
// suboctads of an octad. Entry x of following table is the
// number of the suboctad sum (x_i * b_i) for 0 <= x < 128.
// Note that bit b_7 can be computed from bits b_0,...,b_6
// as the even parity bit.
static const uint8_t MM_SUBOCTAD_TABLE[128] = { 
    // %%TABLE MM_SUBOCTAD_TABLE, uint8
0x00,0x3f,0x3e,0x01,0x3d,0x02,0x03,0x3c,
0x3b,0x04,0x05,0x3a,0x06,0x39,0x38,0x07,
0x37,0x08,0x09,0x36,0x0a,0x35,0x34,0x0b,
0x0c,0x33,0x32,0x0d,0x31,0x0e,0x0f,0x30,
0x2f,0x10,0x11,0x2e,0x12,0x2d,0x2c,0x13,
0x14,0x2b,0x2a,0x15,0x29,0x16,0x17,0x28,
0x18,0x27,0x26,0x19,0x25,0x1a,0x1b,0x24,
0x23,0x1c,0x1d,0x22,0x1e,0x21,0x20,0x1f,
0x1f,0x20,0x21,0x1e,0x22,0x1d,0x1c,0x23,
0x24,0x1b,0x1a,0x25,0x19,0x26,0x27,0x18,
0x28,0x17,0x16,0x29,0x15,0x2a,0x2b,0x14,
0x13,0x2c,0x2d,0x12,0x2e,0x11,0x10,0x2f,
0x30,0x0f,0x0e,0x31,0x0d,0x32,0x33,0x0c,
0x0b,0x34,0x35,0x0a,0x36,0x09,0x08,0x37,
0x07,0x38,0x39,0x06,0x3a,0x05,0x04,0x3b,
0x3c,0x03,0x02,0x3d,0x01,0x3e,0x3f,0x00
};


/// @endcond 



/**********************************************************************
*** Subroutines for mm*_op_pi
**********************************************************************/

/**
  @brief Compute information for operation \f$x_\epsilon  x_\pi\f$
  
  Given an element  \f$x_\epsilon  x_\pi\f$ of the monster by 
  parameters ``eps`` and ``pi``, the function computes the
  relevant data for performing that operation on the representation
  of the monster. These data are stored in the structure of
  type ``mm_sub_op_pi_type`` referred by parameter ``p_op``.
*/
// %%EXPORT 
MM_BASICS_API
void  mm_sub_prep_pi(uint32_t eps, uint32_t pi, mm_sub_op_pi_type *p_op)
{
    uint16_t *p_24big = p_op->tbl_perm24_big;


    // Prepare permutation of the 2048 rows of 24 entries for tags X, Z, Y
    {
        uint32_t rep_autpl[12];
        p_op->eps = eps & 0xfff;
        p_op->pi = pi % MAT24_ORDER;
        mat24_m24num_to_perm(p_op->pi, p_op->perm);
        mat24_perm_to_iautpl(p_op->eps, p_op->perm, p_op->inv_perm, rep_autpl);
        mat24_op_all_autpl(rep_autpl, p_24big); 
    }

    // Prepare permutation of the 3 * 24 rows of 24 entries for tags A, B, C
    {
        uint_fast16_t i;
        for (i = 0; i < 24; ++i) {
            uint_fast16_t t = p_op->inv_perm[i];
            p_24big[i + 2048] = (uint16_t)t;   
            p_24big[i + 2048 + 24] = (uint16_t)(t + 24);   
            p_24big[i + 2048 + 48] 
                = (uint16_t)((t + 48) | ((eps & 0x800) << 4));  
        }
    }

    // Compute Benes network
    mat24_perm_to_net(p_op->perm, p_op->benes_net); 


    // Next deal with rows of 64 entries 
    {
        uint_fast16_t i, src;
        uint_fast8_t p_inv[24];
        mm_sub_op_pi64_type *p_out;
        const uint8_t *p0 = MM_SUB_OCTAD_ELEMENT_TABLE;

        p_out = p_op->tbl_perm64;
        for (i = 0; i < 24; ++i) p_inv[i] = p_op->inv_perm[i];
        eps &= 0x800;
        for (i = 0; i < 759; ++i) {
            {
                uint_fast16_t sign, dest;
                dest = mat24_def_octad_to_gcode(i);
                src =  ((dest & eps) << 1)
                      ^ p_24big[dest & 0x7ff];
                sign = src & 0x1000;
                src = src  & 0xfff;
                src = mat24_def_gcode_to_octad(src);
                p_out->preimage = (uint16_t)(src | sign);
            }
            {  // deal with permutation inside a row of 64 entries
                uint_fast8_t qi[24], acc;
                const uint8_t *p1 = MM_SUB_OCTAD_ELEMENT_TABLE + (src << 3);
                qi[p1[0]] = 0; qi[p1[1]] = 1; 
                qi[p1[2]] = 2; qi[p1[3]] = 3;
                qi[p1[4]] = 4; qi[p1[5]] = 5; 
                qi[p1[6]] = 6; qi[p1[7]] = 7;
                p1 = MM_SUB_PERM64_TABLE + (qi[p_inv[p0[0]]] << 3);
                acc =  p1[qi[p_inv[p0[1]]]];
                p_out->perm[0] = acc;
                acc ^=  p1[qi[p_inv[p0[2]]]];
                p_out->perm[1] = acc;
                acc ^=  p1[qi[p_inv[p0[3]]]];
                p_out->perm[2] = acc;
                acc ^=  p1[qi[p_inv[p0[4]]]];
                p_out->perm[3] = acc;
                acc ^=  p1[qi[p_inv[p0[5]]]];
                p_out->perm[4] = acc;
                acc ^=  p1[qi[p_inv[p0[6]]]];
                p_out->perm[5] = acc;
            }
            p0 += 8;
            ++p_out;
        }
    }

}

/**
  @brief For internal use only!
  
  This is an auxiliary function for testing function ``mm_sub_prep_pi``.

  Given ``eps`` and ``pi`` as in function ``mm_sub_prep_pi``, 
  this function executes function ``mm_sub_prep_p(eps, pi, p_op)``
  and stores the output ``p_op->tbl_perm64`` (as an array
  of  length  759 * (1 + 6)) in the array referred by ``p_tbl``. 

*/
// %%EXPORT px
MM_BASICS_API
void  mm_sub_test_prep_pi_64(uint32_t eps, uint32_t pi, uint32_t *p_tbl)
{
    mm_sub_op_pi_type op_pi;
    uint_fast32_t i,j;
    mm_sub_prep_pi(eps, pi, &op_pi);
    for (i = 0; i < 759; ++i) {
        p_tbl[0] = op_pi.tbl_perm64[i].preimage;
        for (j = 0; j < 6; ++j)  p_tbl[j+1] = op_pi.tbl_perm64[i].perm[j];
        p_tbl += 7;
    }
}




/**********************************************************************
*** Subroutines for mm*_op_xy
**********************************************************************/

/// @cond DO_NOT_DOCUMENT 

#define PwrMapH(d) (MAT24_THETA_TABLE[d])
#define PwrMap(d) ((MAT24_THETA_TABLE[(d) & 0x7ff] >> 12) & 1)
    
// Compute interssection of vector ``v`` in ``{0,1}^24`` and the
// octad referred by the pointer ``po`` to an antry of the
// octad table ``MM_SUB_OCTAD_ELEMENT_TABLEE``. Return the
// result as a 6-bit number denoting a suboctad.
#define to_suboctad(v, po) MM_SUBOCTAD_TABLE[ \
    ((v >> po[0]) & 1) + ((v >> (po[1] - 1)) & 2) \
    + ((v >> (po[2] - 2)) & 4) + ((v >> (po[3] - 3)) & 8) \
    + ((v >> (po[4] - 4)) & 16) + ((v >> (po[5] - 5)) & 32) \
    + ((v >> (po[6] - 6)) & 64) ]

/// @endcond  

/**
  @brief Compute information for operation \f$y_f x_e x_\epsilon\f$
  
  Given an element  \f$y_f x_e x_\epsilon\f$ of the monster by 
  parameters ``f``, ``e``, and ``eps``, the function computes the
  relevant data for performing that operation on the representation
  of the monster. These data are stored in the structure of
  type ``mm_sub_op_xy_type`` referred by parameter ``p_op``.
*/
// %%EXPORT 
MM_BASICS_API
void  mm_sub_prep_xy(uint32_t f, uint32_t e, uint32_t eps, mm_sub_op_xy_type *p_op)
{
    p_op->f = f = f & 0x1fff;            
    p_op->e = e = e & 0x1fff; 
    p_op->eps = eps = eps & 0xfff; 

    {
        uint_fast16_t ld0 = eps ^ mat24_ploop_cap(e, f) 
                                ^ mat24_ploop_theta(f);
        uint_fast16_t ld2 = eps ^ mat24_ploop_theta(e);
        uint_fast16_t ld1 = ld2 ^ mat24_ploop_theta(f);
        uint_fast8_t *p_XYZ = p_op->sign_XYZ;
        uint_fast16_t li, i, v, j;

        p_op->lin_i[0] = mat24_gcode_to_vect(e);
        p_op->lin_i[1] = p_op->lin_i[2] = p_op->f_i
                       = mat24_gcode_to_vect(f);
        p_op->ef_i = p_op->lin_i[0] ^ p_op->f_i;
        p_XYZ[0] = (uint_fast8_t)(
            (PwrMap(f) ^ PwrMap(e ^ f) ^ (f >> 12) ) 
            ^ ((mat24_ploop_cocycle(f, e) ^ ((e ^ f) >> 12)) << 1)
            ^ (((PwrMap(f) ^ (e >> 12) ^ (e >> 11)) & 1) << 2) 
            );

        for (li = 0; li < 11; ++li) {
            i = 1 << li ;
            v = ((ld0 >> li) & 1) + (((ld1 >> li) & 1) << 1)
              + (((ld2 >> li) & 1) << 2);
            for (j = 0; j < i; ++j) {
                p_XYZ[i + j] = (uint_fast8_t)(p_XYZ[j] ^ v);
            }
        }
    }

    {
        uint_fast16_t e1 = (e & 0x7ff);
        uint_fast16_t ef1 = ((e ^ f) & 0x7ff);
        uint_fast16_t eps1 = ((eps & 0x800) ^ 0x800) << 1; 
        uint_fast8_t *p_XYZ = p_op->sign_XYZ;
        uint_fast16_t d;

        for (d = 0; d < 2048; ++d) {
            p_XYZ[d] ^= ((-(PwrMapH(d ^ ef1) & 0x1000)) >> 12)
                     ^ ((-(PwrMapH(d ^ e1) & 0x1000)) >> 11) 
                     ^  ((PwrMapH(d) & eps1) >> 12);
        }
        p_op->lin_d[0] = e1 ^ ef1;
        p_op->lin_d[1] = ef1;
        p_op->lin_d[2] = e1;
    }

    {
        uint_fast32_t vf =  p_op->lin_i[1]; 
        uint_fast32_t vef = vf ^ p_op->lin_i[0];
        uint_fast16_t sign_e = PwrMap(e);
        uint_fast16_t oct, d, res, sign;
        const uint8_t* p_oct = MM_SUB_OCTAD_ELEMENT_TABLE;
        uint16_t* p_res = p_op->s_T;

        for (oct = 0; oct < 759; ++oct) {
            d = mat24_def_octad_to_gcode(oct);
            res = to_suboctad(vf, p_oct); 
            res ^= (to_suboctad(vef, p_oct)) << 8;
            sign = d & eps;
            sign ^= sign >> 6; sign ^= sign >> 3; 
            sign = (0x96 >> (sign & 7)) & 1;
            sign ^= sign_e ^ PwrMap(d ^ e);
            *p_res++ = (uint16_t)(
                res + (sign << 14) + ((eps & 0x800) << (15-11)));
            p_oct += 8;
        }
    }
}




/// @cond DO_NOT_DOCUMENT 

// %%EXPORT px
MM_BASICS_API
void  mm_sub_test_prep_xy(uint32_t f, uint32_t e, uint32_t eps, uint32_t n, uint32_t *p_tbl)
// Auxiliary function for debugging. Given eps and pi as in 
// function mm_sub_prep_pi(), various components (dependding
// on n) in structure mm_sub_prep_p are stored to p_tbl[]. 
{
    mm_sub_op_xy_type op_xy;
    uint_fast32_t i;
    mm_sub_prep_xy(f, e, eps, &op_xy);
    switch(n) {
        case 1:
            for (i = 0; i < 3; ++i) {
                p_tbl[i] = op_xy.lin_i[i];
                p_tbl[i + 3] = op_xy.lin_d[i];
            }
            break;
        case 2:
            for (i = 0; i < 2048; ++i) p_tbl[i] = op_xy.sign_XYZ[i];
            break;
        case 3:
            for (i = 0; i < 759; ++i) p_tbl[i] = op_xy.s_T[i];
            break;
        default:
            break;
    } 
}

/// @endcond 


//  %%GEN h
//  %%GEN c


// %%GEN ch
#ifdef __cplusplus
}
#endif
//  %%GEN c



