import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendStsRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS account ID to be associated with STS role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role#account_id AwsAuthBackendStsRole#account_id}
    */
    readonly accountId: string;
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role#backend AwsAuthBackendStsRole#backend}
    */
    readonly backend?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role#id AwsAuthBackendStsRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role#namespace AwsAuthBackendStsRole#namespace}
    */
    readonly namespace?: string;
    /**
    * AWS ARN for STS role to be assumed when interacting with the account specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role#sts_role AwsAuthBackendStsRole#sts_role}
    */
    readonly stsRole: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role vault_aws_auth_backend_sts_role}
*/
export declare class AwsAuthBackendStsRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_sts_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_sts_role vault_aws_auth_backend_sts_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendStsRoleConfig
    */
    constructor(scope: Construct, id: string, config: AwsAuthBackendStsRoleConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _stsRole?;
    get stsRole(): string;
    set stsRole(value: string);
    get stsRoleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
