import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultAwsAccessCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS Secret Backend to read credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#backend DataVaultAwsAccessCredentials#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#id DataVaultAwsAccessCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#namespace DataVaultAwsAccessCredentials#namespace}
    */
    readonly namespace?: string;
    /**
    * Region the read credentials belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#region DataVaultAwsAccessCredentials#region}
    */
    readonly region?: string;
    /**
    * AWS Secret Role to read credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#role DataVaultAwsAccessCredentials#role}
    */
    readonly role: string;
    /**
    * ARN to use if multiple are available in the role. Required if the role has multiple ARNs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#role_arn DataVaultAwsAccessCredentials#role_arn}
    */
    readonly roleArn?: string;
    /**
    * User specified Time-To-Live for the STS token. Uses the Role defined default_sts_ttl when not specified
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#ttl DataVaultAwsAccessCredentials#ttl}
    */
    readonly ttl?: string;
    /**
    * Type of credentials to read. Must be either 'creds' for Access Key and Secret Key, or 'sts' for STS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials#type DataVaultAwsAccessCredentials#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials vault_aws_access_credentials}
*/
export declare class DataVaultAwsAccessCredentials extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_aws_access_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/aws_access_credentials vault_aws_access_credentials} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultAwsAccessCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultAwsAccessCredentialsConfig);
    get accessKey(): string;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get leaseDuration(): number;
    get leaseId(): string;
    get leaseRenewable(): cdktf.IResolvable;
    get leaseStartTime(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    resetRoleArn(): void;
    get roleArnInput(): string | undefined;
    get secretKey(): string;
    get securityToken(): string;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
