"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubAuthBackend = exports.GithubAuthBackendTuneList = exports.GithubAuthBackendTuneOutputReference = exports.githubAuthBackendTuneToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function githubAuthBackendTuneToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_response_headers: struct.allowedResponseHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedResponseHeaders),
        audit_non_hmac_request_keys: struct.auditNonHmacRequestKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.auditNonHmacRequestKeys),
        audit_non_hmac_response_keys: struct.auditNonHmacResponseKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.auditNonHmacResponseKeys),
        default_lease_ttl: struct.defaultLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.defaultLeaseTtl),
        listing_visibility: struct.listingVisibility === undefined ? null : cdktf.stringToTerraform(struct.listingVisibility),
        max_lease_ttl: struct.maxLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.maxLeaseTtl),
        passthrough_request_headers: struct.passthroughRequestHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.passthroughRequestHeaders),
        token_type: struct.tokenType === undefined ? null : cdktf.stringToTerraform(struct.tokenType),
    };
}
exports.githubAuthBackendTuneToTerraform = githubAuthBackendTuneToTerraform;
class GithubAuthBackendTuneOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedResponseHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedResponseHeaders = this._allowedResponseHeaders;
        }
        if (this._auditNonHmacRequestKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacRequestKeys = this._auditNonHmacRequestKeys;
        }
        if (this._auditNonHmacResponseKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacResponseKeys = this._auditNonHmacResponseKeys;
        }
        if (this._defaultLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultLeaseTtl = this._defaultLeaseTtl;
        }
        if (this._listingVisibility !== undefined) {
            hasAnyValues = true;
            internalValueResult.listingVisibility = this._listingVisibility;
        }
        if (this._maxLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxLeaseTtl = this._maxLeaseTtl;
        }
        if (this._passthroughRequestHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.passthroughRequestHeaders = this._passthroughRequestHeaders;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = undefined;
            this._auditNonHmacRequestKeys = undefined;
            this._auditNonHmacResponseKeys = undefined;
            this._defaultLeaseTtl = undefined;
            this._listingVisibility = undefined;
            this._maxLeaseTtl = undefined;
            this._passthroughRequestHeaders = undefined;
            this._tokenType = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = value.allowedResponseHeaders;
            this._auditNonHmacRequestKeys = value.auditNonHmacRequestKeys;
            this._auditNonHmacResponseKeys = value.auditNonHmacResponseKeys;
            this._defaultLeaseTtl = value.defaultLeaseTtl;
            this._listingVisibility = value.listingVisibility;
            this._maxLeaseTtl = value.maxLeaseTtl;
            this._passthroughRequestHeaders = value.passthroughRequestHeaders;
            this._tokenType = value.tokenType;
        }
    }
    get allowedResponseHeaders() {
        return this.getListAttribute('allowed_response_headers');
    }
    set allowedResponseHeaders(value) {
        this._allowedResponseHeaders = value;
    }
    resetAllowedResponseHeaders() {
        this._allowedResponseHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedResponseHeadersInput() {
        return this._allowedResponseHeaders;
    }
    get auditNonHmacRequestKeys() {
        return this.getListAttribute('audit_non_hmac_request_keys');
    }
    set auditNonHmacRequestKeys(value) {
        this._auditNonHmacRequestKeys = value;
    }
    resetAuditNonHmacRequestKeys() {
        this._auditNonHmacRequestKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacRequestKeysInput() {
        return this._auditNonHmacRequestKeys;
    }
    get auditNonHmacResponseKeys() {
        return this.getListAttribute('audit_non_hmac_response_keys');
    }
    set auditNonHmacResponseKeys(value) {
        this._auditNonHmacResponseKeys = value;
    }
    resetAuditNonHmacResponseKeys() {
        this._auditNonHmacResponseKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacResponseKeysInput() {
        return this._auditNonHmacResponseKeys;
    }
    get defaultLeaseTtl() {
        return this.getStringAttribute('default_lease_ttl');
    }
    set defaultLeaseTtl(value) {
        this._defaultLeaseTtl = value;
    }
    resetDefaultLeaseTtl() {
        this._defaultLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlInput() {
        return this._defaultLeaseTtl;
    }
    get listingVisibility() {
        return this.getStringAttribute('listing_visibility');
    }
    set listingVisibility(value) {
        this._listingVisibility = value;
    }
    resetListingVisibility() {
        this._listingVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get listingVisibilityInput() {
        return this._listingVisibility;
    }
    get maxLeaseTtl() {
        return this.getStringAttribute('max_lease_ttl');
    }
    set maxLeaseTtl(value) {
        this._maxLeaseTtl = value;
    }
    resetMaxLeaseTtl() {
        this._maxLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlInput() {
        return this._maxLeaseTtl;
    }
    get passthroughRequestHeaders() {
        return this.getListAttribute('passthrough_request_headers');
    }
    set passthroughRequestHeaders(value) {
        this._passthroughRequestHeaders = value;
    }
    resetPassthroughRequestHeaders() {
        this._passthroughRequestHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passthroughRequestHeadersInput() {
        return this._passthroughRequestHeaders;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
}
exports.GithubAuthBackendTuneOutputReference = GithubAuthBackendTuneOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GithubAuthBackendTuneOutputReference[_a] = { fqn: "@cdktf/provider-vault.GithubAuthBackendTuneOutputReference", version: "0.0.15" };
class GithubAuthBackendTuneList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new GithubAuthBackendTuneOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.GithubAuthBackendTuneList = GithubAuthBackendTuneList;
_b = JSII_RTTI_SYMBOL_1;
GithubAuthBackendTuneList[_b] = { fqn: "@cdktf/provider-vault.GithubAuthBackendTuneList", version: "0.0.15" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend vault_github_auth_backend}
*/
class GithubAuthBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend vault_github_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GithubAuthBackendConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_github_auth_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // tune - computed: true, optional: true, required: false
        this._tune = new GithubAuthBackendTuneList(this, "tune", true);
        this._baseUrl = config.baseUrl;
        this._description = config.description;
        this._id = config.id;
        this._namespace = config.namespace;
        this._organization = config.organization;
        this._organizationId = config.organizationId;
        this._path = config.path;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
        this._tune.internalValue = config.tune;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get baseUrl() {
        return this.getStringAttribute('base_url');
    }
    set baseUrl(value) {
        this._baseUrl = value;
    }
    resetBaseUrl() {
        this._baseUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseUrlInput() {
        return this._baseUrl;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get organization() {
        return this.getStringAttribute('organization');
    }
    set organization(value) {
        this._organization = value;
    }
    // Temporarily expose input value. Use with caution.
    get organizationInput() {
        return this._organization;
    }
    get organizationId() {
        return this.getNumberAttribute('organization_id');
    }
    set organizationId(value) {
        this._organizationId = value;
    }
    resetOrganizationId() {
        this._organizationId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get organizationIdInput() {
        return this._organizationId;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get tune() {
        return this._tune;
    }
    putTune(value) {
        this._tune.internalValue = value;
    }
    resetTune() {
        this._tune.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tuneInput() {
        return this._tune.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            base_url: cdktf.stringToTerraform(this._baseUrl),
            description: cdktf.stringToTerraform(this._description),
            id: cdktf.stringToTerraform(this._id),
            namespace: cdktf.stringToTerraform(this._namespace),
            organization: cdktf.stringToTerraform(this._organization),
            organization_id: cdktf.numberToTerraform(this._organizationId),
            path: cdktf.stringToTerraform(this._path),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
            tune: cdktf.listMapper(githubAuthBackendTuneToTerraform)(this._tune.internalValue),
        };
    }
}
exports.GithubAuthBackend = GithubAuthBackend;
_c = JSII_RTTI_SYMBOL_1;
GithubAuthBackend[_c] = { fqn: "@cdktf/provider-vault.GithubAuthBackend", version: "0.0.15" };
// =================
// STATIC PROPERTIES
// =================
GithubAuthBackend.tfResourceType = "vault_github_auth_backend";
//# sourceMappingURL=data:application/json;base64,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