import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NomadSecretRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The mount path for the Nomad backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#backend NomadSecretRole#backend}
    */
    readonly backend: string;
    /**
    * Specifies if the token should be global.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#global NomadSecretRole#global}
    */
    readonly global?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#id NomadSecretRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#namespace NomadSecretRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Comma separated list of Nomad policies the token is going to be created against. These need to be created beforehand in Nomad.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#policies NomadSecretRole#policies}
    */
    readonly policies?: string[];
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#role NomadSecretRole#role}
    */
    readonly role: string;
    /**
    * Specifies the type of token to create when using this role. Valid values are "client" or "management".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role#type NomadSecretRole#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role vault_nomad_secret_role}
*/
export declare class NomadSecretRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_nomad_secret_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_role vault_nomad_secret_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NomadSecretRoleConfig
    */
    constructor(scope: Construct, id: string, config: NomadSecretRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _global?;
    get global(): boolean | cdktf.IResolvable;
    set global(value: boolean | cdktf.IResolvable);
    resetGlobal(): void;
    get globalInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
