import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of alternative names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#alt_names PkiSecretBackendCert#alt_names}
    */
    readonly altNames?: string[];
    /**
    * If enabled, a new certificate will be generated if the expiration is within min_seconds_remaining
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#auto_renew PkiSecretBackendCert#auto_renew}
    */
    readonly autoRenew?: boolean | cdktf.IResolvable;
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#backend PkiSecretBackendCert#backend}
    */
    readonly backend: string;
    /**
    * CN of the certificate to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#common_name PkiSecretBackendCert#common_name}
    */
    readonly commonName: string;
    /**
    * Flag to exclude CN from SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#exclude_cn_from_sans PkiSecretBackendCert#exclude_cn_from_sans}
    */
    readonly excludeCnFromSans?: boolean | cdktf.IResolvable;
    /**
    * The format of data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#format PkiSecretBackendCert#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#id PkiSecretBackendCert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of alternative IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#ip_sans PkiSecretBackendCert#ip_sans}
    */
    readonly ipSans?: string[];
    /**
    * Generate a new certificate when the expiration is within this number of seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#min_seconds_remaining PkiSecretBackendCert#min_seconds_remaining}
    */
    readonly minSecondsRemaining?: number;
    /**
    * Name of the role to create the certificate against.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#name PkiSecretBackendCert#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#namespace PkiSecretBackendCert#namespace}
    */
    readonly namespace?: string;
    /**
    * List of other SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#other_sans PkiSecretBackendCert#other_sans}
    */
    readonly otherSans?: string[];
    /**
    * The private key format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#private_key_format PkiSecretBackendCert#private_key_format}
    */
    readonly privateKeyFormat?: string;
    /**
    * Revoke the certificate upon resource destruction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#revoke PkiSecretBackendCert#revoke}
    */
    readonly revoke?: boolean | cdktf.IResolvable;
    /**
    * Time to live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#ttl PkiSecretBackendCert#ttl}
    */
    readonly ttl?: string;
    /**
    * List of alternative URIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert#uri_sans PkiSecretBackendCert#uri_sans}
    */
    readonly uriSans?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert vault_pki_secret_backend_cert}
*/
export declare class PkiSecretBackendCert extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_cert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert vault_pki_secret_backend_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendCertConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendCertConfig);
    private _altNames?;
    get altNames(): string[];
    set altNames(value: string[]);
    resetAltNames(): void;
    get altNamesInput(): string[] | undefined;
    private _autoRenew?;
    get autoRenew(): boolean | cdktf.IResolvable;
    set autoRenew(value: boolean | cdktf.IResolvable);
    resetAutoRenew(): void;
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get caChain(): string;
    get certificate(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _excludeCnFromSans?;
    get excludeCnFromSans(): boolean | cdktf.IResolvable;
    set excludeCnFromSans(value: boolean | cdktf.IResolvable);
    resetExcludeCnFromSans(): void;
    get excludeCnFromSansInput(): boolean | cdktf.IResolvable | undefined;
    get expiration(): number;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipSans?;
    get ipSans(): string[];
    set ipSans(value: string[]);
    resetIpSans(): void;
    get ipSansInput(): string[] | undefined;
    get issuingCa(): string;
    private _minSecondsRemaining?;
    get minSecondsRemaining(): number;
    set minSecondsRemaining(value: number);
    resetMinSecondsRemaining(): void;
    get minSecondsRemainingInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _otherSans?;
    get otherSans(): string[];
    set otherSans(value: string[]);
    resetOtherSans(): void;
    get otherSansInput(): string[] | undefined;
    get privateKey(): string;
    private _privateKeyFormat?;
    get privateKeyFormat(): string;
    set privateKeyFormat(value: string);
    resetPrivateKeyFormat(): void;
    get privateKeyFormatInput(): string | undefined;
    get privateKeyType(): string;
    private _revoke?;
    get revoke(): boolean | cdktf.IResolvable;
    set revoke(value: boolean | cdktf.IResolvable);
    resetRevoke(): void;
    get revokeInput(): boolean | cdktf.IResolvable | undefined;
    get serialNumber(): string;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _uriSans?;
    get uriSans(): string[];
    set uriSans(value: string[]);
    resetUriSans(): void;
    get uriSansInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
